/*
 * Decompiled with CFR 0.152.
 */
package oms3.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class CSVTableWriter {
    PrintWriter w;

    public CSVTableWriter(Writer s, String name, String[][] meta) {
        this.w = new PrintWriter(s);
        this.w.println("@T," + name);
        if (meta != null) {
            for (String[] key : meta) {
                this.w.println(" " + key[0] + ", " + key[1]);
            }
        }
    }

    public CSVTableWriter(Writer s, String name, Map<String, String> meta) {
        this.w = new PrintWriter(s);
        this.w.println("@T," + name);
        if (meta != null) {
            for (String key : meta.keySet()) {
                this.w.println(" " + key + ", " + meta.get(key));
            }
        }
    }

    public CSVTableWriter(OutputStream s, String name, String[][] meta) {
        this((Writer)new OutputStreamWriter(s), name, meta);
    }

    public CSVTableWriter(File file, String name) throws IOException {
        this((Writer)new FileWriter(file), name, (String[][])null);
    }

    public void writeHeader(String ... col) {
        this.writeHeader((String[][])null, col);
    }

    public void writeHeader(Map<String, String[]> meta, List<String> col) {
        this.writeHeader(meta, col.toArray(new String[0]));
    }

    public void writeHeader(Map<String, String[]> meta, String ... col) {
        this.w.print("@H");
        this.writeRow((Object[])col);
        if (meta != null) {
            for (String key : meta.keySet()) {
                this.w.print(" " + key);
                this.writeRow((Object[])meta.get(key));
            }
        }
    }

    public void writeHeader(String[][] meta, String ... col) {
        this.w.print("@H");
        this.writeRow((Object[])col);
        if (meta != null) {
            for (String[] key : meta) {
                this.w.print(" " + key[0]);
                for (int i = 1; i < key.length; ++i) {
                    this.w.print(", " + key[i]);
                }
                this.w.println();
            }
        }
    }

    public void writeRow(Object ... val) {
        for (Object v : val) {
            this.w.print(",");
            this.w.print(v == null ? "" : v);
        }
        this.w.println();
    }

    public void writeRow(Object[] val, int startCol) {
        for (int i = startCol; i < val.length; ++i) {
            this.w.print(",");
            this.w.print(val[i] == null ? "" : val[i]);
        }
        this.w.println();
    }

    public void writeRow(List<?> val) {
        for (Object v : val) {
            this.w.print(",");
            this.w.print((Object)(v == null ? "" : v));
        }
        this.w.println();
    }

    public void writeRows(List<String[]> val) {
        for (String[] v : val) {
            this.writeRow((Object[])v);
        }
    }

    public void writeRows(List<String[]> val, int startCol) {
        for (String[] v : val) {
            this.writeRow((Object[])v, startCol);
        }
    }

    public void close() {
        this.w.flush();
    }

    public static void main(String[] args) {
        CSVTableWriter w = new CSVTableWriter(System.out, "Olaf", (String[][])new String[][]{{"unit", "mm"}, {"key", "value1"}});
        w.writeHeader(new String[][]{{"unit", "mm", "name", "val"}, {"format", "mm", "fff", "ffff"}}, "temp", "olaf", "precip");
        w.writeRow(1.3, "olaf", 5.23);
        w.writeRow(1.3, "olaf", 5.23);
        w.writeRow(1.3, "olaf", 5.23);
        w.close();
    }
}

