/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.util.logging.Level;
import java.util.logging.Logger;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class TallyStore
extends Tally {
    private DoubleArrayList array = null;
    private Logger log = Logger.getLogger("umontreal.iro.lecuyer.stat");

    public TallyStore() {
        this.array = new DoubleArrayList();
    }

    public TallyStore(String name) {
        super(name);
        this.array = new DoubleArrayList();
    }

    public TallyStore(int capacity) {
        this.array = new DoubleArrayList(capacity);
    }

    public TallyStore(String name, int capacity) {
        super(name);
        this.array = new DoubleArrayList(capacity);
    }

    public TallyStore(DoubleArrayList a) {
        this.array = a;
        this.array.clear();
    }

    public void init() {
        super.init();
        if (this.array != null) {
            this.array.clear();
        }
    }

    public void add(double x) {
        if (this.collect) {
            this.array.add(x);
        }
        super.add(x);
    }

    public double[] getArray() {
        this.array.trimToSize();
        return this.array.elements();
    }

    public DoubleArrayList getDoubleArrayList() {
        this.array.trimToSize();
        return this.array;
    }

    public void quickSort() {
        this.array.quickSort();
    }

    public double covariance(TallyStore t2) {
        if (this.numberObs() != t2.numberObs()) {
            this.log.logp(Level.WARNING, "TallyStore", "covariance", "This tally, with name " + this.getName() + ", contains " + this.numberObs() + " observations while " + "the given tally, with name " + t2.getName() + ", contains " + t2.numberObs() + "observations");
            return Double.NaN;
        }
        if (this.numberObs() < 2 || t2.numberObs() < 2) {
            this.log.logp(Level.WARNING, "TallyStore", "covariance", "This tally, with name " + this.getName() + ", contains " + this.numberObs() + " observation");
            return Double.NaN;
        }
        return Descriptive.covariance(this.getDoubleArrayList(), t2.getDoubleArrayList());
    }

    public TallyStore clone() {
        TallyStore t = (TallyStore)super.clone();
        t.array = (DoubleArrayList)this.array.clone();
        return t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.numberObs(); ++i) {
            sb.append(i + "    " + this.array.getQuick(i) + PrintfFormat.NEWLINE);
        }
        return sb.toString();
    }
}

