/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.GumbelDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class GumbelGen
extends RandomVariateGen {
    private double delta;
    private double beta;

    public GumbelGen(RandomStream s) {
        this(s, 1.0, 0.0);
    }

    public GumbelGen(RandomStream s, double beta, double delta) {
        super(s, new GumbelDist(beta, delta));
        this.setParams(beta, delta);
    }

    public GumbelGen(RandomStream s, GumbelDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getBeta(), dist.getDelta());
        }
    }

    public static double nextDouble(RandomStream s, double beta, double delta) {
        return GumbelDist.inverseF(beta, delta, s.nextDouble());
    }

    public double getBeta() {
        return this.beta;
    }

    public double getDelta() {
        return this.delta;
    }

    protected void setParams(double beta, double delta) {
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        this.delta = delta;
        this.beta = beta;
    }
}

