/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.xml.bind.WhiteSpaceProcessor;
import com.sun.xml.bind.v2.runtime.ClassBeanInfoImpl;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorExWrapper;
import com.sun.xml.bind.v2.runtime.unmarshaller.StructureLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.unmarshaller.XmlVisitor;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshallerHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class SAXConnector
implements UnmarshallerHandler {
    private LocatorEx loc;
    private final StringBuilder buffer = new StringBuilder();
    private final XmlVisitor next;
    private final UnmarshallingContext context;
    private final XmlVisitor.TextPredictor predictor;
    private final TagNameImpl tagName = new TagNameImpl();

    public SAXConnector(XmlVisitor next, LocatorEx externalLocator) {
        this.next = next;
        this.context = next.getContext();
        this.predictor = next.getPredictor();
        this.loc = externalLocator;
    }

    public Object getResult() throws JAXBException, IllegalStateException {
        return this.context.getResult();
    }

    public UnmarshallingContext getContext() {
        return this.context;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.loc != null) {
            return;
        }
        this.loc = new LocatorExWrapper(locator);
    }

    public void startDocument() throws SAXException {
        this.next.startDocument(this.loc, null);
    }

    public void endDocument() throws SAXException {
        this.next.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.next.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.next.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String local, String qname2, Attributes atts) throws SAXException {
        if (uri == null || uri.length() == 0) {
            uri = "";
        }
        if (local == null || local.length() == 0) {
            local = qname2;
        }
        if (qname2 == null || qname2.length() == 0) {
            qname2 = local;
        }
        boolean ignorable = true;
        StructureLoader sl = this.context.getStructureLoader();
        if (sl != null) {
            ignorable = ((ClassBeanInfoImpl)sl.getBeanInfo()).hasElementOnlyContentModel();
        }
        this.processText(ignorable);
        this.tagName.uri = uri;
        this.tagName.local = local;
        this.tagName.qname = qname2;
        this.tagName.atts = atts;
        this.next.startElement(this.tagName);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.processText(false);
        this.tagName.uri = uri;
        this.tagName.local = localName;
        this.tagName.qname = qName;
        this.next.endElement(this.tagName);
    }

    public final void characters(char[] buf, int start, int len) {
        if (this.predictor.expectText()) {
            this.buffer.append(buf, start, len);
        }
    }

    public final void ignorableWhitespace(char[] buf, int start, int len) {
        this.characters(buf, start, len);
    }

    public void processingInstruction(String target, String data) {
    }

    public void skippedEntity(String name) {
    }

    private void processText(boolean ignorable) throws SAXException {
        if (!(!this.predictor.expectText() || ignorable && WhiteSpaceProcessor.isWhiteSpace(this.buffer))) {
            this.next.text(this.buffer);
        }
        this.buffer.setLength(0);
    }

    private static final class TagNameImpl
    extends TagName {
        String qname;

        private TagNameImpl() {
        }

        @Override
        public String getQname() {
            return this.qname;
        }
    }
}

