/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import net.java.balloontip.styles.BalloonTipStyle;

public class ModernBalloonStyle
extends BalloonTipStyle {
    private int arcWidth;
    private int arcHeight;
    private boolean topLeft = true;
    private boolean topRight = false;
    boolean bottomLeft = false;
    boolean bottomRight = true;
    private int borderThickness = 1;
    private boolean AAenabled = false;
    private Color topFillColor;
    private Color bottomFillColor;
    private Color borderColor;

    public ModernBalloonStyle(int n, int n2, Color color, Color color2, Color color3) {
        this.arcWidth = n;
        this.arcHeight = n2;
        this.topFillColor = color;
        this.bottomFillColor = color2;
        this.borderColor = color3;
    }

    public void setCornerStyles(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.topLeft = bl;
        this.topRight = bl2;
        this.bottomLeft = bl3;
        this.bottomRight = bl4;
    }

    public void setBorderThickness(int n) {
        this.borderThickness = n;
    }

    public void enableAntiAliasing(boolean bl) {
        this.AAenabled = bl;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + this.arcHeight, this.arcWidth, this.arcHeight, this.arcWidth);
        }
        return new Insets(this.arcHeight, this.arcWidth, this.arcHeight + this.verticalOffset, this.arcWidth);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.AAenabled) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        n += this.borderThickness - 1;
        n2 += this.borderThickness - 1;
        n3 -= this.borderThickness * 2;
        n4 -= this.borderThickness * 2;
        if (this.flipY) {
            n6 = n2 + this.verticalOffset;
            n5 = n2 + n4;
        } else {
            n6 = n2;
            n5 = n2 + n4 - this.verticalOffset;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n + this.arcWidth, n6);
        if (this.topLeft) {
            generalPath.quadTo(n, n6, n, n6 + this.arcHeight);
        } else {
            generalPath.lineTo(n, n6);
            generalPath.lineTo(n, n6 + this.arcHeight);
        }
        generalPath.lineTo(n, n5 - this.arcHeight);
        if (this.bottomLeft) {
            generalPath.quadTo(n, n5, n + this.arcWidth, n5);
        } else {
            generalPath.lineTo(n, n5);
            generalPath.lineTo(n + this.arcWidth, n5);
        }
        if (!this.flipX && !this.flipY) {
            generalPath.lineTo(n + this.horizontalOffset, n5);
            generalPath.lineTo(n + this.horizontalOffset, n5 + this.verticalOffset);
            generalPath.lineTo(n + this.horizontalOffset + this.verticalOffset, n5);
        } else if (this.flipX && !this.flipY) {
            generalPath.lineTo(n + n3 - this.horizontalOffset - this.verticalOffset, n5);
            generalPath.lineTo(n + n3 - this.horizontalOffset, n5 + this.verticalOffset);
            generalPath.lineTo(n + n3 - this.horizontalOffset, n5);
        }
        generalPath.lineTo(n + n3 - this.arcWidth, n5);
        if (this.bottomRight) {
            generalPath.quadTo(n + n3, n5, n + n3, n5 - this.arcHeight);
        } else {
            generalPath.lineTo(n + n3, n5);
            generalPath.lineTo(n + n3, n5 - this.arcHeight);
        }
        generalPath.lineTo(n + n3, n6 + this.arcHeight);
        if (this.topRight) {
            generalPath.quadTo(n + n3, n6, n + n3 - this.arcWidth, n6);
        } else {
            generalPath.lineTo(n + n3, n6);
            generalPath.lineTo(n + n3 - this.arcWidth, n6);
        }
        if (!this.flipX && this.flipY) {
            generalPath.lineTo(n + this.horizontalOffset + this.verticalOffset, n6);
            generalPath.lineTo(n + this.horizontalOffset, n6 - this.verticalOffset);
            generalPath.lineTo(n + this.horizontalOffset, n6);
        } else if (this.flipX && this.flipY) {
            generalPath.lineTo(n + n3 - this.horizontalOffset, n6);
            generalPath.lineTo(n + n3 - this.horizontalOffset, n6 - this.verticalOffset);
            generalPath.lineTo(n + n3 - this.horizontalOffset - this.verticalOffset, n6);
        }
        generalPath.closePath();
        graphics2D.setPaint(new GradientPaint(0.0f, n6, this.topFillColor, 0.0f, n5, this.bottomFillColor));
        graphics2D.fill(generalPath);
        graphics2D.setPaint(this.borderColor);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(this.borderThickness));
        graphics2D.draw(generalPath);
        graphics2D.setStroke(stroke);
    }

    @Override
    public int getMinimalHorizontalOffset() {
        return this.arcWidth + this.verticalOffset + this.borderThickness;
    }
}

