/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.language.reflection.MethodSignature;

public class SerializableMethod
implements Serializable {
    private Method method = null;

    public SerializableMethod(Method method) {
        this.method = method;
    }

    public SerializableMethod(Class clazz, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        this.method = ClassUtil.resolveMethod(clazz, methodName, parameterTypes);
    }

    public Method deSerialize() {
        return this.method;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(this.method.getDeclaringClass());
            out.writeObject(this.method.getName());
            out.writeObject(new MethodSignature(this.method));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            Class declaringClass = (Class)in.readObject();
            String methodName = (String)in.readObject();
            MethodSignature signature = (MethodSignature)in.readObject();
            this.method = ClassUtil.resolveMethod(declaringClass, methodName, signature.getParameterTypes());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

