/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.language.reflection.FieldSignature;

public class SerializableField
implements Serializable {
    private Field field = null;

    public SerializableField(Field field) {
        this.field = field;
    }

    public SerializableField(Class clazz, String fieldName) throws NoSuchFieldException {
        this.field = ClassUtil.resolveField(clazz, fieldName);
    }

    public Field deSerialize() {
        return this.field;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(this.field.getDeclaringClass());
            out.writeObject(new FieldSignature(this.field.getName()));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            Class declaringClass = (Class)in.readObject();
            FieldSignature signature = (FieldSignature)in.readObject();
            this.field = ClassUtil.resolveField(declaringClass, signature.getStringValue());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

