/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.d3;

import nl.tudelft.simulation.language.d3.CartesianPoint;

public class SphericalPoint {
    private double radius = 0.0;
    private double phi = 0.0;
    private double theta = 0.0;

    public SphericalPoint(double radius, double phi, double theta) {
        this.phi = phi;
        this.radius = radius;
        this.theta = theta;
    }

    public double getPhi() {
        return this.phi;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getTheta() {
        return this.theta;
    }

    public CartesianPoint toCartesianPoint() {
        return SphericalPoint.toCartesianPoint(this);
    }

    public static CartesianPoint toCartesianPoint(SphericalPoint point) {
        double x = point.radius * Math.sin(point.phi) * Math.cos(point.theta);
        double y = point.radius * Math.sin(point.phi) * Math.sin(point.theta);
        double z = point.radius * Math.cos(point.phi);
        return new CartesianPoint(x, y, z);
    }
}

