/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.d3;

import java.awt.geom.Point2D;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import nl.tudelft.simulation.language.d3.SphericalPoint;

public class CartesianPoint
extends Point3d {
    public CartesianPoint(double x, double y, double z) {
        super(x, y, z);
    }

    public CartesianPoint(double[] xyz) {
        super(xyz);
    }

    public CartesianPoint(Point3d point) {
        super(point);
    }

    public CartesianPoint(Point3f point) {
        super(point);
    }

    public CartesianPoint(Tuple3f tuple) {
        super(tuple);
    }

    public CartesianPoint(Tuple3d tuple) {
        super(tuple);
    }

    public CartesianPoint(Point2D point2D) {
        this(point2D.getX(), point2D.getY(), 0.0);
    }

    public CartesianPoint() {
    }

    public Point2D to2D() {
        return new Point2D.Double(((Tuple3d)this).x, ((Tuple3d)this).y);
    }

    public SphericalPoint toCartesianPoint() {
        return CartesianPoint.toSphericalPoint(this);
    }

    public static SphericalPoint toSphericalPoint(CartesianPoint point) {
        double rho = Math.sqrt(Math.pow(((Tuple3d)point).x, 2.0) + Math.pow(((Tuple3d)point).y, 2.0) + Math.pow(((Tuple3d)point).z, 2.0));
        double s = Math.sqrt(Math.pow(((Tuple3d)point).x, 2.0) + Math.pow(((Tuple3d)point).y, 2.0));
        double phi = Math.acos(((Tuple3d)point).z / rho);
        double theta = Math.asin(((Tuple3d)point).y / s);
        if (((Tuple3d)point).x >= 0.0) {
            theta = Math.PI - theta;
        }
        return new SphericalPoint(phi, rho, theta);
    }
}

