/*
 * Decompiled with CFR 0.152.
 */
package worldwind.kml.tree;

import gov.nasa.worldwind.WorldWindow;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import worldwind.kml.model.KMLFolder;
import worldwind.kml.model.KMLObject;
import worldwind.kml.model.KMLPlacemark;
import worldwind.kml.tree.CheckboxTreeCellRenderer;
import worldwind.kml.tree.KMLDocTreeNode;
import worldwind.kml.tree.KMLFolderTreeNode;
import worldwind.kml.tree.KMLPlacemarkTreeNode;

public class KMLTreeView
extends JTree {
    WorldWindow wwd;

    public KMLTreeView(WorldWindow worldWindow, TreeModel treeModel) {
        super(treeModel);
        this.wwd = worldWindow;
        this.setCellRenderer(new CheckboxTreeCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath = KMLTreeView.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                if (mouseEvent.getX() > KMLTreeView.this.getPathBounds((TreePath)treePath).x + 32) {
                    return;
                }
                Object object = treePath.getLastPathComponent();
                if (object instanceof KMLPlacemarkTreeNode) {
                    KMLTreeView.this.togglePlacemark(((KMLPlacemarkTreeNode)object).getPlacemark());
                } else if (object instanceof KMLFolderTreeNode) {
                    KMLTreeView.this.toggleFolder(((KMLFolderTreeNode)object).getFolder());
                }
                Object object2 = treePath.getPathComponent(1);
                if (object2 instanceof KMLDocTreeNode) {
                    ((KMLDocTreeNode)object2).getLayer().setInvalid(true);
                }
                KMLTreeView.this.repaint();
                KMLTreeView.this.wwd.redraw();
            }
        });
    }

    private void togglePlacemark(KMLPlacemark kMLPlacemark) {
        kMLPlacemark.setVisible(!kMLPlacemark.isVisible());
    }

    private void toggleFolder(KMLFolder kMLFolder) {
        if (kMLFolder.isVisible()) {
            this.setChildrenVisibility(kMLFolder, false);
        } else {
            this.setChildrenVisibility(kMLFolder, true);
        }
        kMLFolder.setVisible(!kMLFolder.isVisible());
    }

    private void setChildrenVisibility(KMLFolder kMLFolder, boolean bl) {
        for (KMLFolder object : kMLFolder.getChildFolders()) {
            object.setVisible(bl);
        }
        for (KMLObject kMLObject : kMLFolder.getObjects()) {
            if (!(kMLObject instanceof KMLPlacemark)) continue;
            ((KMLPlacemark)kMLObject).setVisible(bl);
        }
    }
}

