/*
 * Decompiled with CFR 0.152.
 */
package worldwind.kml.tree;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import javax.swing.tree.DefaultMutableTreeNode;
import worldwind.kml.model.KMLCoord;
import worldwind.kml.model.KMLGraphic;
import worldwind.kml.model.KMLLineString;
import worldwind.kml.model.KMLPlacemark;
import worldwind.kml.model.KMLPoint;
import worldwind.kml.model.KMLPolygon;
import worldwind.kml.tree.Sectored;

public class KMLPlacemarkTreeNode
extends DefaultMutableTreeNode
implements Sectored {
    KMLPlacemark placemark;

    public KMLPlacemarkTreeNode(KMLPlacemark kMLPlacemark) {
        this.placemark = kMLPlacemark;
    }

    public Sector getSector() {
        KMLGraphic kMLGraphic = this.placemark.getGraphic();
        if (kMLGraphic instanceof KMLPolygon) {
            KMLPolygon kMLPolygon = (KMLPolygon)kMLGraphic;
            return kMLPolygon.getSector();
        }
        if (kMLGraphic instanceof KMLPoint) {
            KMLPoint kMLPoint = (KMLPoint)kMLGraphic;
            KMLCoord kMLCoord = kMLPoint.getCoord();
            return new Sector(Angle.fromDegrees((double)(kMLCoord.getLat() - 1.0)), Angle.fromDegrees((double)(kMLCoord.getLat() + 1.0)), Angle.fromDegrees((double)(kMLCoord.getLon() - 1.0)), Angle.fromDegrees((double)(kMLCoord.getLon() + 1.0)));
        }
        if (kMLGraphic instanceof KMLLineString) {
            KMLLineString kMLLineString = (KMLLineString)kMLGraphic;
            return kMLLineString.getSector();
        }
        return null;
    }

    public KMLPlacemark getPlacemark() {
        return this.placemark;
    }

    public String toString() {
        return this.placemark.getName();
    }
}

