/*
 * Decompiled with CFR 0.152.
 */
package worldwind.kml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import worldwind.kml.model.KMLColor;
import worldwind.kml.model.KMLCoord;
import worldwind.kml.model.KMLFile;
import worldwind.kml.model.KMLFolder;
import worldwind.kml.model.KMLLineString;
import worldwind.kml.model.KMLObject;
import worldwind.kml.model.KMLPlacemark;
import worldwind.kml.model.KMLPoint;
import worldwind.kml.model.KMLPolygon;
import worldwind.kml.model.KMLStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMLParser {
    public static KMLFile parseFile(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("Could not find file: " + file.getPath());
        }
        return KMLParser.parseURL(file.toURL());
    }

    public static KMLFile parseURL(URL uRL) throws Exception {
        Object object = null;
        KMLFile kMLFile = null;
        try {
            Object object2;
            Object object3;
            URLConnection uRLConnection = uRL.openConnection();
            String string = uRLConnection.getHeaderField("Content-Type");
            System.out.println("ContentType: " + string);
            object = uRLConnection.getInputStream();
            if (!uRL.getFile().endsWith("kml") && !"application/vnd.google-earth.kml+xml".equals(string)) {
                if (uRL.getFile().endsWith("kmz") || "application/vnd.google-earth.kmz".equals(string)) {
                    object3 = new ZipInputStream((InputStream)object);
                    object2 = ((ZipInputStream)object3).getNextEntry();
                    while (object2 != null && !((ZipEntry)object2).getName().endsWith("kml")) {
                        object2 = ((ZipInputStream)object3).getNextEntry();
                    }
                    if (object2 == null) {
                        throw new Exception("No KML file found in the KMZ package");
                    }
                    object = object3;
                } else {
                    throw new IOException("Not a KML/KMZ file.  Expected '.kml/.kmz' got '" + uRL + "'");
                }
            }
            object3 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object3).setNamespaceAware(true);
            object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            Document document = ((DocumentBuilder)object2).parse((InputStream)object);
            Element element = document.getDocumentElement();
            kMLFile = new KMLFile();
            if (!"kml".equals(element.getLocalName())) {
                throw new Exception("Not a KML file.  Expected 'kml' got '" + element.getLocalName() + "'");
            }
            Element element2 = KMLParser.firstChildElement(element);
            while (element2 != null) {
                String string2 = element2.getLocalName();
                if ("Document".equals(string2)) {
                    KMLParser.parseDocument(element2, kMLFile);
                } else if ("Folder".equals(string2)) {
                    KMLParser.parseFolder(element2, kMLFile, kMLFile.getRootFolder());
                } else if ("Placemark".equals(string2)) {
                    KMLParser.parsePlacemark(element2, kMLFile, kMLFile.getRootFolder());
                }
                element2 = KMLParser.nextSiblingElement(element2);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
        return kMLFile;
    }

    private static void parseDocument(Element element, KMLFile kMLFile) {
        Object object;
        NodeList nodeList = element.getElementsByTagName("Schema");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = (Element)nodeList.item(i);
            kMLFile.addAlias(object.getAttribute("parent"), object.getAttribute("name"));
        }
        Element element2 = KMLParser.firstChildElement(element);
        while (element2 != null) {
            object = element2.getLocalName();
            if ("name".equals(object)) {
                String string = element2.getTextContent();
                kMLFile.getRootFolder().setName(string.trim());
            } else if ("Folder".equals(object)) {
                KMLParser.parseFolder(element2, kMLFile, kMLFile.getRootFolder());
            } else if ("Placemark".equals(object) || kMLFile.getAliasesFor("Placemark").contains(object)) {
                KMLParser.parsePlacemark(element2, kMLFile, kMLFile.getRootFolder());
            } else if ("Style".equals(object)) {
                KMLParser.parseStyle(element2, kMLFile);
            }
            element2 = KMLParser.nextSiblingElement(element2);
        }
    }

    private static KMLStyle parseStyle(Element element, KMLFile kMLFile) {
        KMLStyle kMLStyle = new KMLStyle();
        String string = element.getAttribute("id");
        if (string != null && string.trim().length() > 0) {
            kMLFile.addStyle(string, kMLStyle);
        }
        Element element2 = KMLParser.firstChildElement(element);
        while (element2 != null) {
            Element element3;
            Element element4;
            String string2 = element2.getLocalName();
            if ("LineStyle".equals(string2)) {
                element4 = KMLParser.childElementNamed(element2, "color");
                if (element4 != null) {
                    kMLStyle.setLineStyle("color", new KMLColor(element4.getTextContent()));
                }
                if ((element3 = KMLParser.childElementNamed(element2, "width")) != null) {
                    kMLStyle.setLineStyle("width", Float.valueOf(Float.parseFloat(element3.getTextContent())));
                }
            } else if ("PolyStyle".equals(string2)) {
                String string3;
                element4 = KMLParser.childElementNamed(element2, "color");
                if (element4 != null) {
                    kMLStyle.setPolyStyle("color", new KMLColor(element4.getTextContent()));
                }
                if ((element3 = KMLParser.childElementNamed(element2, "outline")) != null && (string3 = element3.getTextContent()).trim().equals("0")) {
                    kMLStyle.setPolyStyle("outline", Boolean.FALSE);
                }
            }
            element2 = KMLParser.nextSiblingElement(element2);
        }
        return kMLStyle;
    }

    private static void parseFolder(Element element, KMLFile kMLFile, KMLFolder kMLFolder) {
        KMLFolder kMLFolder2 = new KMLFolder();
        kMLFolder.addChildFolder(kMLFolder2);
        Element element2 = KMLParser.firstChildElement(element);
        while (element2 != null) {
            String string;
            String string2 = element2.getLocalName();
            if ("name".equals(string2)) {
                String string3 = element2.getTextContent();
                kMLFolder2.setName(string3.trim());
            } else if ("description".equals(string2)) {
                String string4 = element2.getTextContent();
                kMLFolder2.setDescription(string4.trim());
            } else if ("Folder".equals(string2)) {
                KMLParser.parseFolder(element2, kMLFile, kMLFolder2);
            } else if ("Placemark".equals(string2) || kMLFile.getAliasesFor("Placemark").contains(string2)) {
                KMLParser.parsePlacemark(element2, kMLFile, kMLFolder2);
            } else if ("visibility".equals(string2) && ((string = element2.getTextContent()).trim().equals("0") || string.trim().equalsIgnoreCase("false"))) {
                kMLFolder2.setVisible(false);
            }
            element2 = KMLParser.nextSiblingElement(element2);
        }
        if (!kMLFolder2.isVisible()) {
            boolean bl = false;
            for (KMLFolder kMLFolder3 : kMLFolder2.getChildFolders()) {
                if (!kMLFolder3.isVisible()) continue;
                bl = true;
                break;
            }
            for (KMLObject kMLObject : kMLFolder2.getObjects()) {
                if (!(kMLObject instanceof KMLPlacemark) || !((KMLPlacemark)kMLObject).isVisible()) continue;
                bl = true;
                break;
            }
            kMLFolder2.setVisible(bl);
        }
    }

    private static void parsePlacemark(Element element, KMLFile kMLFile, KMLFolder kMLFolder) {
        KMLPlacemark kMLPlacemark = new KMLPlacemark();
        kMLFolder.addObject(kMLPlacemark);
        Element element2 = KMLParser.firstChildElement(element);
        while (element2 != null) {
            Object object;
            String string = element2.getLocalName();
            if ("name".equals(string)) {
                object = element2.getTextContent();
                kMLPlacemark.setName(((String)object).trim());
            } else if ("description".equals(string)) {
                object = element2.getTextContent();
                kMLPlacemark.setDescription(((String)object).trim());
            } else if ("LineString".equals(string)) {
                KMLParser.parseLineString(element2, kMLFile, kMLPlacemark);
            } else if ("Point".equals(string)) {
                KMLParser.parsePoint(element2, kMLFile, kMLPlacemark);
            } else if ("Polygon".equals(string)) {
                KMLParser.parsePolygon(element2, kMLFile, kMLPlacemark);
            } else if ("Style".equals(string)) {
                object = KMLParser.parseStyle(element2, kMLFile);
                kMLPlacemark.setStyle((KMLStyle)object);
            } else if ("styleUrl".equals(string)) {
                object = element2.getTextContent();
                if (((String)object).startsWith("#")) {
                    object = ((String)object).substring(1);
                    KMLStyle kMLStyle = kMLFile.getStyle((String)object);
                    kMLPlacemark.setStyle(kMLStyle);
                }
            } else if ("visibility".equals(string) && (((String)(object = element2.getTextContent())).trim().equals("0") || ((String)object).trim().equalsIgnoreCase("false"))) {
                kMLPlacemark.setVisible(false);
            }
            element2 = KMLParser.nextSiblingElement(element2);
        }
    }

    private static void parseLineString(Element element, KMLFile kMLFile, KMLPlacemark kMLPlacemark) {
        KMLLineString kMLLineString = new KMLLineString();
        kMLPlacemark.setGraphic(kMLLineString);
        Element element2 = KMLParser.firstChildElement(element);
        while (element2 != null) {
            String string;
            String string2 = element2.getLocalName();
            if ("coordinates".equals(string2)) {
                string = element2.getTextContent();
                ArrayList<KMLCoord> arrayList = KMLParser.parseCoordinates(string);
                kMLLineString.setCoords(arrayList);
            } else if ("tessellate".equals(string2)) {
                string = element2.getTextContent();
                boolean bl = string.trim().equals("1");
                kMLLineString.setTessellate(bl);
            } else if ("altitudeMode".equals(string2)) {
                string = element2.getTextContent();
                if (string != null && string.trim().equals("absolute")) {
                    kMLLineString.setAbsolute(true);
                }
            } else if ("extrude".equals(string2) && (string = element2.getTextContent()) != null && string.trim().equals("1")) {
                kMLLineString.setExtrude(true);
            }
            element2 = KMLParser.nextSiblingElement(element2);
        }
    }

    private static void parsePoint(Element element, KMLFile kMLFile, KMLPlacemark kMLPlacemark) {
        KMLPoint kMLPoint = new KMLPoint();
        kMLPlacemark.setGraphic(kMLPoint);
        Element element2 = KMLParser.firstChildElement(element);
        while (element2 != null) {
            String string;
            String string2 = element2.getLocalName();
            if ("coordinates".equals(string2)) {
                string = element2.getTextContent();
                ArrayList<KMLCoord> arrayList = KMLParser.parseCoordinates(string);
                KMLCoord kMLCoord = arrayList.get(0);
                kMLPoint.setCoord(kMLCoord);
            } else if ("altitudeMode".equals(string2)) {
                string = element2.getTextContent();
                if ("relativeToGround".equals(string)) {
                    kMLPoint.setAltitudeMode(2);
                } else if ("absolute".equals(string)) {
                    kMLPoint.setAltitudeMode(3);
                }
            }
            element2 = KMLParser.nextSiblingElement(element2);
        }
    }

    private static void parsePolygon(Element element, KMLFile kMLFile, KMLPlacemark kMLPlacemark) {
        KMLPolygon kMLPolygon = new KMLPolygon();
        kMLPlacemark.setGraphic(kMLPolygon);
        Element element2 = KMLParser.firstChildElement(element);
        while (element2 != null) {
            ArrayList<KMLCoord> arrayList;
            String string;
            Element element3;
            Element element4;
            String string2 = element2.getLocalName();
            if ("outerBoundaryIs".equals(string2)) {
                element4 = KMLParser.childElementNamed(element2, "LinearRing");
                if (element4 != null && (element3 = KMLParser.childElementNamed(element4, "coordinates")) != null) {
                    string = element3.getTextContent();
                    arrayList = KMLParser.parseCoordinates(string);
                    kMLPolygon.setOuter(arrayList);
                }
            } else if ("innerBoundaryIs".equals(string2) && (element4 = KMLParser.childElementNamed(element2, "LinearRing")) != null && (element3 = KMLParser.childElementNamed(element4, "coordinates")) != null) {
                string = element3.getTextContent();
                arrayList = KMLParser.parseCoordinates(string);
                kMLPolygon.setInner(arrayList);
            }
            element2 = KMLParser.nextSiblingElement(element2);
        }
    }

    private static ArrayList<KMLCoord> parseCoordinates(String string) {
        ArrayList<KMLCoord> arrayList = new ArrayList<KMLCoord>();
        CoordScanner coordScanner = new CoordScanner(string);
        int n = 0;
        while (n != CoordScanner.EOF) {
            while ((n = coordScanner.nextTokenType()) == CoordScanner.WHITESPACE) {
            }
            if (n != CoordScanner.NUMBER && n != CoordScanner.EOF) {
                throw new RuntimeException("Expected a number [1], got: " + coordScanner.nextToken());
            }
            if (n == CoordScanner.EOF) break;
            double d = Double.parseDouble(coordScanner.nextToken());
            n = coordScanner.nextTokenType();
            while (n == CoordScanner.COMMA || n == CoordScanner.WHITESPACE) {
                n = coordScanner.nextTokenType();
            }
            if (n != CoordScanner.NUMBER && n != CoordScanner.EOF) {
                throw new RuntimeException("Expected a number [2], got: " + coordScanner.nextToken());
            }
            double d2 = Double.parseDouble(coordScanner.nextToken());
            double d3 = 0.0;
            n = coordScanner.nextTokenType();
            while (n == CoordScanner.WHITESPACE) {
                n = coordScanner.nextTokenType();
            }
            if (n == CoordScanner.COMMA) {
                n = coordScanner.nextTokenType();
                while (n == CoordScanner.WHITESPACE) {
                    n = coordScanner.nextTokenType();
                }
                if (n != CoordScanner.NUMBER && n != CoordScanner.EOF) {
                    throw new RuntimeException("Expected a number [3], got: " + coordScanner.nextToken());
                }
                if (n == CoordScanner.NUMBER) {
                    d3 = Double.parseDouble(coordScanner.nextToken());
                }
            }
            arrayList.add(new KMLCoord(d, d2, d3));
        }
        return arrayList;
    }

    public static Element firstChildElement(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            return (Element)node2;
        }
        return null;
    }

    public static Element nextSiblingElement(Node node) {
        for (Node node2 = node.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            return (Element)node2;
        }
        return null;
    }

    public static Element childElementNamed(Node node, String string) {
        Element element = KMLParser.firstChildElement(node);
        while (element != null) {
            if (element.getLocalName().equals(string)) {
                return element;
            }
            element = KMLParser.nextSiblingElement(element);
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        KMLFile kMLFile = KMLParser.parseFile("/Users/tgleason/IdeaProjects/WorldWindKML/app-trail.kml");
        System.out.println("******");
        KMLFile kMLFile2 = KMLParser.parseFile("/Users/tgleason/IdeaProjects/WorldWindKML/KML_Samples.kml");
    }

    static class CoordScanner {
        String cs;
        int tokenStart = 0;
        int tokenEnd = 0;
        public static int EOF = -1;
        public static int WHITESPACE = 0;
        public static int NUMBER = 1;
        public static int COMMA = 2;

        CoordScanner(String string) {
            this.cs = string;
        }

        public int nextTokenType() {
            if (this.tokenEnd == this.cs.length() - 1) {
                return EOF;
            }
            this.tokenStart = this.tokenEnd;
            char c = this.cs.charAt(this.tokenEnd);
            if (Character.isWhitespace(c)) {
                while (Character.isWhitespace(c) && this.tokenEnd < this.cs.length() - 1) {
                    ++this.tokenEnd;
                    c = this.cs.charAt(this.tokenEnd);
                }
                return WHITESPACE;
            }
            if (c == ',') {
                ++this.tokenEnd;
                return COMMA;
            }
            while (!Character.isWhitespace(c) && c != ',' && this.tokenEnd < this.cs.length() - 1) {
                ++this.tokenEnd;
                c = this.cs.charAt(this.tokenEnd);
            }
            return NUMBER;
        }

        public String nextToken() {
            return this.cs.substring(this.tokenStart, this.tokenEnd);
        }
    }
}

