/*
 * Decompiled with CFR 0.152.
 */
package worldwind;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.Version;
import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLJPanel;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.BasicDragger;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGSurfaceLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3;
import gov.nasa.worldwind.layers.Earth.NASAWFSPlaceNameLayer;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import worldwind.kml.KMLLayer;
import worldwind.kml.KMLParser;
import worldwind.kml.model.KMLFile;
import worldwind.kml.model.KMLPlacemark;
import worldwind.kml.tree.DocListTreeNode;
import worldwind.kml.tree.KMLDocTreeNode;
import worldwind.kml.tree.Sectored;
import worldwind.kml.ui.InfoDialog;

public class SimpleClient {
    public static void main(String[] stringArray) {
        System.out.println("Java run-time version: " + System.getProperty("java.version"));
        try {
            AWT1UpFrame aWT1UpFrame = new AWT1UpFrame();
            aWT1UpFrame.setDefaultCloseOperation(3);
            aWT1UpFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind AWT Canvas App");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
    }

    private static class AWT1UpFrame
    extends JFrame {
        StatusBar statusBar;
        JLabel cursorPositionDisplay;
        WorldWindowGLJPanel wwd;
        DocListTreeNode docList = new DocListTreeNode();
        JTree tree;
        WWIcon lastPickedIcon;

        public AWT1UpFrame() {
            try {
                System.out.println(Version.getVersion());
                this.wwd = new WorldWindowGLJPanel();
                this.wwd.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        AWT1UpFrame.this.wwd.grabFocus();
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                        AWT1UpFrame.this.wwd.grabFocus();
                    }
                });
                this.wwd.setPreferredSize(new Dimension(1000, 600));
                KMLFile kMLFile = KMLParser.parseFile("app-trail.kml");
                KMLFile kMLFile2 = KMLParser.parseFile("KML_Samples.kml");
                KMLFile kMLFile3 = KMLParser.parseFile("Vancouver/doc.kml");
                KMLFile kMLFile4 = KMLParser.parseFile("tdf2006/doc.kml");
                System.out.println("------------ Track");
                KMLFile kMLFile5 = KMLParser.parseFile("Track.kml");
                KMLFile kMLFile6 = KMLParser.parseFile("whc-en.kmz");
                this.docList.add(new KMLDocTreeNode(kMLFile, "app-trail.kml"));
                this.docList.add(new KMLDocTreeNode(kMLFile2, "KML_Samples.kml"));
                this.docList.add(new KMLDocTreeNode(kMLFile3, "Vancouver.kml"));
                this.docList.add(new KMLDocTreeNode(kMLFile4, "tdf2006.kml"));
                this.docList.add(new KMLDocTreeNode(kMLFile5, "Track.kml"));
                this.docList.add(new KMLDocTreeNode(kMLFile6, "World Heritage"));
                this.tree = new JTree(this.docList);
                this.tree.setRootVisible(false);
                this.tree.setShowsRootHandles(true);
                this.tree.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getClickCount() == 2) {
                            TreePath treePath = AWT1UpFrame.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                            if (treePath == null) {
                                return;
                            }
                            Object object = treePath.getLastPathComponent();
                            if (object instanceof Sectored) {
                                Sector sector = ((Sectored)object).getSector();
                                if (sector == null) {
                                    System.out.println("Null sector");
                                    return;
                                }
                                OrbitView orbitView = (OrbitView)AWT1UpFrame.this.wwd.getView();
                                Globe globe = AWT1UpFrame.this.wwd.getModel().getGlobe();
                                LatLon latLon = new LatLon(Angle.average((Angle)sector.getMinLatitude(), (Angle)sector.getMaxLatitude()), Angle.average((Angle)sector.getMinLongitude(), (Angle)sector.getMaxLongitude()));
                                FlyToOrbitViewStateIterator flyToOrbitViewStateIterator = FlyToOrbitViewStateIterator.createPanToIterator((OrbitView)orbitView, (Globe)globe, (Position)new Position(latLon, 0.0), (Angle)orbitView.getHeading(), (Angle)orbitView.getPitch(), (double)30000.0);
                                orbitView.applyStateIterator((ViewStateIterator)flyToOrbitViewStateIterator);
                            }
                        }
                    }
                });
                JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(this.tree), (Component)this.wwd);
                jSplitPane.setContinuousLayout(true);
                jSplitPane.setDividerSize(3);
                jSplitPane.setDividerLocation(300);
                this.getContentPane().add((Component)jSplitPane, "Center");
                this.statusBar = new StatusBar();
                this.getContentPane().add((Component)this.statusBar, "Last");
                this.pack();
                BasicModel basicModel = new BasicModel();
                basicModel.getLayers().clear();
                basicModel.getLayers().add((Layer)new BMNGSurfaceLayer());
                LandsatI3 landsatI3 = new LandsatI3();
                landsatI3.setDrawBoundingVolumes(false);
                landsatI3.setOpacity(1.0);
                basicModel.getLayers().add((Layer)landsatI3);
                basicModel.getLayers().add((Layer)new CompassLayer());
                basicModel.getLayers().add((Layer)new NASAWFSPlaceNameLayer());
                KMLLayer kMLLayer = new KMLLayer(kMLFile);
                basicModel.getLayers().add((Layer)kMLLayer);
                kMLLayer = new KMLLayer(kMLFile2);
                basicModel.getLayers().add((Layer)kMLLayer);
                kMLLayer = new KMLLayer(kMLFile3);
                basicModel.getLayers().add((Layer)kMLLayer);
                kMLLayer = new KMLLayer(kMLFile4);
                basicModel.getLayers().add((Layer)kMLLayer);
                kMLLayer = new KMLLayer(kMLFile5);
                basicModel.getLayers().add((Layer)kMLLayer);
                kMLLayer = new KMLLayer(kMLFile6);
                basicModel.getLayers().add((Layer)kMLLayer);
                basicModel.setShowWireframeExterior(false);
                basicModel.setShowWireframeInterior(false);
                this.wwd.setModel((Model)basicModel);
                this.statusBar.setEventSource((WorldWindow)this.wwd);
                this.wwd.addRenderingListener(new RenderingListener(){

                    public void stageChanged(RenderingEvent renderingEvent) {
                    }
                });
                this.wwd.addSelectListener(new SelectListener(){
                    private WWIcon lastToolTipIcon = null;
                    private BasicDragger dragger;
                    {
                        this.dragger = new BasicDragger((WorldWindow)AWT1UpFrame.this.wwd);
                    }

                    public void selected(SelectEvent selectEvent) {
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                            if (selectEvent.hasObjects()) {
                                KMLPlacemark kMLPlacemark;
                                System.out.println("Single clicked " + selectEvent.getTopObject());
                                Object object = selectEvent.getTopObject();
                                if (object instanceof KMLPlacemark && (kMLPlacemark = (KMLPlacemark)object).getDescription() != null) {
                                    new InfoDialog((Frame)AWT1UpFrame.this, "<html>" + kMLPlacemark.getDescription() + "</html>");
                                }
                                if (selectEvent.getTopObject() instanceof WorldMapLayer) {
                                    kMLPlacemark = selectEvent.getTopPickedObject().getPosition();
                                    OrbitView orbitView = (OrbitView)AWT1UpFrame.this.wwd.getView();
                                    Globe globe = AWT1UpFrame.this.wwd.getModel().getGlobe();
                                    orbitView.applyStateIterator((ViewStateIterator)FlyToOrbitViewStateIterator.createPanToIterator((OrbitView)orbitView, (Globe)globe, (Position)kMLPlacemark, (Angle)Angle.ZERO, (Angle)Angle.ZERO, (double)kMLPlacemark.getElevation()));
                                }
                            } else {
                                System.out.println("Single clicked no object");
                            }
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftDoubleClick")) {
                            if (selectEvent.hasObjects()) {
                                System.out.println("Double clicked " + selectEvent.getTopObject());
                            } else {
                                System.out.println("Double clicked no object");
                            }
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.RightClick")) {
                            if (selectEvent.hasObjects()) {
                                System.out.println("Right clicked " + selectEvent.getTopObject());
                            } else {
                                System.out.println("Right clicked no object");
                            }
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Hover")) {
                            if (this.lastToolTipIcon != null) {
                                this.lastToolTipIcon.setShowToolTip(false);
                                this.lastToolTipIcon = null;
                                AWT1UpFrame.this.wwd.repaint();
                            }
                            if (selectEvent.hasObjects() && !this.dragger.isDragging() && selectEvent.getTopObject() instanceof WWIcon) {
                                this.lastToolTipIcon = (WWIcon)selectEvent.getTopObject();
                                this.lastToolTipIcon.setShowToolTip(true);
                                AWT1UpFrame.this.wwd.repaint();
                            }
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
                            AWT1UpFrame.this.highlight(selectEvent.getTopObject());
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                            PickedObjectList pickedObjectList;
                            this.dragger.selected(selectEvent);
                            if (selectEvent.getTopObject() instanceof WWIcon) {
                                if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
                                    AWT1UpFrame.this.lastPickedIcon.setAlwaysOnTop(false);
                                } else {
                                    AWT1UpFrame.this.lastPickedIcon = (WWIcon)selectEvent.getTopObject();
                                    AWT1UpFrame.this.lastPickedIcon.setAlwaysOnTop(true);
                                }
                            }
                            if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = AWT1UpFrame.this.wwd.getObjectsAtCurrentPosition()) != null) {
                                AWT1UpFrame.this.highlight(pickedObjectList.getTopObject());
                            }
                        }
                    }
                });
                this.wwd.addPositionListener(new PositionListener(){

                    public void moved(PositionEvent positionEvent) {
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.wwd.grabFocus();
        }

        private void highlight(Object object) {
            if (this.lastPickedIcon == object) {
                return;
            }
            if (this.lastPickedIcon != null) {
                this.lastPickedIcon.setHighlighted(false);
                this.lastPickedIcon = null;
            }
            if (object != null && object instanceof WWIcon) {
                this.lastPickedIcon = (WWIcon)object;
                this.lastPickedIcon.setHighlighted(true);
            }
        }

        private IconLayer buildIconLayer() {
            IconLayer iconLayer = new IconLayer();
            for (double d = 0.0; d < 10.0; d += 10.0) {
                for (double d2 = -180.0; d2 < 180.0; d2 += 10.0) {
                    double d3 = 0.0;
                    if (d2 % 90.0 == 0.0) {
                        d3 = 2000000.0;
                    }
                    UserFacingIcon userFacingIcon = new UserFacingIcon("images/32x32-icon-nasa.png", new Position(Angle.fromDegrees((double)d), Angle.fromDegrees((double)d2), d3));
                    userFacingIcon.setHighlightScale(1.5);
                    userFacingIcon.setToolTipFont(this.makeToolTipFont());
                    userFacingIcon.setToolTipText(userFacingIcon.getImageSource().toString());
                    userFacingIcon.setToolTipTextColor(Color.YELLOW);
                    iconLayer.addIcon((WWIcon)userFacingIcon);
                }
            }
            return iconLayer;
        }

        private Font makeToolTipFont() {
            HashMap<TextAttribute, Color> hashMap = new HashMap<TextAttribute, Color>();
            hashMap.put(TextAttribute.BACKGROUND, new Color(0.4f, 0.4f, 0.4f, 1.0f));
            return Font.decode("Arial-BOLD-14").deriveFont(hashMap);
        }
    }
}

