/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.iosp.gempak.AnalysisBlock;
import ucar.nc2.iosp.gempak.GempakFileReader;
import ucar.nc2.iosp.gempak.GempakGridRecord;
import ucar.nc2.iosp.gempak.GempakUtil;
import ucar.nc2.iosp.gempak.NavigationBlock;
import ucar.nc2.iosp.grid.GridIndex;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.unidata.io.RandomAccessFile;

public class GempakGridReader
extends GempakFileReader {
    private static Logger log = LoggerFactory.getLogger(GempakGridReader.class);
    public static final String GRID = "GRID";
    public static final String ANLB = "ANLB";
    public static final String NAVB = "NAVB";
    private NavigationBlock navBlock;
    private AnalysisBlock analBlock;
    private GridIndex gridIndex;
    private static final String[] kcolnm = new String[]{"GDT1", "GTM1", "GDT2", "GTM2", "GLV1", "GLV2", "GVCD", "GPM1", "GPM2", "GPM3"};
    private final String filename;
    public boolean useDP = true;
    private int bitPos;
    private int bitBuf;
    private int next;
    private int ch1;
    private int ch2;
    private int ch3;
    private int ch4;

    GempakGridReader(String filename) {
        this.filename = filename;
    }

    public static GempakGridReader getInstance(RandomAccessFile raf, boolean fullCheck) throws IOException {
        GempakGridReader ggr = new GempakGridReader(raf.getLocation());
        ggr.init(raf, fullCheck);
        return ggr;
    }

    @Override
    protected boolean init(boolean fullCheck) throws IOException {
        boolean ok = super.init(fullCheck);
        if (!ok) {
            return false;
        }
        if (this.dmLabel.kftype != 3) {
            this.logError("not a grid file");
            return false;
        }
        GempakFileReader.DMPart part = this.getPart(GRID);
        if (part == null) {
            this.logError("No part named GRID found");
            return false;
        }
        int lenhdr = part.klnhdr;
        if (lenhdr > 128) {
            this.logError("Grid part header too long");
            return false;
        }
        for (int i = 0; i < this.keys.kkcol.size(); ++i) {
            GempakFileReader.Key colkey = this.keys.kkcol.get(i);
            if (colkey.name.equals(kcolnm[i])) continue;
            this.logError("Column name " + colkey + " doesn't match " + kcolnm[i]);
            return false;
        }
        if (!fullCheck) {
            return true;
        }
        this.gridIndex = new GridIndex(this.filename);
        float[] headerArray = this.getFileHeader(NAVB);
        if (headerArray == null) {
            return false;
        }
        this.navBlock = new NavigationBlock(headerArray);
        this.gridIndex.addHorizCoordSys(this.navBlock);
        headerArray = this.getFileHeader(ANLB);
        if (headerArray == null) {
            return false;
        }
        this.analBlock = new AnalysisBlock(headerArray);
        ArrayList<GempakGridRecord> tmpList = new ArrayList<GempakGridRecord>();
        int[] header = new int[this.dmLabel.kckeys];
        if (this.headers == null || this.headers.colHeaders == null) {
            return false;
        }
        int gridNum = 0;
        for (int[] fullHeader : this.headers.colHeaders) {
            ++gridNum;
            if (fullHeader == null || fullHeader[0] == -9999) continue;
            System.arraycopy(fullHeader, 1, header, 0, header.length);
            GempakGridRecord gh = new GempakGridRecord(gridNum, header);
            gh.navBlock = this.navBlock;
            String name = gh.getParameterName();
            tmpList.add(gh);
        }
        this.fileSize = this.rf.length();
        if (!tmpList.isEmpty()) {
            for (GempakGridRecord gh : tmpList) {
                gh.packingType = this.getGridPackingType(gh.gridNumber);
                if (gh.packingType != 1 && gh.packingType != 5 && gh.packingType != 0) continue;
                this.gridIndex.addGridRecord(gh);
            }
        } else {
            return false;
        }
        return !this.gridIndex.getGridRecords().isEmpty();
    }

    public GridIndex getGridIndex() {
        return this.gridIndex;
    }

    public int getGridCount() {
        return this.gridIndex.getGridCount();
    }

    public int getGridPackingType(int gridNumber) throws IOException {
        int irow = 1;
        if (gridNumber < 1 || gridNumber > this.dmLabel.kcol) {
            this.logWarning("bad grid number " + gridNumber);
            return -9;
        }
        int iprt = this.getPartNumber(GRID);
        if (iprt == 0) {
            this.logWarning("couldn't find part: GRID");
            return -10;
        }
        GempakFileReader.DMPart part = (GempakFileReader.DMPart)this.parts.get(iprt - 1);
        if (part.ktyprt != 5) {
            this.logWarning("Not a valid type: " + GempakUtil.getDataType(part.ktyprt));
            return -21;
        }
        int ilenhd = part.klnhdr;
        int ipoint = this.dmLabel.kpdata + (irow - 1) * this.dmLabel.kcol * this.dmLabel.kprt + (gridNumber - 1) * this.dmLabel.kprt + (iprt - 1);
        int istart = this.DM_RINT(ipoint);
        if (istart == 0) {
            return -15;
        }
        int length = this.DM_RINT(istart);
        int isword = istart + 1;
        if (length <= ilenhd) {
            this.logWarning("length (" + length + ") is less than header length (" + ilenhd + ")");
            return -15;
        }
        if (Math.abs(length) > 10000000) {
            this.logWarning("length is huge: " + length);
            return -34;
        }
        int[] header = new int[ilenhd];
        this.DM_RINT(isword, header);
        return this.DM_RINT(isword += ilenhd);
    }

    public GempakGridRecord findGrid(String parm) {
        List<GridRecord> gridList = this.gridIndex.getGridRecords();
        if (gridList == null) {
            return null;
        }
        for (GridRecord grid : gridList) {
            GempakGridRecord gh = (GempakGridRecord)grid;
            if (!gh.param.trim().equals(parm)) continue;
            return gh;
        }
        return null;
    }

    public float[] readGrid(GridRecord gr) throws IOException {
        int gridNumber = ((GempakGridRecord)gr).getGridNumber();
        GempakFileReader.RData data = this.DM_RDTR(1, gridNumber, GRID, gr.getDecimalScale());
        float[] vals = null;
        if (data != null) {
            vals = data.data;
        }
        return vals;
    }

    @Override
    public float[] DM_RPKG(int isword, int nword, int decimalScale) throws IOException {
        int irw;
        int iiw;
        int ipktyp = this.DM_RINT(isword);
        int iiword = isword + 1;
        int lendat = nword - 1;
        if (ipktyp == 0) {
            float[] data = new float[lendat];
            this.DM_RFLT(iiword, data);
            return data;
        }
        if (ipktyp == 3) {
            iiw = 4;
            irw = 3;
        } else if (ipktyp == 5) {
            iiw = 4;
            irw = 1;
        } else {
            iiw = 3;
            irw = 2;
        }
        int[] iarray = new int[iiw];
        float[] rarray = new float[irw];
        this.DM_RINT(iiword, iarray);
        lendat -= iiw;
        this.DM_RFLT(iiword += iiw, rarray);
        iiword += irw;
        lendat -= irw;
        if (ipktyp == 5) {
            float[] data = this.unpackGrib2Data(iiword, lendat, iarray, rarray);
            return data;
        }
        int nbits = iarray[0];
        int misflg = iarray[1];
        boolean miss = misflg != 0;
        int kxky = iarray[2];
        int kx = 0;
        if (iiw == 4) {
            kx = iarray[3];
        }
        float ref = rarray[0];
        float scale = rarray[1];
        float difmin = 0.0f;
        if (irw == 3) {
            difmin = rarray[2];
        }
        float[] data = this.unpackData(iiword, lendat, ipktyp, kxky, nbits, ref, scale, miss, difmin, kx, decimalScale);
        return data;
    }

    private synchronized float[] unpackData(int iiword, int nword, int ipktyp, int kxky, int nbits, float ref, float scale, boolean miss, float difmin, int kx, int decimalScale) throws IOException {
        if (ipktyp == 1) {
            if (!this.useDP) {
                return this.unpackGrib1Data(iiword, nword, kxky, nbits, ref, scale, miss, decimalScale);
            }
            if (nword * 32 < kxky * nbits) {
                ++nword;
            }
            int[] ksgrid = new int[nword];
            this.DM_RINT(iiword, ksgrid);
            return this.DP_UGRB(ksgrid, kxky, nbits, ref, scale, miss, decimalScale);
        }
        if (ipktyp == 2) {
            return null;
        }
        if (ipktyp == 3) {
            return null;
        }
        return null;
    }

    private synchronized float[] DP_UGRB(int[] idata, int kxky, int nbits, float qmin, float scale, boolean misflg, int decimalScale) throws IOException {
        float scaleFactor = decimalScale == 0 ? 1.0f : (float)Math.pow(10.0, -decimalScale);
        float[] grid = new float[kxky];
        if (nbits <= 1 || nbits > 31) {
            return grid;
        }
        if ((double)scale == 0.0) {
            return grid;
        }
        int imax = (int)(Math.pow(2.0, nbits) - 1.0);
        int iword = 0;
        int ibit = 1;
        for (int i = 0; i < kxky; ++i) {
            int jshft = nbits + ibit - 33;
            int idat = jshft < 0 ? idata[iword] >>> Math.abs(jshft) : idata[iword] << jshft;
            idat &= imax;
            if (jshft > 0) {
                int idat2 = idata[iword + 1] >>> Math.abs(jshft -= 32);
                idat |= idat2;
            }
            grid[i] = idat == imax && misflg ? -9999.0f : (qmin + (float)idat * scale) * scaleFactor;
            if ((ibit += nbits) <= 32) continue;
            ibit -= 32;
            ++iword;
        }
        return grid;
    }

    private float[] unpackGrib1Data(int iiword, int nword, int kxky, int nbits, float ref, float scale, boolean miss, int decimalScale) throws IOException {
        float[] values = new float[kxky];
        this.bitPos = 0;
        this.bitBuf = 0;
        this.next = 0;
        this.ch1 = 0;
        this.ch2 = 0;
        this.ch3 = 0;
        this.ch4 = 0;
        this.rf.seek(GempakGridReader.getOffset(iiword));
        float scaleFactor = decimalScale == 0 ? 1.0f : (float)Math.pow(10.0, -decimalScale);
        for (int i = 0; i < values.length; ++i) {
            int idat = this.bits2UInt(nbits);
            values[i] = miss && idat == -9999 ? -9999.0f : (ref + scale * (float)idat) * scaleFactor;
        }
        return values;
    }

    private float[] unpackGrib2Data(int iiword, int lendat, int[] iarray, float[] rarray) throws IOException {
        long start = GempakGridReader.getOffset(iiword);
        this.rf.seek(start);
        Grib2Record gr = this.makeGribRecord(this.rf, start);
        float[] data = gr.readData(this.rf);
        if ((iarray[3] >> 6 & 1) == 0) {
            data = this.gb2_ornt(iarray[1], iarray[2], iarray[3], data);
        }
        return data;
    }

    private Grib2Record makeGribRecord(RandomAccessFile raf, long start) throws IOException {
        Grib2SectionIndicator is = new Grib2SectionIndicator(start, 0L, 0);
        Grib2SectionIdentification ids = null;
        Grib2SectionLocalUse lus = null;
        Grib2SectionGridDefinition gds = null;
        Grib2SectionProductDefinition pds = null;
        Grib2SectionDataRepresentation drs = null;
        Grib2SectionBitMap bms = null;
        Grib2SectionData dataSection = null;
        raf.seek(start);
        raf.order(0);
        int secLength = raf.readInt();
        if (secLength > 0) {
            ids = new Grib2SectionIdentification(raf);
        }
        if ((secLength = raf.readInt()) > 0) {
            lus = new Grib2SectionLocalUse(raf);
        }
        if ((secLength = raf.readInt()) > 0) {
            gds = new Grib2SectionGridDefinition(raf);
        }
        if ((secLength = raf.readInt()) > 0) {
            pds = new Grib2SectionProductDefinition(raf);
        }
        if ((secLength = raf.readInt()) > 0) {
            drs = new Grib2SectionDataRepresentation(raf);
        }
        if ((secLength = raf.readInt()) > 0) {
            bms = new Grib2SectionBitMap(raf);
        }
        if ((secLength = raf.readInt()) > 0 && (dataSection = new Grib2SectionData(raf)).getMsgLength() > secLength) {
            throw new IllegalStateException("Illegal Grib2SectionData Message Length");
        }
        return new Grib2Record(null, is, ids, lus, gds, pds, drs, bms, dataSection, false, 9999);
    }

    public void printNavBlock() {
        StringBuilder buf = new StringBuilder("GRID NAVIGATION:");
        if (this.navBlock != null) {
            buf.append(this.navBlock);
        } else {
            buf.append("\n\tUNKNOWN GRID NAVIGATION");
        }
        System.out.println(buf);
    }

    public void printAnalBlock() {
        StringBuilder buf = new StringBuilder("GRID ANALYSIS BLOCK:");
        if (this.analBlock != null) {
            buf.append(this.analBlock);
        } else {
            buf.append("\n\tUNKNOWN ANALYSIS TYPE");
        }
        System.out.println(buf);
    }

    public List<GridRecord> getGridList() {
        return this.gridIndex.getGridRecords();
    }

    public void printGrids() {
        List<GridRecord> gridList = this.gridIndex.getGridRecords();
        if (gridList == null) {
            return;
        }
        System.out.println("  NUM       TIME1              TIME2           LEVL1 LEVL2  VCORD PARM");
        for (GridRecord aGridList : gridList) {
            System.out.println(aGridList);
        }
    }

    public void showGridInfo(boolean printGrids) {
        List<GridRecord> gridList = this.gridIndex.getGridRecords();
        System.out.println("\nGRID FILE: " + this.getFilename() + "\n");
        this.printNavBlock();
        System.out.println();
        this.printAnalBlock();
        System.out.println("\nNumber of grids in file:  " + gridList.size());
        System.out.println("\nMaximum number of grids in file:  " + this.dmLabel.kcol);
        System.out.println();
        if (printGrids) {
            this.printGrids();
        }
    }

    private float[] gb2_ornt(int kx, int ky, int scan_mode, float[] ingrid) {
        float[] fgrid;
        block17: {
            int kcnt;
            int jinc;
            int iinc;
            int ibeg;
            int boustr;
            int consec;
            int jdrct;
            int idrct;
            block19: {
                block18: {
                    block16: {
                        int jbeg;
                        fgrid = new float[ingrid.length];
                        idrct = scan_mode >> 7 & 1;
                        jdrct = scan_mode >> 6 & 1;
                        consec = scan_mode >> 5 & 1;
                        boustr = scan_mode >> 4 & 1;
                        if (idrct == 0) {
                            ibeg = 0;
                            iinc = 1;
                        } else {
                            ibeg = kx - 1;
                            iinc = -1;
                        }
                        if (jdrct == 1) {
                            jbeg = 0;
                            jinc = 1;
                        } else {
                            jbeg = ky - 1;
                            jinc = -1;
                        }
                        kcnt = 0;
                        if (consec != 1 || boustr != 0) break block16;
                        for (int jcnt = jbeg; 0 <= jcnt && jcnt < ky; jcnt += jinc) {
                            for (int icnt = ibeg; 0 <= icnt && icnt < kx; icnt += iinc) {
                                int idxarr = ky * icnt + jcnt;
                                fgrid[kcnt] = ingrid[idxarr];
                                ++kcnt;
                            }
                        }
                        break block17;
                    }
                    if (consec != 0 || boustr != 0) break block18;
                    for (int jcnt = jbeg; 0 <= jcnt && jcnt < ky; jcnt += jinc) {
                        for (int icnt = ibeg; 0 <= icnt && icnt < kx; icnt += iinc) {
                            int idxarr = kx * jcnt + icnt;
                            fgrid[kcnt] = ingrid[idxarr];
                            ++kcnt;
                        }
                    }
                    break block17;
                }
                if (consec != 1 || boustr != 1) break block19;
                for (int jcnt = jbeg; 0 <= jcnt && jcnt < ky; jcnt += jinc) {
                    int itmp = jcnt;
                    if (idrct == 1 && kx % 2 == 0) {
                        itmp = ky - jcnt - 1;
                    }
                    for (int icnt = ibeg; 0 <= icnt && icnt < kx; icnt += iinc) {
                        int idxarr = ky * icnt + itmp;
                        fgrid[kcnt] = ingrid[idxarr];
                        itmp = itmp != jcnt ? jcnt : ky - jcnt - 1;
                        ++kcnt;
                    }
                }
                break block17;
            }
            if (consec != 0 || boustr != 1) break block17;
            if (jdrct == 0) {
                if (idrct == 0 && ky % 2 == 0) {
                    ibeg = kx - 1;
                    iinc = -1;
                }
                if (idrct == 1 && ky % 2 == 0) {
                    ibeg = 0;
                    iinc = 1;
                }
            }
            for (int jcnt = jbeg; 0 <= jcnt && jcnt < ky; jcnt += jinc) {
                for (int icnt = ibeg; 0 <= icnt && icnt < kx; icnt += iinc) {
                    int idxarr = kx * jcnt + icnt;
                    fgrid[kcnt] = ingrid[idxarr];
                    ++kcnt;
                }
                ibeg = ibeg != 0 ? 0 : kx - 1;
                iinc = iinc != 1 ? 1 : -1;
            }
        }
        return fgrid;
    }

    private int bits2UInt(int nb) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.getNextByte();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.getNextByte();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    private void getNextByte() throws IOException {
        if (!this.needToSwap) {
            this.bitBuf = this.rf.read();
        } else {
            if (this.next == 3) {
                this.bitBuf = this.ch3;
            } else if (this.next == 2) {
                this.bitBuf = this.ch2;
            } else if (this.next == 1) {
                this.bitBuf = this.ch1;
            } else {
                this.ch1 = this.rf.read();
                this.ch2 = this.rf.read();
                this.ch3 = this.rf.read();
                this.bitBuf = this.ch4 = this.rf.read();
                this.next = 4;
            }
            --this.next;
        }
    }

    private void logWarning(String message) {
        log.warn(this.rf.getLocation() + ": " + message);
    }
}

