/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import ucar.nc2.iosp.bufr.Message;

public class MessageWriter {
    private final WritableByteChannel wbc;
    private final FileOutputStream fos;
    private final AtomicBoolean isScheduled = new AtomicBoolean(false);
    private long lastModified;

    MessageWriter(File file, short fileno, List<Message> bufrTableMessages) throws IOException {
        this.fos = new FileOutputStream(file, true);
        this.wbc = this.fos.getChannel();
        for (Message m3 : bufrTableMessages) {
            this.write(m3);
        }
    }

    public void write(Message m3) throws IOException {
        this.wbc.write(ByteBuffer.wrap(m3.getHeader().getBytes(StandardCharsets.UTF_8)));
        this.wbc.write(ByteBuffer.wrap(m3.getRawBytes()));
        this.lastModified = System.currentTimeMillis();
        this.isScheduled.getAndSet(false);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void close() throws IOException {
        this.wbc.close();
        this.fos.close();
    }
}

