/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateEns;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.coord.CoordinateVert;
import ucar.nc2.grib.coord.EnsCoordValue;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.grib.coord.VertCoordType;
import ucar.nc2.grib.coord.VertCoordValue;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.util.Parameter;

class GribIospBuilder {
    private final GribIosp iosp;
    private final boolean isGrib1;
    private final Logger logger;
    private final GribCollectionImmutable gribCollection;
    private final GribTables gribTable;

    GribIospBuilder(GribIosp iosp, boolean isGrib1, Logger logger, GribCollectionImmutable gribCollection, GribTables gribTable) {
        this.iosp = iosp;
        this.isGrib1 = isGrib1;
        this.logger = logger;
        this.gribCollection = gribCollection;
        this.gribTable = gribTable;
    }

    void addGroup(Group.Builder parent, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype, boolean useGroups) {
        Group.Builder g2;
        if (useGroups) {
            if (parent.findGroupLocal(group.getId()).isPresent()) {
                this.logger.warn("Duplicate Group - skipping");
                return;
            }
            g2 = Group.builder();
            g2.setName(group.getId());
            g2.addAttribute(new Attribute("long_name", group.getDescription()));
            parent.addGroup(g2);
        } else {
            g2 = parent;
        }
        this.makeGroup(g2, group, gctype);
    }

    private void makeGroup(Group.Builder g2, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype) {
        String horizDims;
        Object hcsV;
        boolean isLatLon;
        GdsHorizCoordSys hcs = group.getGdsHorizCoordSys();
        String grid_mapping = hcs.getName() + "_Projection";
        boolean isRotatedLatLon = !this.isGrib1 && hcs.proj instanceof RotatedPole;
        boolean isLatLon2D = !this.isGrib1 && Grib2Utils.isCurvilinearOrthogonal(hcs.template, this.gribCollection.getCenter());
        boolean bl = isLatLon = this.isGrib1 ? hcs.isLatLon() : Grib2Utils.isLatLon(hcs.template, this.gribCollection.getCenter());
        if (isRotatedLatLon) {
            hcsV = ((Variable.Builder)Variable.builder().setName(grid_mapping)).setDataType(DataType.INT);
            g2.addVariable((Variable.Builder<?>)hcsV);
            ((Variable.Builder)hcsV).setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}), false);
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                ((Variable.Builder)hcsV).addAttribute(new Attribute(p));
            }
            horizDims = "rlat rlon";
            g2.addDimension(new Dimension("rlat", hcs.ny));
            g2.addDimension(new Dimension("rlon", hcs.nx));
            Iterator<Parameter> rlat = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName("rlat")).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName("rlat");
            g2.addVariable((Variable.Builder<?>)((Object)rlat));
            ((Variable.Builder)((Object)rlat)).addAttribute(new Attribute("standard_name", "grid_latitude"));
            ((Variable.Builder)((Object)rlat)).addAttribute(new Attribute("units", "degrees"));
            ((Variable.Builder)((Object)rlat)).setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy), false);
            Object rlon = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName("rlon")).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName("rlon");
            g2.addVariable((Variable.Builder<?>)rlon);
            ((Variable.Builder)rlon).addAttribute(new Attribute("standard_name", "grid_longitude"));
            ((Variable.Builder)rlon).addAttribute(new Attribute("units", "degrees"));
            ((Variable.Builder)rlon).setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx), false);
        } else if (isLatLon2D) {
            horizDims = "lat lon";
            g2.addDimension(new Dimension("lon", hcs.nx));
            g2.addDimension(new Dimension("lat", hcs.ny));
        } else if (isLatLon) {
            hcsV = ((Variable.Builder)Variable.builder().setName(grid_mapping)).setDataType(DataType.INT);
            g2.addVariable((Variable.Builder<?>)hcsV);
            ((Variable.Builder)hcsV).setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}), false);
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                ((Variable.Builder)hcsV).addAttribute(new Attribute(p));
            }
            horizDims = "lat lon";
            g2.addDimension(new Dimension("lon", hcs.nx));
            g2.addDimension(new Dimension("lat", hcs.ny));
            Iterator<Parameter> lat = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName("lat")).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName("lat");
            g2.addVariable((Variable.Builder<?>)((Object)lat));
            ((Variable.Builder)((Object)lat)).addAttribute(new Attribute("units", "degrees_north"));
            if (hcs.getGaussianLats() != null) {
                ((Variable.Builder)((Object)lat)).setCachedData(hcs.getGaussianLats(), false);
                ((Variable.Builder)((Object)lat)).addAttribute(new Attribute("gaussian_lats", "true"));
            } else {
                ((Variable.Builder)((Object)lat)).setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy), false);
            }
            Object lon = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName("lon")).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName("lon");
            g2.addVariable((Variable.Builder<?>)lon);
            ((Variable.Builder)lon).addAttribute(new Attribute("units", "degrees_east"));
            ((Variable.Builder)lon).setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx), false);
        } else {
            hcsV = ((Variable.Builder)Variable.builder().setName(grid_mapping)).setDataType(DataType.INT);
            g2.addVariable((Variable.Builder<?>)hcsV);
            ((Variable.Builder)hcsV).setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}), false);
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                ((Variable.Builder)hcsV).addAttribute(new Attribute(p));
            }
            horizDims = "y x";
            g2.addDimension(new Dimension("x", hcs.nx));
            g2.addDimension(new Dimension("y", hcs.ny));
            Object xcv = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName("x")).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName("x");
            g2.addVariable((Variable.Builder<?>)xcv);
            ((Variable.Builder)xcv).addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            ((Variable.Builder)xcv).addAttribute(new Attribute("units", "km"));
            ((Variable.Builder)xcv).setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx), false);
            Object ycv = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName("y")).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName("y");
            g2.addVariable((Variable.Builder<?>)ycv);
            ((Variable.Builder)ycv).addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            ((Variable.Builder)ycv).addAttribute(new Attribute("units", "km"));
            ((Variable.Builder)ycv).setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy), false);
        }
        for (Coordinate coord : group.coords) {
            Coordinate.Type ctype = coord.getType();
            switch (ctype) {
                case runtime: {
                    if (!gctype.isTwoD() && coord.getNCoords() != 1) break;
                    this.makeRuntimeCoordinate(g2, (CoordinateRuntime)coord);
                    break;
                }
                case timeIntv: {
                    this.makeTimeCoordinate1D(g2, (CoordinateTimeIntv)coord);
                    break;
                }
                case time: {
                    this.makeTimeCoordinate1D(g2, (CoordinateTime)coord);
                    break;
                }
                case vert: {
                    this.makeVerticalCoordinate(g2, (CoordinateVert)coord);
                    break;
                }
                case ens: {
                    this.makeEnsembleCoordinate(g2, (CoordinateEns)coord);
                    break;
                }
                case time2D: {
                    String timeDimName;
                    if (gctype.isUniqueTime()) {
                        this.makeUniqueTimeCoordinate2D(g2, (CoordinateTime2D)coord);
                        break;
                    }
                    CoordinateTime2D time2D = (CoordinateTime2D)coord;
                    if (time2D.isOrthogonal()) {
                        timeDimName = this.makeTimeOffsetOrthogonal(g2, time2D);
                        this.makeTimeCoordinate2D(g2, time2D, timeDimName);
                        break;
                    }
                    if (time2D.isRegular()) {
                        timeDimName = this.makeTimeOffsetRegular(g2, time2D);
                        this.makeTimeCoordinate2D(g2, time2D, timeDimName);
                        break;
                    }
                    this.makeTimeCoordinate2D(g2, time2D, this.make2dValidTimeDimensionName(time2D.getName()));
                }
            }
        }
        for (GribCollectionImmutable.VariableIndex vindex : group.variList) {
            try (Formatter dimNames = new Formatter();
                 Formatter coordinateAtt = new Formatter();){
                Coordinate run = vindex.getCoordinate(Coordinate.Type.runtime);
                CoordinateTimeAbstract time = vindex.getCoordinateTime();
                if (time == null) {
                    throw new IllegalStateException("No time coordinate = " + vindex);
                }
                String timeDimName = time.getName();
                String timeCoordName = time.getName();
                if (time instanceof CoordinateTime2D) {
                    CoordinateTime2D time2D = (CoordinateTime2D)time;
                    if (!gctype.isUniqueTime() && (time2D.isOrthogonal() || time2D.isRegular())) {
                        timeDimName = this.makeTimeOffsetName(time.getName());
                    } else {
                        timeDimName = this.make2dValidTimeDimensionName(time.getName());
                        timeCoordName = this.make2dValidTimeCoordName(timeDimName);
                    }
                }
                boolean isRunScaler = run != null && run.getSize() == 1;
                switch (gctype) {
                    case SRC: {
                        assert (isRunScaler);
                        dimNames.format("%s ", timeDimName);
                        coordinateAtt.format("%s %s ", run.getName(), timeDimName);
                        break;
                    }
                    case MRUTP: 
                    case MRUTC: {
                        dimNames.format("%s ", timeDimName);
                        coordinateAtt.format("ref%s %s ", timeDimName, timeDimName);
                        break;
                    }
                    case MRC: 
                    case TwoD: {
                        assert (run != null) : "GRIB MRC or TWOD does not have run coordinate";
                        if (isRunScaler) {
                            dimNames.format("%s ", timeDimName);
                        } else {
                            dimNames.format("%s %s ", run.getName(), timeDimName);
                        }
                        coordinateAtt.format("%s %s ", run.getName(), timeCoordName);
                        if (timeDimName == timeCoordName) break;
                        coordinateAtt.format("%s ", timeDimName);
                        break;
                    }
                    case Best: 
                    case BestComplete: {
                        dimNames.format("%s ", timeDimName);
                        coordinateAtt.format("ref%s %s ", timeDimName, timeDimName);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Uknown GribCollection TYpe = " + (Object)((Object)gctype));
                    }
                }
                for (Coordinate coord : vindex.getCoordinates()) {
                    if (coord instanceof CoordinateTimeAbstract || coord instanceof CoordinateRuntime) continue;
                    String name = coord.getName().toLowerCase();
                    dimNames.format("%s ", name);
                    coordinateAtt.format("%s ", name);
                }
                dimNames.format("%s", horizDims);
                coordinateAtt.format("%s ", horizDims);
                String vname = this.iosp.makeVariableName(vindex);
                Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(vname)).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName(dimNames.toString());
                g2.addVariable((Variable.Builder<?>)v);
                String desc = this.iosp.makeVariableLongName(vindex);
                ((Variable.Builder)v).addAttribute(new Attribute("long_name", desc));
                ((Variable.Builder)v).addAttribute(new Attribute("units", this.iosp.makeVariableUnits(vindex)));
                GribTables.Parameter gp = this.iosp.getParameter(vindex);
                if (gp != null) {
                    if (gp.getDescription() != null) {
                        ((Variable.Builder)v).addAttribute(new Attribute("description", gp.getDescription()));
                    }
                    if (gp.getAbbrev() != null) {
                        ((Variable.Builder)v).addAttribute(new Attribute("abbreviation", gp.getAbbrev()));
                    }
                    ((Variable.Builder)v).addAttribute(new Attribute("missing_value", gp.getMissing()));
                    if (gp.getFill() != null) {
                        ((Variable.Builder)v).addAttribute(new Attribute("_FillValue", gp.getFill()));
                    }
                } else {
                    ((Variable.Builder)v).addAttribute(new Attribute("missing_value", Float.valueOf(Float.NaN)));
                }
                if (isLatLon2D) {
                    String s2 = this.iosp.searchCoord(Grib2Utils.getLatLon2DcoordType(desc), group.variList);
                    if (s2 == null) {
                        ((Variable.Builder)v).setDimensionsByName(horizDims);
                        String units = desc.contains("Latitude of") ? "degrees_north" : "degrees_east";
                        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
                    } else {
                        coordinateAtt.format("%s ", s2);
                    }
                } else {
                    ((Variable.Builder)v).addAttribute(new Attribute("grid_mapping", grid_mapping));
                }
                ((Variable.Builder)v).addAttribute(new Attribute("coordinates", coordinateAtt.toString()));
                if (vindex.getIntvType() >= 0) {
                    GribStatType statType = this.gribTable.getStatType(vindex.getIntvType());
                    if (statType != null) {
                        ((Variable.Builder)v).addAttribute(new Attribute("Grib_Statistical_Interval_Type", statType.toString()));
                        CF.CellMethods cm = GribStatType.getCFCellMethod(statType);
                        Coordinate timeCoord = vindex.getCoordinate(Coordinate.Type.timeIntv);
                        if (cm != null && timeCoord != null) {
                            ((Variable.Builder)v).addAttribute(new Attribute("cell_methods", timeCoord.getName() + ": " + (Object)((Object)cm)));
                        }
                    } else {
                        ((Variable.Builder)v).addAttribute(new Attribute("Grib_Statistical_Interval_Type", vindex.getIntvType()));
                    }
                }
                this.gribCollection.addVariableAttributes(((Variable.Builder)v).getAttributeContainer(), vindex);
                ((Variable.Builder)v).setSPobject(vindex);
            }
        }
    }

    private void makeRuntimeCoordinate(Group.Builder g2, CoordinateRuntime rtc) {
        int n = rtc.getSize();
        boolean isScalar = n == 1;
        String tcName = rtc.getName();
        String dims = isScalar ? null : rtc.getName();
        g2.addDimension(new Dimension(tcName, n));
        Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(dims);
        g2.addVariable((Variable.Builder<?>)v);
        ((Variable.Builder)v).addAttribute(new Attribute("units", rtc.getUnit()));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB reference time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.reftime, null, rtc));
    }

    private void makeUniqueTimeCoordinate2D(Group.Builder g2, CoordinateTime2D time2D) {
        String refName;
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int countU = 0;
        for (int run = 0; run < time2D.getNruns(); ++run) {
            CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
            countU += timeCoord.getSize();
        }
        int ntimes = countU;
        String tcName = time2D.getName();
        String timeDimName = this.make2dValidTimeDimensionName(tcName);
        g2.addDimension(new Dimension(timeDimName, ntimes));
        Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(timeDimName);
        g2.addVariable((Variable.Builder<?>)v);
        String units = runtime.getUnit();
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!time2D.isTimeInterval()) {
            ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.offU, time2D, null));
        } else {
            ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.intvU, time2D, null));
            String bounds_name = timeDimName + "_bounds";
            Object bounds = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(bounds_name)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(timeDimName + " 2");
            g2.addVariable((Variable.Builder<?>)bounds);
            ((Variable.Builder)v).addAttribute(new Attribute("bounds", bounds_name));
            ((Variable.Builder)bounds).addAttribute(new Attribute("units", units));
            ((Variable.Builder)bounds).addAttribute(new Attribute("long_name", "bounds for " + tcName));
            ((Variable.Builder)bounds).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.boundsU, time2D, null));
        }
        if (runtime.getNCoords() != 1 && !g2.findVariableLocal(refName = "ref" + tcName).isPresent()) {
            Object vref = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(refName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(timeDimName);
            g2.addVariable((Variable.Builder<?>)vref);
            ((Variable.Builder)vref).addAttribute(new Attribute("standard_name", "forecast_reference_time"));
            ((Variable.Builder)vref).addAttribute(new Attribute("long_name", "GRIB reference time"));
            ((Variable.Builder)vref).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
            ((Variable.Builder)vref).addAttribute(new Attribute("units", units));
            ((Variable.Builder)vref).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.isUniqueRuntime, time2D, null));
        }
    }

    private String make2dValidTimeDimensionName(String variableName) {
        return variableName.replaceFirst("valid", "");
    }

    private String make2dValidTimeCoordName(String dimName) {
        return "valid" + dimName;
    }

    private String makeTimeOffsetName(String timeName) {
        return timeName.toLowerCase() + "Offset";
    }

    private void makeTimeCoordinate2D(Group.Builder g2, CoordinateTime2D time2D, String timeDimName) {
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int ntimes = time2D.getNtimes();
        String tcName = time2D.getName();
        String dims = runtime.getName() + " " + timeDimName;
        int dimLength = ntimes;
        g2.addDimensionIfNotExists(new Dimension(timeDimName, dimLength));
        Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(dims);
        g2.addVariable((Variable.Builder<?>)v);
        String units = runtime.getUnit();
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!tcName.equalsIgnoreCase(timeDimName)) {
            ((Variable.Builder)v).addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        }
        if (!time2D.isTimeInterval()) {
            ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.off, time2D, null));
        } else {
            ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.intv, time2D, null));
            String bounds_name = tcName + "_bounds";
            Object bounds = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(bounds_name)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(dims + " 2");
            g2.addVariable((Variable.Builder<?>)bounds);
            ((Variable.Builder)v).addAttribute(new Attribute("bounds", bounds_name));
            ((Variable.Builder)bounds).addAttribute(new Attribute("units", units));
            ((Variable.Builder)bounds).addAttribute(new Attribute("long_name", "bounds for " + tcName));
            ((Variable.Builder)bounds).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.bounds, time2D, null));
        }
    }

    private Array makeLazyCoordinateData(Variable v2, GribIosp.Time2Dinfo info) {
        if (info.time2D != null) {
            return this.makeLazyTime2Darray(v2, info);
        }
        return this.makeLazyTime1Darray(v2, info);
    }

    private Array makeLazyTime1Darray(Variable v2, GribIosp.Time2Dinfo info) {
        int length = info.time1D.getSize();
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case reftime: {
                CoordinateRuntime rtc = (CoordinateRuntime)info.time1D;
                int count = 0;
                for (double val : rtc.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
            case timeAuxRef: {
                CoordinateTimeAbstract time = (CoordinateTimeAbstract)info.time1D;
                int count = 0;
                List<Double> masterOffsets = this.gribCollection.getMasterRuntime().getOffsetsInTimeUnits();
                for (int masterIdx : time.getTime2runtime()) {
                    data[count++] = masterOffsets.get(masterIdx - 1);
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
        }
        throw new IllegalStateException("makeLazyTime1Darray must be reftime or timeAuxRef");
    }

    private Array makeLazyTime2Darray(Variable coord, GribIosp.Time2Dinfo info) {
        CoordinateTime2D time2D = info.time2D;
        CalendarPeriod timeUnit = time2D.getTimeUnit();
        int nruns = time2D.getNruns();
        int ntimes = time2D.getNtimes();
        int length = (int)coord.getSize();
        if (info.which == GribIosp.Time2DinfoType.bounds) {
            length *= 2;
        }
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case off: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (int val : coordTime.getOffsetSorted()) {
                        data[runIdx * ntimes + timeIdx] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case offU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    for (int val : coordTime.getOffsetSorted()) {
                        data[count++] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case intv: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes + timeIdx] = (double)timeUnit.getValue() * tinv.getCoordValue() + (double)time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case intvU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = (double)timeUnit.getValue() * tinv.getCoordValue() + (double)time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case is1Dtime: {
                CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
                int count = 0;
                for (double val : runtime.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                break;
            }
            case isUniqueRuntime: {
                CoordinateRuntime runtimeU = time2D.getRuntimeCoordinate();
                List<Double> runOffsets = runtimeU.getOffsetsInTimeUnits();
                int count = 0;
                for (int run = 0; run < time2D.getNruns(); ++run) {
                    CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
                    for (int time = 0; time < timeCoord.getNCoords(); ++time) {
                        data[count++] = runOffsets.get(run);
                    }
                }
                break;
            }
            case bounds: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes * 2 + timeIdx] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[runIdx * ntimes * 2 + timeIdx + 1] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                        timeIdx += 2;
                    }
                }
                break;
            }
            case boundsU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Array.factory(DataType.DOUBLE, coord.getShape(), (Object)data);
    }

    private void makeTimeCoordinate1D(Group.Builder g2, CoordinateTime coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        g2.addDimension(new Dimension(tcName, ntimes));
        Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(dims);
        g2.addVariable((Variable.Builder<?>)v);
        String units = coordTime.getTimeUdUnit();
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (int val : coordTime.getOffsetSorted()) {
            data[count++] = val;
        }
        ((Variable.Builder)v).setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)data), false);
        this.makeTimeAuxReference(g2, tcName, units, coordTime);
    }

    private void makeTimeAuxReference(Group.Builder g2, String timeName, String units, CoordinateTimeAbstract time) {
        if (time.getTime2runtime() == null) {
            return;
        }
        String tcName = "ref" + timeName;
        Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(timeName);
        g2.addVariable((Variable.Builder<?>)v);
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB reference time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.timeAuxRef, null, time));
    }

    private void makeTimeCoordinate1D(Group.Builder g2, CoordinateTimeIntv coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        g2.addDimension(new Dimension(tcName, ntimes));
        Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(dims);
        g2.addVariable((Variable.Builder<?>)v);
        String units = coordTime.getTimeUdUnit();
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (TimeCoordIntvValue tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getCoordValue();
        }
        ((Variable.Builder)v).setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)data), false);
        String bounds_name = tcName + "_bounds";
        Object bounds = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(bounds_name)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(dims + " 2");
        g2.addVariable((Variable.Builder<?>)bounds);
        ((Variable.Builder)v).addAttribute(new Attribute("bounds", bounds_name));
        ((Variable.Builder)bounds).addAttribute(new Attribute("units", units));
        ((Variable.Builder)bounds).addAttribute(new Attribute("long_name", "bounds for " + tcName));
        data = new double[ntimes * 2];
        count = 0;
        for (TimeCoordIntvValue tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds1();
            data[count++] = tinv.getBounds2();
        }
        ((Variable.Builder)bounds).setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes, 2}, (Object)data), false);
        this.makeTimeAuxReference(g2, tcName, units, coordTime);
    }

    private void makeVerticalCoordinate(Group.Builder g2, CoordinateVert vc) {
        int n = vc.getSize();
        String vcName = vc.getName().toLowerCase();
        g2.addDimension(new Dimension(vcName, n));
        Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(vcName)).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName(vcName);
        g2.addVariable((Variable.Builder<?>)v);
        if (vc.getUnit() != null) {
            ((Variable.Builder)v).addAttribute(new Attribute("units", vc.getUnit()));
            String desc = this.iosp.getVerticalCoordDesc(vc.getCode());
            if (desc != null) {
                ((Variable.Builder)v).addAttribute(new Attribute("long_name", desc));
            }
            ((Variable.Builder)v).addAttribute(new Attribute("positive", vc.isPositiveUp() ? "up" : "down"));
        }
        ((Variable.Builder)v).addAttribute(new Attribute("Grib_level_type", vc.getCode()));
        VertCoordType vu = vc.getVertUnit();
        if (vu != null && vu.getDatum() != null) {
            ((Variable.Builder)v).addAttribute(new Attribute("datum", vu.getDatum()));
        }
        if (vc.isLayer()) {
            float[] data = new float[n];
            int count = 0;
            for (VertCoordValue val : vc.getLevelSorted()) {
                data[count++] = (float)(val.getValue1() + val.getValue2()) / 2.0f;
            }
            ((Variable.Builder)v).setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data), false);
            Object bounds = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(vcName + "_bounds")).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName(vcName + " 2");
            g2.addVariable((Variable.Builder<?>)bounds);
            ((Variable.Builder)v).addAttribute(new Attribute("bounds", vcName + "_bounds"));
            String vcUnit = vc.getUnit();
            if (vcUnit != null) {
                ((Variable.Builder)bounds).addAttribute(new Attribute("units", vcUnit));
            }
            ((Variable.Builder)bounds).addAttribute(new Attribute("long_name", "bounds for " + vcName));
            data = new float[2 * n];
            count = 0;
            for (VertCoordValue level : vc.getLevelSorted()) {
                data[count++] = (float)level.getValue1();
                data[count++] = (float)level.getValue2();
            }
            ((Variable.Builder)bounds).setCachedData(Array.factory(DataType.FLOAT, new int[]{n, 2}, (Object)data), false);
        } else {
            float[] data = new float[n];
            int count = 0;
            for (VertCoordValue val : vc.getLevelSorted()) {
                data[count++] = (float)val.getValue1();
            }
            ((Variable.Builder)v).setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data), false);
        }
    }

    private void makeEnsembleCoordinate(Group.Builder g2, CoordinateEns ec) {
        int n = ec.getSize();
        String ecName = ec.getName().toLowerCase();
        g2.addDimension(new Dimension(ecName, n));
        Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(ecName)).setDataType(DataType.INT)).setParentGroupBuilder(g2)).setDimensionsByName(ecName);
        g2.addVariable((Variable.Builder<?>)v);
        ((Variable.Builder)v).addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
        int[] data = new int[n];
        int count = 0;
        for (EnsCoordValue ecc : ec.getEnsSorted()) {
            data[count++] = ecc.getEnsMember();
        }
        ((Variable.Builder)v).setCachedData(Array.factory(DataType.INT, new int[]{n}, (Object)data), false);
    }

    private String makeTimeOffsetOrthogonal(Group.Builder g2, CoordinateTime2D time2D) {
        int count;
        List<?> offsets = time2D.getOffsetsSorted();
        int n = offsets.size();
        String toName = this.makeTimeOffsetName(time2D.getName());
        g2.addDimension(new Dimension(toName, n));
        Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(toName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(g2)).setDimensionsByName(toName);
        g2.addVariable((Variable.Builder<?>)v);
        ((Variable.Builder)v).addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
        ((Variable.Builder)v).addAttribute(new Attribute("units", time2D.getUnit()));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "forecast_period"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "time offset from runtime"));
        ((Variable.Builder)v).addAttribute(new Attribute("udunits", time2D.getTimeUdUnit()));
        ((Variable.Builder)v).addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
        double[] midpoints = new double[n];
        double[] bounds = null;
        if (time2D.isTimeInterval()) {
            bounds = new double[2 * n];
            count = 0;
            int countb = 0;
            for (Object offset : offsets) {
                TimeCoordIntvValue tinv = (TimeCoordIntvValue)offset;
                midpoints[count++] = (double)(tinv.getBounds1() + tinv.getBounds2()) / 2.0;
                bounds[countb++] = tinv.getBounds1();
                bounds[countb++] = tinv.getBounds2();
            }
        } else {
            count = 0;
            for (Object val : offsets) {
                Integer off = (Integer)val;
                midpoints[count++] = off.intValue();
            }
        }
        ((Variable.Builder)v).setCachedData(Array.factory(DataType.DOUBLE, new int[]{n}, (Object)midpoints), false);
        if (time2D.isTimeInterval()) {
            String boundsName = toName + "_bounds";
            Object coordVarBounds = ((VariableDS.Builder)((VariableDS.Builder)((Variable.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(boundsName)).setDataType(DataType.DOUBLE)).setDesc("TimeOffset coord bounds")).setParentGroupBuilder(g2)).setDimensionsByName(toName + " 2")).setCachedData(Array.factory(DataType.DOUBLE, new int[]{n, 2}, (Object)bounds), false);
            g2.addVariable((Variable.Builder<?>)coordVarBounds);
            ((Variable.Builder)v).addAttribute(new Attribute("bounds", boundsName));
        }
        return toName;
    }

    private String makeTimeOffsetRegular(Group.Builder gb, CoordinateTime2D time2D) {
        try {
            int houridx;
            ImmutableList<Object> hourFrom0z = ImmutableList.copyOf(time2D.getRegularHourOffsets());
            int nhours = hourFrom0z.size();
            int noffsets = time2D.getNtimes();
            String toName = this.makeTimeOffsetName(time2D.getName());
            gb.addDimension(new Dimension(toName, noffsets));
            String dimNames = nhours + " " + toName;
            Object v = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(toName)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(gb)).setDimensionsByName(dimNames);
            gb.addVariable((Variable.Builder<?>)v);
            ((Variable.Builder)v).addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
            ((Variable.Builder)v).addAttribute(new Attribute("units", time2D.getUnit()));
            ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "forecast_period"));
            ((Variable.Builder)v).addAttribute(new Attribute("long_name", "time offset from runtime"));
            ((Variable.Builder)v).addAttribute(new Attribute("udunits", time2D.getTimeUdUnit()));
            ((Variable.Builder)v).addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
            ((Variable.Builder)v).addAttribute(new Attribute("runtimeCoordinate", gb.makeFullName() + time2D.getRuntimeCoordinate().getName()));
            Attribute.Builder attb = Attribute.builder("hoursFrom0z").setDataType(DataType.INT).setValues(hourFrom0z, false);
            ((Variable.Builder)v).addAttribute(attb.build());
            double[] midpoints = new double[nhours * noffsets];
            Arrays.fill(midpoints, Double.NaN);
            double[] bounds = null;
            if (time2D.isTimeInterval()) {
                bounds = new double[2 * nhours * noffsets];
                Arrays.fill(bounds, Double.NaN);
                houridx = 0;
                for (int hour : time2D.getRegularHourOffsets()) {
                    CoordinateTimeIntv timeCoord = (CoordinateTimeIntv)time2D.getRegularTimeCoordinate(hour);
                    int count = houridx * noffsets;
                    int countb = 2 * houridx * noffsets;
                    for (TimeCoordIntvValue tinv : timeCoord.getTimeIntervals()) {
                        midpoints[count++] = (double)(tinv.getBounds1() + tinv.getBounds2()) / 2.0;
                        bounds[countb++] = tinv.getBounds1();
                        bounds[countb++] = tinv.getBounds2();
                    }
                    ++houridx;
                }
            } else {
                Arrays.fill(midpoints, Double.NaN);
                houridx = 0;
                for (int hour : time2D.getRegularHourOffsets()) {
                    CoordinateTime timeCoord = (CoordinateTime)time2D.getRegularTimeCoordinate(hour);
                    int count = houridx * noffsets;
                    for (Integer offset : timeCoord.getOffsetSorted()) {
                        midpoints[count++] = offset.intValue();
                    }
                    ++houridx;
                }
            }
            ((Variable.Builder)v).setCachedData(Array.factory(DataType.DOUBLE, new int[]{nhours, noffsets}, (Object)midpoints), false);
            if (time2D.isTimeInterval()) {
                String boundsName = toName + "_bounds";
                Object coordVarBounds = ((VariableDS.Builder)((Variable.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(boundsName)).setDataType(DataType.DOUBLE)).setDesc("time offset coord bounds")).setParentGroupBuilder(gb)).setDimensionsByName(dimNames + " 2");
                gb.addVariable((Variable.Builder<?>)coordVarBounds);
                ((Variable.Builder)coordVarBounds).setCachedData(Array.factory(DataType.DOUBLE, new int[]{nhours, noffsets, 2}, (Object)bounds), false);
                ((Variable.Builder)v).addAttribute(new Attribute("bounds", boundsName));
            }
            return toName;
        }
        catch (Throwable t) {
            this.logger.error("Error in makeTimeOffsetRegular variable {}", (Object)this.makeTimeOffsetName(time2D.getName()), (Object)t);
            throw new RuntimeException(t);
        }
    }
}

