/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.grib.collection.Grib1Collection;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionMutable;
import ucar.nc2.grib.coverage.GribCoverageDataset;

public class Grib1Partition
extends PartitionCollectionImmutable {
    Grib1Partition(PartitionCollectionMutable pc) {
        super(pc);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
        NetcdfFileSubclass ncfile = new NetcdfFileSubclass(iosp, null, this.getLocation(), null);
        return new NetcdfDataset(ncfile);
    }

    @Override
    public GridDataset getGridDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
        NetcdfFileSubclass ncfile = new NetcdfFileSubclass(iosp, null, this.getLocation(), null);
        NetcdfDataset ncd = new NetcdfDataset(ncfile);
        return new GridDataset(ncd);
    }

    @Override
    public CoverageCollection getGridCoverage(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) {
        GribCoverageDataset gribCov = new GribCoverageDataset(this, ds, group);
        return gribCov.createCoverageCollection();
    }

    @Override
    public void addGlobalAttributes(AttributeContainer result) {
        String val = this.cust.getGeneratingProcessName(this.getGenProcessId());
        if (val != null) {
            result.addAttribute(new Attribute("Generating_process_or_model", val));
        }
        result.addAttribute(new Attribute("file_format", DataFormatType.GRIB1.getDescription()));
    }

    @Override
    public void addVariableAttributes(AttributeContainer v, GribCollectionImmutable.VariableIndex vindex) {
        Grib1Collection.addVariableAttributes(v, vindex, this);
    }

    @Override
    public String makeVariableId(GribCollectionImmutable.VariableIndex v) {
        return Grib1Collection.makeVariableId(this.getCenter(), this.getSubcenter(), v.getTableVersion(), v.getParameter(), v.getLevelType(), v.isLayer(), v.getIntvType(), v.getIntvName());
    }
}

