/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.DataInputStream;
import java.io.IOException;
import ucar.mcidas.AncillaryData;
import ucar.mcidas.CalibratorGvar;

public class CalibratorGvarG8
extends CalibratorGvar {
    protected static float[] imager8FK1 = new float[5];
    protected static float[] sounder8FK1 = new float[18];
    protected static float[] imager8FK2 = new float[5];
    protected static float[] sounder8FK2 = new float[18];
    protected static float[] imager8TC1 = new float[5];
    protected static float[] sounder8TC1 = new float[18];
    protected static float[] imager8TC2 = new float[5];
    protected static float[] sounder8TC2 = new float[18];

    public CalibratorGvarG8(DataInputStream dis, AncillaryData ad, int[] cb) throws IOException {
        super(dis, ad, cb);
    }

    public CalibratorGvarG8(int id, int[] cal) {
        super(id, cal);
    }

    @Override
    public float radToTemp(float inVal, int band, int sId) {
        float outVal;
        if (sId % 2 == 0) {
            double expn = (double)(imager8FK1[band - 1] / inVal) + 1.0;
            double temp = (double)imager8FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)imager8TC1[band - 1]) / (double)imager8TC2[band - 1]);
        } else {
            double expn = (double)(sounder8FK1[band - 1] / inVal) + 1.0;
            double temp = (double)sounder8FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)sounder8TC1[band - 1]) / (double)sounder8TC2[band - 1]);
        }
        return outVal;
    }

    static {
        CalibratorGvarG8.imager8FK1[0] = 0.0f;
        CalibratorGvarG8.imager8FK1[1] = 199986.2f;
        CalibratorGvarG8.imager8FK1[2] = 38792.39f;
        CalibratorGvarG8.imager8FK1[3] = 9737.93f;
        CalibratorGvarG8.imager8FK1[4] = 6944.64f;
        CalibratorGvarG8.sounder8FK1[0] = 3756.81f;
        CalibratorGvarG8.sounder8FK1[1] = 4011.1f;
        CalibratorGvarG8.sounder8FK1[2] = 4296.87f;
        CalibratorGvarG8.sounder8FK1[3] = 4681.13f;
        CalibratorGvarG8.sounder8FK1[4] = 4975.25f;
        CalibratorGvarG8.sounder8FK1[5] = 5881.41f;
        CalibratorGvarG8.sounder8FK1[6] = 6787.44f;
        CalibratorGvarG8.sounder8FK1[7] = 8873.71f;
        CalibratorGvarG8.sounder8FK1[8] = 12997.94f;
        CalibratorGvarG8.sounder8FK1[9] = 28629.32f;
        CalibratorGvarG8.sounder8FK1[10] = 34248.3f;
        CalibratorGvarG8.sounder8FK1[11] = 43114.3f;
        CalibratorGvarG8.sounder8FK1[12] = 124235.3f;
        CalibratorGvarG8.sounder8FK1[13] = 128123.5f;
        CalibratorGvarG8.sounder8FK1[14] = 135148.2f;
        CalibratorGvarG8.sounder8FK1[15] = 169167.1f;
        CalibratorGvarG8.sounder8FK1[16] = 188235.0f;
        CalibratorGvarG8.sounder8FK1[17] = 225794.4f;
        CalibratorGvarG8.imager8FK2[0] = 0.0f;
        CalibratorGvarG8.imager8FK2[1] = 3684.27f;
        CalibratorGvarG8.imager8FK2[2] = 2132.72f;
        CalibratorGvarG8.imager8FK2[3] = 1345.37f;
        CalibratorGvarG8.imager8FK2[4] = 1201.99f;
        CalibratorGvarG8.sounder8FK2[0] = 3765.12f;
        CalibratorGvarG8.sounder8FK2[1] = 3981.16f;
        CalibratorGvarG8.sounder8FK2[2] = 4281.88f;
        CalibratorGvarG8.sounder8FK2[3] = 4678.91f;
        CalibratorGvarG8.sounder8FK2[4] = 4962.59f;
        CalibratorGvarG8.sounder8FK2[5] = 5860.42f;
        CalibratorGvarG8.sounder8FK2[6] = 6770.32f;
        CalibratorGvarG8.sounder8FK2[7] = 8958.91f;
        CalibratorGvarG8.sounder8FK2[8] = 12965.93f;
        CalibratorGvarG8.sounder8FK2[9] = 28398.28f;
        CalibratorGvarG8.sounder8FK2[10] = 34201.34f;
        CalibratorGvarG8.sounder8FK2[11] = 42525.14f;
        CalibratorGvarG8.sounder8FK2[12] = 124057.4f;
        CalibratorGvarG8.sounder8FK2[13] = 128011.4f;
        CalibratorGvarG8.sounder8FK2[14] = 134849.7f;
        CalibratorGvarG8.sounder8FK2[15] = 167814.2f;
        CalibratorGvarG8.sounder8FK2[16] = 188801.2f;
        CalibratorGvarG8.sounder8FK2[17] = 225856.5f;
        CalibratorGvarG8.imager8TC1[0] = 0.0f;
        CalibratorGvarG8.imager8TC1[1] = 0.6357f;
        CalibratorGvarG8.imager8TC1[2] = 0.606f;
        CalibratorGvarG8.imager8TC1[3] = 0.3735f;
        CalibratorGvarG8.imager8TC1[4] = 0.2217f;
        CalibratorGvarG8.sounder8TC1[0] = 0.0123f;
        CalibratorGvarG8.sounder8TC1[1] = 0.0133f;
        CalibratorGvarG8.sounder8TC1[2] = 0.0186f;
        CalibratorGvarG8.sounder8TC1[3] = 0.015f;
        CalibratorGvarG8.sounder8TC1[4] = 0.0165f;
        CalibratorGvarG8.sounder8TC1[5] = 0.0474f;
        CalibratorGvarG8.sounder8TC1[6] = 0.1318f;
        CalibratorGvarG8.sounder8TC1[7] = 0.12f;
        CalibratorGvarG8.sounder8TC1[8] = 0.0426f;
        CalibratorGvarG8.sounder8TC1[9] = 0.1505f;
        CalibratorGvarG8.sounder8TC1[10] = 0.2743f;
        CalibratorGvarG8.sounder8TC1[11] = 0.1447f;
        CalibratorGvarG8.sounder8TC1[12] = 0.0224f;
        CalibratorGvarG8.sounder8TC1[13] = 0.022f;
        CalibratorGvarG8.sounder8TC1[14] = 0.0217f;
        CalibratorGvarG8.sounder8TC1[15] = 0.0579f;
        CalibratorGvarG8.sounder8TC1[16] = 0.0623f;
        CalibratorGvarG8.sounder8TC1[17] = 0.3675f;
        CalibratorGvarG8.imager8TC2[0] = 0.0f;
        CalibratorGvarG8.imager8TC2[1] = 0.9991f;
        CalibratorGvarG8.imager8TC2[2] = 0.9986f;
        CalibratorGvarG8.imager8TC2[3] = 0.9987f;
        CalibratorGvarG8.imager8TC2[4] = 0.9992f;
        CalibratorGvarG8.sounder8TC2[0] = 0.9999f;
        CalibratorGvarG8.sounder8TC2[1] = 0.9999f;
        CalibratorGvarG8.sounder8TC2[2] = 0.9999f;
        CalibratorGvarG8.sounder8TC2[3] = 0.9999f;
        CalibratorGvarG8.sounder8TC2[4] = 0.9999f;
        CalibratorGvarG8.sounder8TC2[5] = 0.9998f;
        CalibratorGvarG8.sounder8TC2[6] = 0.9995f;
        CalibratorGvarG8.sounder8TC2[7] = 0.9996f;
        CalibratorGvarG8.sounder8TC2[8] = 0.9999f;
        CalibratorGvarG8.sounder8TC2[9] = 0.9996f;
        CalibratorGvarG8.sounder8TC2[10] = 0.9993f;
        CalibratorGvarG8.sounder8TC2[11] = 0.9997f;
        CalibratorGvarG8.sounder8TC2[12] = 1.0f;
        CalibratorGvarG8.sounder8TC2[13] = 1.0f;
        CalibratorGvarG8.sounder8TC2[14] = 1.0f;
        CalibratorGvarG8.sounder8TC2[15] = 0.9999f;
        CalibratorGvarG8.sounder8TC2[16] = 0.9999f;
        CalibratorGvarG8.sounder8TC2[17] = 0.9995f;
    }
}

