/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.DataInputStream;
import java.io.IOException;
import ucar.mcidas.AncillaryData;
import ucar.mcidas.Calibrator;
import ucar.mcidas.ConversionUtility;

public abstract class CalibratorGvar
implements Calibrator {
    protected static final int NUM_BANDS_IMAGER = 5;
    protected static final int NUM_BANDS_SOUNDER = 18;
    protected static final int NUM_VIS_DETECTORS = 8;
    protected static final int NUM_IR_DETECTORS = 2;
    protected static final int NUM_IR_BANDS = 4;
    protected static final int LOOKUP_TABLE_SZ_IMGR = 1024;
    protected static final int LOOKUP_TABLE_SZ_SNDR = 32768;
    protected static int curCalType = 0;
    protected static int index = 0;
    protected float[] visBiasCoef = new float[8];
    protected float[] visGain1Coef = new float[8];
    protected float[] visGain2Coef = new float[8];
    protected float visBiasCoefAVG = 0.0f;
    protected float visGain1CoefAVG = 0.0f;
    protected float visGain2CoefAVG = 0.0f;
    protected float visRadToAlb = 0.0f;
    protected float[][] irBiasCoef = new float[2][4];
    protected float[][] irGainCoef = new float[2][4];
    protected float[] sBiasCoef = new float[18];
    protected float[] sGainCoef = new float[18];
    protected float[][] lookupTable;
    private static float gain = 0.0f;
    private static float bias = 0.0f;
    private static int scale = 1;
    private static int bandNum = 0;
    private static int sid = 0;
    public boolean isPreCalibrated = false;

    public CalibratorGvar(DataInputStream dis, AncillaryData ad, int[] calBlock) throws IOException {
        sid = ad.getSensorId();
        if (calBlock != null) {
            this.initGvar(ad.getSensorId(), calBlock);
        }
    }

    public CalibratorGvar(int sensorId, int[] calBlock) {
        sid = sensorId;
        if (calBlock != null) {
            this.initGvar(sensorId, calBlock);
        } else {
            this.setIsPreCalibrated(true);
        }
    }

    public void initGvar(int sensorId, int[] calBlock) {
        int calIndex = 0;
        sid = sensorId;
        int irOffset = 2;
        if (sid > 77) {
            irOffset = 0;
        }
        if (sid % 2 == 0) {
            int i;
            this.lookupTable = new float[5][1024];
            for (i = 0; i < 5; ++i) {
                for (int j = 0; j < 1024; ++j) {
                    this.lookupTable[i][j] = Float.NaN;
                }
            }
            for (i = 0; i < 8; ++i) {
                this.visBiasCoef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                this.visBiasCoefAVG += this.visBiasCoef[i];
                ++calIndex;
            }
            this.visBiasCoefAVG /= 8.0f;
            for (i = 0; i < 8; ++i) {
                this.visGain1Coef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                this.visGain1CoefAVG += this.visGain1Coef[i];
                ++calIndex;
            }
            this.visGain1CoefAVG /= 8.0f;
            for (i = 0; i < 8; ++i) {
                this.visGain2Coef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                this.visGain2CoefAVG += this.visGain2Coef[i];
                ++calIndex;
            }
            this.visGain2CoefAVG /= 8.0f;
            this.visRadToAlb = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
            ++calIndex;
            for (i = 0; i < 4; ++i) {
                this.irBiasCoef[0][(i + irOffset) % 4] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 4; ++i) {
                this.irBiasCoef[1][(i + irOffset) % 4] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 4; ++i) {
                this.irGainCoef[0][(i + irOffset) % 4] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 4; ++i) {
                this.irGainCoef[1][(i + irOffset) % 4] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
        } else {
            int i;
            this.lookupTable = new float[19][32768];
            for (i = 0; i < 19; ++i) {
                for (int j = 0; j < 32768; ++j) {
                    this.lookupTable[i][j] = Float.NaN;
                }
            }
            for (i = 0; i < 4; ++i) {
                this.visBiasCoef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                this.visBiasCoefAVG += this.visBiasCoef[i];
                ++calIndex;
            }
            this.visBiasCoefAVG /= 4.0f;
            for (i = 0; i < 4; ++i) {
                this.visGain1Coef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                this.visGain1CoefAVG += this.visGain1Coef[i];
                ++calIndex;
            }
            this.visGain1CoefAVG /= 4.0f;
            for (i = 0; i < 4; ++i) {
                this.visGain2Coef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                this.visGain2CoefAVG += this.visGain2Coef[i];
                ++calIndex;
            }
            this.visGain2CoefAVG /= 4.0f;
            this.visRadToAlb = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
            ++calIndex;
            for (i = 0; i < 18; ++i) {
                this.sBiasCoef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
            for (i = 0; i < 18; ++i) {
                this.sGainCoef[i] = (float)ConversionUtility.GouldToNative(calBlock[calIndex]);
                ++calIndex;
            }
        }
    }

    @Override
    public int setCalType(int calType) {
        if (calType < 1 || calType > 5) {
            return -1;
        }
        curCalType = calType;
        return 0;
    }

    public abstract float radToTemp(float var1, int var2, int var3);

    @Override
    public float[] calibrate(float[] inputData, int band, int calTypeOut) {
        float[] outputData = new float[inputData.length];
        for (int i = 0; i < inputData.length; ++i) {
            outputData[i] = this.calibrate(inputData[i], band, calTypeOut);
        }
        return outputData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float calibrate(float inputPixel, int band, int calTypeOut) {
        float outputData = 0.0f;
        if (band != bandNum) {
            bandNum = band;
            if (sid % 2 == 0) {
                if (band == 1) {
                    gain = this.visGain1Coef[0];
                    bias = this.visBiasCoef[0];
                } else {
                    if (band == 6) {
                        band = 5;
                    }
                    gain = this.irGainCoef[0][band - 2];
                    bias = this.irBiasCoef[0][band - 2];
                }
                scale = 32;
            } else {
                if (band == 19) {
                    gain = this.visGain1Coef[0];
                    bias = this.visBiasCoef[0];
                } else {
                    gain = this.sGainCoef[band - 1];
                    bias = this.sBiasCoef[band - 1];
                }
                scale = 2;
            }
        }
        index = curCalType == 5 ? (int)inputPixel + 128 : (int)inputPixel / scale;
        switch (curCalType) {
            case 1: {
                outputData = inputPixel;
                if (calTypeOut == 1) return outputData;
                if (band == 1 || band == 19) {
                    float f = inputPixel / (float)scale;
                    float G2TERM = 1.0f;
                    if ((double)Math.abs(this.visGain2CoefAVG) > 1.0E-4) {
                        G2TERM = (float)Math.pow(f, this.visGain2CoefAVG);
                    }
                    if ((double)(outputData = (G2TERM + f * this.visGain1CoefAVG + this.visBiasCoefAVG) * this.visRadToAlb) < 0.0) {
                        outputData = 0.0f;
                    }
                    if (calTypeOut == 3) {
                        outputData *= 100.0f;
                        return outputData;
                    }
                    outputData = Math.round(Math.sqrt(100.0 * (double)outputData) * 25.5);
                    if (calTypeOut != 5) return outputData;
                }
                if (sid % 2 == 0) {
                    outputData = inputPixel / (float)scale;
                }
                outputData = (outputData - bias) / gain;
                if (calTypeOut == 2) return outputData;
                outputData = this.radToTemp(outputData, band, sid);
                if (calTypeOut == 4) return outputData;
                outputData = outputData >= 242.0f ? (float)Math.max(660 - (int)(outputData * 2.0f), 0) : (float)Math.min(418 - (int)outputData, 255);
                if (calTypeOut != 5) return outputData;
                return outputData;
            }
            case 2: {
                return inputPixel;
            }
            case 3: {
                return inputPixel;
            }
            case 4: {
                return inputPixel;
            }
            case 5: {
                return inputPixel;
            }
        }
        return outputData;
    }

    @Override
    public int[] calibratedList(int band, boolean isPreCal) {
        int[] cList = isPreCal ? (band == 1 || band == 12 ? new int[]{1, 5} : new int[]{1, 4, 5}) : (band == 1 || band == 12 ? new int[]{1, 3, 5} : new int[]{1, 4, 2, 5});
        return cList;
    }

    @Override
    public String calibratedUnit(int calType) {
        String unitStr = null;
        switch (calType) {
            case 1: {
                unitStr = null;
                break;
            }
            case 2: {
                unitStr = "mW/m^2/sr/cm-1";
                break;
            }
            case 3: {
                unitStr = "%";
                break;
            }
            case 4: {
                unitStr = "K";
                break;
            }
            case 5: {
                unitStr = null;
            }
        }
        return unitStr;
    }

    @Override
    public float convertBritToTemp(int inVal) {
        int con1 = 418;
        int con2 = 660;
        int ilim = 176;
        float outVal = inVal > ilim ? (float)(con1 - inVal) : (float)((con2 - inVal) / 2);
        return outVal;
    }

    @Override
    public float[] convertBritToTemp(float[] inputData) {
        float[] outputData = new float[inputData.length];
        for (int i = 0; i < inputData.length; ++i) {
            outputData[i] = this.convertBritToTemp((int)inputData[i]);
        }
        return outputData;
    }

    @Override
    public boolean getIsPreCalibrated() {
        return this.isPreCalibrated;
    }

    @Override
    public void setIsPreCalibrated(boolean isPrecalibrated) {
        this.isPreCalibrated = isPrecalibrated;
    }
}

