/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Conversions {
    public static final char LB = '{';
    public static final char RB = '}';
    public static final char SEP = ',';
    static final Pattern pattern = Pattern.compile("(\\w+)\\s*(\\(([0-9\\s,]+)\\))?");
    private static Map<Class, Converter> conv = new HashMap<Class, Converter>(){
        {
            this.put(Double.TYPE, new Converter<Double>(){

                @Override
                public Double convert(String s) {
                    return Double.parseDouble(s);
                }
            });
            this.put(Double.class, this.get(Double.TYPE));
            this.put(Float.TYPE, new Converter<Float>(){

                @Override
                public Float convert(String s) {
                    return Float.valueOf(Float.parseFloat(s));
                }
            });
            this.put(Float.class, this.get(Float.TYPE));
            this.put(Long.TYPE, new Converter<Long>(){

                @Override
                public Long convert(String s) {
                    return Long.parseLong(s);
                }
            });
            this.put(Long.class, this.get(Long.TYPE));
            this.put(Integer.TYPE, new Converter<Integer>(){

                @Override
                public Integer convert(String s) {
                    return Integer.parseInt(s);
                }
            });
            this.put(Integer.class, this.get(Integer.TYPE));
            this.put(Short.TYPE, new Converter<Short>(){

                @Override
                public Short convert(String s) {
                    return Short.parseShort(s);
                }
            });
            this.put(Short.class, this.get(Short.TYPE));
            this.put(Byte.TYPE, new Converter<Byte>(){

                @Override
                public Byte convert(String s) {
                    return Byte.parseByte(s);
                }
            });
            this.put(Byte.class, this.get(Byte.TYPE));
            this.put(Boolean.TYPE, new Converter<Boolean>(){

                @Override
                public Boolean convert(String s) {
                    return Boolean.parseBoolean(s);
                }
            });
            this.put(Boolean.class, this.get(Boolean.TYPE));
            this.put(String.class, new Converter<String>(){

                @Override
                public String convert(String s) {
                    return s;
                }
            });
            this.put(Character.TYPE, new Converter<Character>(){

                @Override
                public Character convert(String s) {
                    return Character.valueOf(s.charAt(0));
                }
            });
            this.put(Character.class, this.get(Character.TYPE));
        }
    };

    public static boolean canConvert(Class type) {
        type = Conversions.getArrayBaseType(type);
        return conv.keySet().contains(type);
    }

    public static String[] parseArrayElement(String src) {
        Matcher matcher = pattern.matcher(src.trim());
        String[] c = null;
        if (matcher.find()) {
            if (matcher.group(3) != null) {
                String[] s = matcher.group(3).split(",\\s*");
                c = new String[s.length + 1];
                System.arraycopy(s, 0, c, 1, s.length);
            } else {
                c = new String[]{matcher.group(1)};
            }
        }
        return c;
    }

    public static void main(String[] args) throws ParseException {
        String[] t;
        String content = "{{   333.345, 12.23},  {444.1, 222.4},{1.2, 3.4}}";
        String content3 = "{{   333.345, 12.23, 444.1},{ 222.4 , 1.2, 3.4}}";
        String content1 = "{333.345, 12.23, 444.1, 222.4,1.2, 3.4}";
        String content2 = "{{{333.345, 12.23},{444.1, 222.4},{1.2, 3.4}}}";
        String c = "t1_est(1  ,2) ; basin; abc(1)";
        for (String string : t = c.split("\\s*;\\s*")) {
            System.out.println("string '" + string + "'");
        }
    }

    public static Object parse(String str, Class type) {
        if (type.isArray()) {
            return new ArrayConverter(str).getArrayForType(type);
        }
        return conv.get(type).convert(str);
    }

    public static Class getArrayBaseType(Class array) {
        while (array.isArray()) {
            array = array.getComponentType();
        }
        return array;
    }

    private static interface Converter<T> {
        public T convert(String var1);
    }

    static class ArrayConverter {
        String[] content;
        String layout;
        static final boolean debug = false;
        int[] dims = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

        ArrayConverter(String text) {
            if (text.replaceAll("[^\\}]", "").length() != text.replaceAll("[^\\{]", "").length()) {
                throw new IllegalArgumentException("Brackets mismatch.");
            }
            this.content = text.replace('{', ' ').replace('}', ' ').split(Character.toString(','));
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = this.content[i].trim();
                text = text.replace(this.content[i], Integer.toString(i));
            }
            this.layout = text.replaceAll("\\s", "");
            this.parseDims(this.layout);
        }

        private Class[] types(int[] dims, Class basetype) {
            int i = 0;
            while (dims[i] > 0) {
                ++i;
            }
            Class[] c = new Class[i];
            c[i - 1] = basetype;
            while (--i > 0) {
                c[i - 1] = Array.newInstance(c[i], 0).getClass();
            }
            return c;
        }

        private void parseDims(String layout) {
            int level = -1;
            block5: for (int i = 0; i < layout.length(); ++i) {
                char c = layout.charAt(i);
                switch (c) {
                    case '{': {
                        if (level == this.dims.length - 1) {
                            throw new UnsupportedOperationException("Can only handle arrays with length " + this.dims.length);
                        }
                        this.dims[++level] = 0;
                        continue block5;
                    }
                    case '}': {
                        int n = level--;
                        this.dims[n] = this.dims[n] + 1;
                        continue block5;
                    }
                    case ',': {
                        int n = level;
                        this.dims[n] = this.dims[n] + 1;
                    }
                }
            }
        }

        Object getArrayCompType(Class type) {
            if (type.isArray()) {
                throw new IllegalArgumentException("Non array typp expected.");
            }
            if (!Conversions.canConvert(type)) {
                throw new IllegalArgumentException("Cannot convert to " + type);
            }
            return new Parser((Converter)conv.get(type)).parse(0, this.layout, this.types(this.dims, type));
        }

        Object getArrayForType(Class type) {
            if (!type.isArray()) {
                throw new IllegalArgumentException("Not an array type");
            }
            Class cType = Conversions.getArrayBaseType(type);
            if (!Conversions.canConvert(cType)) {
                throw new IllegalArgumentException("Cannot convert to " + cType);
            }
            Object o = new Parser((Converter)conv.get(cType)).parse(0, this.layout, this.types(this.dims, cType));
            if (o.getClass() != type) {
                throw new RuntimeException(o.getClass() + "!=" + type);
            }
            return o;
        }

        private class Parser {
            int idx = 1;
            Converter converter;

            Parser(Converter converter) {
                this.converter = converter;
            }

            Object parse(int level, String layout, Class[] cc) {
                int arridx = 0;
                Object arr = Array.newInstance(cc[level], ArrayConverter.this.dims[level]);
                while (this.idx < layout.length()) {
                    char c = layout.charAt(this.idx);
                    switch (c) {
                        case '{': {
                            ++this.idx;
                            Object elem = this.parse(level + 1, layout, cc);
                            System.out.flush();
                            Array.set(arr, arridx, elem);
                            break;
                        }
                        case '}': {
                            return arr;
                        }
                        case ',': {
                            ++arridx;
                            break;
                        }
                        default: {
                            int index = 0;
                            while (Character.isDigit(layout.charAt(this.idx))) {
                                index = index * 10 + (layout.charAt(this.idx++) - 48);
                            }
                            --this.idx;
                            Object o = this.converter.convert(ArrayConverter.this.content[index]);
                            Array.set(arr, arridx, o);
                        }
                    }
                    ++this.idx;
                }
                return arr;
            }
        }
    }
}

