/*
 * Decompiled with CFR 0.152.
 */
package ngmf.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import ngmf.io.CSTable;

public class MemoryTable
implements CSTable,
TableModel {
    String name;
    Map<Integer, Map<String, String>> info = new HashMap<Integer, Map<String, String>>();
    List<String[]> rows = new ArrayList<String[]>();
    List<String> columnNames = new ArrayList<String>();

    public MemoryTable(CSTable src, boolean skipContent) {
        this.name = src.getName();
        this.info.put(-1, new LinkedHashMap<String, String>(src.getInfo()));
        for (int i = 0; i < src.getColumnCount(); ++i) {
            this.columnNames.add(src.getName(i));
            this.info.put(i, new LinkedHashMap<String, String>(src.getInfo(i)));
        }
        if (skipContent) {
            return;
        }
        for (String[] row : src) {
            this.rows.add(row);
        }
    }

    public MemoryTable(CSTable src) {
        this(src, false);
    }

    public MemoryTable() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getInfo() {
        return this.getInfo(-1);
    }

    @Override
    public Map<String, String> getInfo(int column) {
        return this.info.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getName(int column) {
        return this.columnNames.get(column);
    }

    @Override
    public Iterator<String[]> iterator() {
        return this.rows.iterator();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex)[columnIndex];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.rows.get((int)rowIndex)[columnIndex] = (String)aValue;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addRow(String[] row) {
        this.rows.add(row);
    }

    public void addRows(List<String[]> r) {
        this.rows.addAll(r);
    }

    public void clearRows() {
        this.rows.clear();
    }

    public List<String[]> getRows(int from, int to) {
        return this.rows.subList(from, to + 1);
    }

    public List<String[]> getRows() {
        return this.rows;
    }
}

