/*
 * Decompiled with CFR 0.152.
 */
package ngmf.ds;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import ngmf.Compound;
import ngmf.ds.TreeNode;

public class Tree {
    Map<Compound, TreeNode> content = new HashMap<Compound, TreeNode>();
    Compound root;

    public Tree(Compound root) {
        this.content.put(root, new TreeNode(null));
        this.root = root;
    }

    private TreeNode node(Compound c) {
        TreeNode t = this.content.get(c);
        if (t == null) {
            throw new IllegalArgumentException("Not in tree " + c);
        }
        return t;
    }

    public List<Compound> children(Compound c) {
        return this.node((Compound)c).children;
    }

    public Compound parent(Compound c) {
        return this.node((Compound)c).parent;
    }

    public Iterator<Compound> toRootOrder(final Compound c) {
        return new Iterator<Compound>(){
            Compound curr;
            TreeNode n;
            Compound parent;
            {
                this.n = Tree.this.node(c);
                this.parent = c;
            }

            @Override
            public boolean hasNext() {
                return !this.n.isRoot();
            }

            @Override
            public Compound next() {
                if (this.hasNext()) {
                    this.curr = this.parent;
                    this.parent = this.n.parent;
                    this.n = Tree.this.node(this.n.parent);
                    return this.curr;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void add(Compound parent, Compound child) {
        TreeNode parentNode = this.content.get(parent);
        if (parentNode == null) {
            throw new IllegalArgumentException("no parent");
        }
        TreeNode c = this.content.get(child);
        if (c != null) {
            throw new IllegalArgumentException("child already in.");
        }
        this.content.put(child, new TreeNode(parent));
        parentNode.children.add(child);
    }

    public Compound getRoot() {
        return this.root;
    }

    public Collection<Compound> content() {
        return this.content.keySet();
    }
}

