/*
 * Decompiled with CFR 0.152.
 */
package ngmf;

import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import ngmf.ComponentAccess;
import ngmf.Controller;
import ngmf.FieldAccess;

public class Notification {
    private EventListenerList ll = new EventListenerList();
    private Controller c;
    private boolean shouldFire = false;

    Notification(Controller c) {
        this.c = c;
    }

    void addListener(Listener l) {
        this.ll.add(Listener.class, l);
        this.shouldFire = true;
    }

    void removeListener(Listener l) {
        this.ll.remove(Listener.class, l);
        this.shouldFire = this.ll.getListenerCount() > 0;
    }

    private void fire(Event E) throws InterruptedException {
        Object[] listeners = this.ll.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((Listener)listeners[i + 1]).notifyExec(E);
        }
    }

    void fireWait(ComponentAccess w) throws InterruptedException {
        if (this.shouldFire) {
            this.fire(new Event(this.c, Type.WAIT, w.getComponent(), null, null, null));
        }
    }

    void fireNotify(ComponentAccess w) throws InterruptedException {
        if (this.shouldFire) {
            this.fire(new Event(this.c, Type.NOTIFY, w.getComponent(), null, null, null));
        }
    }

    void fireStart(ComponentAccess w) throws InterruptedException {
        if (this.shouldFire) {
            this.fire(new Event(this.c, Type.EXEC_START, w.getComponent(), null, null, null));
        }
    }

    void fireFinnish(ComponentAccess w) throws InterruptedException {
        if (this.shouldFire) {
            this.fire(new Event(this.c, Type.EXEC_DONE, w.getComponent(), null, null, null));
        }
    }

    void fireIn(FieldAccess data, Object value) throws InterruptedException {
        if (this.shouldFire) {
            this.fire(new Event(this.c, Type.IN, data.getCommand(), data, value, null));
        }
    }

    void fireOut(FieldAccess data, Object value) throws InterruptedException {
        if (this.shouldFire) {
            this.fire(new Event(this.c, Type.OUT, data.getCommand(), data, value, null));
        }
    }

    void fireException(Throwable ex, ComponentAccess w) throws InterruptedException {
        if (this.shouldFire) {
            this.fire(new Event(this.c, Type.EXCEPTION, w.getComponent(), null, null, ex));
        }
    }

    public static class Event
    extends EventObject {
        private Type type;
        private Object cmd;
        private FieldAccess data;
        private Object value;
        private Throwable ex;

        Event(Controller source, Type type, Object cmd, FieldAccess data, Object value, Throwable ex) {
            super(source);
            this.cmd = cmd;
            this.data = data;
            this.type = type;
            this.value = value;
            this.ex = ex;
        }

        public Throwable getException() {
            return this.ex;
        }

        public Object getComponent() {
            return this.cmd;
        }

        public FieldAccess getAccess() {
            return this.data;
        }

        public Type getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static interface Listener
    extends EventListener {
        public void notifyExec(Event var1) throws InterruptedException;
    }

    public static enum Type {
        EXEC_START,
        EXEC_DONE,
        IN,
        OUT,
        EXCEPTION,
        WAIT,
        NOTIFY;

    }
}

