/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.wms;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

public class SimpleNamespaceContext
implements NamespaceContext {
    private Map<String, String> urisByPrefix = new HashMap<String, String>();
    private Map<String, Set<String>> prefixesByURI = new HashMap<String, Set<String>>();

    public SimpleNamespaceContext() {
        this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.addNamespace("xmlns", "http://www.w3.org/2000/xmlns/");
        this.addNamespace("xlink", "http://www.w3.org/1999/xlink");
        this.addNamespace("wms", "http://www.opengis.net/wms");
        this.addNamespace("", "http://www.opengis.net/wms");
    }

    public synchronized void addNamespace(String string, String string2) {
        this.urisByPrefix.put(string, string2);
        if (this.prefixesByURI.containsKey(string2)) {
            this.prefixesByURI.get(string2).add(string);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            this.prefixesByURI.put(string2, hashSet);
        }
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        if (this.urisByPrefix.containsKey(string)) {
            return this.urisByPrefix.get(string);
        }
        return "";
    }

    public String getPrefix(String string) {
        return (String)this.getPrefixes(string).next();
    }

    public Iterator getPrefixes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("namespaceURI cannot be null");
        }
        if (this.prefixesByURI.containsKey(string)) {
            return this.prefixesByURI.get(string).iterator();
        }
        return Collections.EMPTY_SET.iterator();
    }
}

