/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.BasicOrbitViewAnimator;
import gov.nasa.worldwind.view.BasicOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.OrbitViewAnimator;
import gov.nasa.worldwind.view.OrbitViewPropertyAccessor;
import gov.nasa.worldwind.view.ScheduledOrbitViewInterpolator;

public class ScheduledOrbitViewStateIterator
extends BasicOrbitViewStateIterator {
    private final int maxSmoothing;

    protected ScheduledOrbitViewStateIterator(long l, OrbitViewAnimator orbitViewAnimator, boolean bl) {
        this(new ScheduledOrbitViewInterpolator(l), orbitViewAnimator, bl);
    }

    protected ScheduledOrbitViewStateIterator(ScheduledOrbitViewInterpolator scheduledOrbitViewInterpolator, OrbitViewAnimator orbitViewAnimator, boolean bl) {
        super(false, scheduledOrbitViewInterpolator, orbitViewAnimator);
        if (scheduledOrbitViewInterpolator == null) {
            String string = Logging.getMessage("nullValue.OrbitViewInterpolatorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewAnimator == null) {
            String string = Logging.getMessage("nullValue.OrbitViewAnimatorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maxSmoothing = ScheduledOrbitViewStateIterator.maxSmoothingFromFlag(bl);
    }

    public final boolean isSmoothing() {
        return this.maxSmoothing != 0;
    }

    public void doNextState(double d, OrbitView orbitView) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.OrbitViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = ScheduledOrbitViewStateIterator.interpolantSmoothed(d, this.maxSmoothing);
        super.doNextState(d2, orbitView);
    }

    private static double interpolantSmoothed(double d, int n) {
        double d2 = d;
        for (int i = 0; i < n; ++i) {
            d2 = d2 * d2 * (3.0 - 2.0 * d2);
        }
        return d2;
    }

    private static int maxSmoothingFromFlag(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    public static ScheduledOrbitViewStateIterator createCenterIterator(Position position, Position position2) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        return ScheduledOrbitViewStateIterator.createCenterIterator(position, position2, 4000L, bl);
    }

    public static ScheduledOrbitViewStateIterator createCenterIterator(Position position, Position position2, long l, boolean bl) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewPropertyAccessor.PositionAccessor positionAccessor = OrbitViewPropertyAccessor.createCenterPositionAccessor();
        BasicOrbitViewAnimator.PositionAnimator positionAnimator = new BasicOrbitViewAnimator.PositionAnimator(position, position2, positionAccessor);
        return new ScheduledOrbitViewStateIterator(l, (OrbitViewAnimator)positionAnimator, bl);
    }

    public static ScheduledOrbitViewStateIterator createHeadingIterator(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = ScheduledOrbitViewStateIterator.getScaledLengthMillis(angle, angle2, Angle.POS180, 500L, 3000L);
        boolean bl = true;
        return ScheduledOrbitViewStateIterator.createHeadingIterator(angle, angle2, l, bl);
    }

    public static ScheduledOrbitViewStateIterator createHeadingIterator(Angle angle, Angle angle2, long l, boolean bl) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor = OrbitViewPropertyAccessor.createHeadingAccessor();
        BasicOrbitViewAnimator.AngleAnimator angleAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle, angle2, angleAccessor);
        return new ScheduledOrbitViewStateIterator(l, (OrbitViewAnimator)angleAnimator, bl);
    }

    public static ScheduledOrbitViewStateIterator createPitchIterator(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = ScheduledOrbitViewStateIterator.getScaledLengthMillis(angle, angle2, Angle.POS90, 500L, 1500L);
        boolean bl = true;
        return ScheduledOrbitViewStateIterator.createPitchIterator(angle, angle2, l, bl);
    }

    public static ScheduledOrbitViewStateIterator createPitchIterator(Angle angle, Angle angle2, long l, boolean bl) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor = OrbitViewPropertyAccessor.createPitchAccessor();
        BasicOrbitViewAnimator.AngleAnimator angleAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle, angle2, angleAccessor);
        return new ScheduledOrbitViewStateIterator(l, (OrbitViewAnimator)angleAnimator, bl);
    }

    public static ScheduledOrbitViewStateIterator createZoomIterator(double d, double d2) {
        boolean bl = true;
        return ScheduledOrbitViewStateIterator.createZoomIterator(d, d2, 4000L, bl);
    }

    public static ScheduledOrbitViewStateIterator createZoomIterator(double d, double d2, long l, boolean bl) {
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewPropertyAccessor.DoubleAccessor doubleAccessor = OrbitViewPropertyAccessor.createZoomAccessor();
        BasicOrbitViewAnimator.DoubleAnimator doubleAnimator = new BasicOrbitViewAnimator.DoubleAnimator(d, d2, doubleAccessor);
        return new ScheduledOrbitViewStateIterator(l, (OrbitViewAnimator)doubleAnimator, bl);
    }

    public static ScheduledOrbitViewStateIterator createCenterHeadingPitchIterator(Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, long l, boolean bl) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewPropertyAccessor.PositionAccessor positionAccessor = OrbitViewPropertyAccessor.createCenterPositionAccessor();
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor = OrbitViewPropertyAccessor.createHeadingAccessor();
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor2 = OrbitViewPropertyAccessor.createPitchAccessor();
        BasicOrbitViewAnimator.PositionAnimator positionAnimator = new BasicOrbitViewAnimator.PositionAnimator(position, position2, positionAccessor);
        BasicOrbitViewAnimator.AngleAnimator angleAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle, angle2, angleAccessor);
        BasicOrbitViewAnimator.AngleAnimator angleAnimator2 = new BasicOrbitViewAnimator.AngleAnimator(angle3, angle4, angleAccessor2);
        BasicOrbitViewAnimator.CompoundAnimator compoundAnimator = new BasicOrbitViewAnimator.CompoundAnimator(positionAnimator, angleAnimator, angleAnimator2);
        return new ScheduledOrbitViewStateIterator(l, (OrbitViewAnimator)compoundAnimator, bl);
    }

    public static ScheduledOrbitViewStateIterator createCenterZoomIterator(Position position, Position position2, double d, double d2, long l, boolean bl) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewPropertyAccessor.PositionAccessor positionAccessor = OrbitViewPropertyAccessor.createCenterPositionAccessor();
        OrbitViewPropertyAccessor.DoubleAccessor doubleAccessor = OrbitViewPropertyAccessor.createZoomAccessor();
        BasicOrbitViewAnimator.PositionAnimator positionAnimator = new BasicOrbitViewAnimator.PositionAnimator(position, position2, positionAccessor);
        BasicOrbitViewAnimator.DoubleAnimator doubleAnimator = new BasicOrbitViewAnimator.DoubleAnimator(d, d2, doubleAccessor);
        BasicOrbitViewAnimator.CompoundAnimator compoundAnimator = new BasicOrbitViewAnimator.CompoundAnimator(positionAnimator, doubleAnimator);
        return new ScheduledOrbitViewStateIterator(l, (OrbitViewAnimator)compoundAnimator, bl);
    }

    public static ScheduledOrbitViewStateIterator createCenterHeadingPitchZoomIterator(Position position, Position position2, Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l, boolean bl) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewPropertyAccessor.PositionAccessor positionAccessor = OrbitViewPropertyAccessor.createCenterPositionAccessor();
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor = OrbitViewPropertyAccessor.createHeadingAccessor();
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor2 = OrbitViewPropertyAccessor.createPitchAccessor();
        OrbitViewPropertyAccessor.DoubleAccessor doubleAccessor = OrbitViewPropertyAccessor.createZoomAccessor();
        BasicOrbitViewAnimator.PositionAnimator positionAnimator = new BasicOrbitViewAnimator.PositionAnimator(position, position2, positionAccessor);
        BasicOrbitViewAnimator.AngleAnimator angleAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle, angle2, angleAccessor);
        BasicOrbitViewAnimator.AngleAnimator angleAnimator2 = new BasicOrbitViewAnimator.AngleAnimator(angle3, angle4, angleAccessor2);
        BasicOrbitViewAnimator.DoubleAnimator doubleAnimator = new BasicOrbitViewAnimator.DoubleAnimator(d, d2, doubleAccessor);
        BasicOrbitViewAnimator.CompoundAnimator compoundAnimator = new BasicOrbitViewAnimator.CompoundAnimator(positionAnimator, angleAnimator, angleAnimator2, doubleAnimator);
        return new ScheduledOrbitViewStateIterator(l, (OrbitViewAnimator)compoundAnimator, bl);
    }

    public static ScheduledOrbitViewStateIterator createHeadingPitchIterator(Angle angle, Angle angle2, Angle angle3, Angle angle4) {
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = ScheduledOrbitViewStateIterator.getScaledLengthMillis(angle, angle2, Angle.POS180, 500L, 3000L);
        long l2 = ScheduledOrbitViewStateIterator.getScaledLengthMillis(angle3, angle4, Angle.POS90, 500L, 1500L);
        long l3 = l + l2;
        boolean bl = true;
        return ScheduledOrbitViewStateIterator.createHeadingPitchIterator(angle, angle2, angle3, angle4, l3, bl);
    }

    public static ScheduledOrbitViewStateIterator createHeadingPitchIterator(Angle angle, Angle angle2, Angle angle3, Angle angle4, long l, boolean bl) {
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor = OrbitViewPropertyAccessor.createHeadingAccessor();
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor2 = OrbitViewPropertyAccessor.createPitchAccessor();
        BasicOrbitViewAnimator.AngleAnimator angleAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle, angle2, angleAccessor);
        BasicOrbitViewAnimator.AngleAnimator angleAnimator2 = new BasicOrbitViewAnimator.AngleAnimator(angle3, angle4, angleAccessor2);
        BasicOrbitViewAnimator.CompoundAnimator compoundAnimator = new BasicOrbitViewAnimator.CompoundAnimator(angleAnimator, angleAnimator2);
        return new ScheduledOrbitViewStateIterator(l, (OrbitViewAnimator)compoundAnimator, bl);
    }

    public static ScheduledOrbitViewStateIterator createHeadingPitchZoomIterator(Angle angle, Angle angle2, Angle angle3, Angle angle4, double d, double d2, long l, boolean bl) {
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor = OrbitViewPropertyAccessor.createHeadingAccessor();
        OrbitViewPropertyAccessor.AngleAccessor angleAccessor2 = OrbitViewPropertyAccessor.createPitchAccessor();
        OrbitViewPropertyAccessor.DoubleAccessor doubleAccessor = OrbitViewPropertyAccessor.createZoomAccessor();
        BasicOrbitViewAnimator.AngleAnimator angleAnimator = new BasicOrbitViewAnimator.AngleAnimator(angle, angle2, angleAccessor);
        BasicOrbitViewAnimator.AngleAnimator angleAnimator2 = new BasicOrbitViewAnimator.AngleAnimator(angle3, angle4, angleAccessor2);
        BasicOrbitViewAnimator.DoubleAnimator doubleAnimator = new BasicOrbitViewAnimator.DoubleAnimator(d, d2, doubleAccessor);
        BasicOrbitViewAnimator.CompoundAnimator compoundAnimator = new BasicOrbitViewAnimator.CompoundAnimator(angleAnimator, angleAnimator2, doubleAnimator);
        return new ScheduledOrbitViewStateIterator(l, (OrbitViewAnimator)compoundAnimator, bl);
    }

    private static long getScaledLengthMillis(Angle angle, Angle angle2, Angle angle3, long l, long l2) {
        Angle angle4 = angle.angularDistanceTo(angle2);
        double d = ScheduledOrbitViewStateIterator.angularRatio(angle4, angle3);
        return (long)ScheduledOrbitViewStateIterator.mixDouble(d, l, l2);
    }

    private static double angularRatio(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.divide(angle2);
        return ScheduledOrbitViewStateIterator.clampDouble(d, 0.0, 1.0);
    }

    private static double clampDouble(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    private static double mixDouble(double d, double d2, double d3) {
        if (d < 0.0) {
            return d2;
        }
        if (d > 1.0) {
            return d3;
        }
        return d2 * (1.0 - d) + d3 * d;
    }
}

