/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.BasicOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.OrbitViewAnimator;
import gov.nasa.worldwind.view.OrbitViewPropertyAccessor;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public class BasicOrbitViewAnimator
implements OrbitViewAnimator {
    private boolean stopOnInvalidState = false;
    private boolean lastStateValid = true;

    protected BasicOrbitViewAnimator() {
    }

    public final void doNextState(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.OrbitViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (basicOrbitViewStateIterator == null) {
            String string = Logging.getMessage("nullValue.OrbitViewStateIteratorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doNextStateImpl(d, orbitView, basicOrbitViewStateIterator);
        if (this.isStopOnInvalidState() && !this.isLastStateValid()) {
            basicOrbitViewStateIterator.stop();
        }
    }

    protected void doNextStateImpl(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
    }

    public final OrbitViewAnimator coalesceWith(OrbitView orbitView, OrbitViewAnimator orbitViewAnimator) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.OrbitViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewAnimator == null) {
            String string = Logging.getMessage("nullValue.OrbitViewAnimatorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrbitViewAnimator orbitViewAnimator2 = this.coalesceWithImpl(orbitView, orbitViewAnimator);
        if (this.isStopOnInvalidState() || orbitViewAnimator.isStopOnInvalidState()) {
            orbitViewAnimator2.setStopOnInvalidState(true);
        }
        return orbitViewAnimator2;
    }

    protected OrbitViewAnimator coalesceWithImpl(OrbitView orbitView, OrbitViewAnimator orbitViewAnimator) {
        return this;
    }

    public void setStopOnInvalidState(boolean bl) {
        this.stopOnInvalidState = bl;
    }

    public boolean isStopOnInvalidState() {
        return this.stopOnInvalidState;
    }

    protected void flagLastStateInvalid() {
        this.lastStateValid = false;
    }

    protected boolean isLastStateValid() {
        return this.lastStateValid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompoundAnimator
    extends BasicOrbitViewAnimator {
        private OrbitViewAnimator[] animators;

        public CompoundAnimator(OrbitViewAnimator ... orbitViewAnimatorArray) {
            if (orbitViewAnimatorArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            int n = orbitViewAnimatorArray.length;
            this.animators = new OrbitViewAnimator[n];
            System.arraycopy(orbitViewAnimatorArray, 0, this.animators, 0, n);
        }

        private CompoundAnimator newInstance(OrbitViewAnimator ... orbitViewAnimatorArray) {
            CompoundAnimator compoundAnimator;
            if (orbitViewAnimatorArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            try {
                Class<?> clazz = this.getClass();
                Class<?> clazz2 = orbitViewAnimatorArray.getClass();
                Constructor<?> constructor = clazz.getConstructor(clazz2);
                compoundAnimator = (CompoundAnimator)constructor.newInstance(new Object[]{orbitViewAnimatorArray});
            }
            catch (Exception exception) {
                String string = Logging.getMessage("");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return compoundAnimator;
        }

        public final Iterable<OrbitViewAnimator> getAnimators() {
            return Arrays.asList(this.animators);
        }

        @Override
        protected final void doNextStateImpl(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            for (OrbitViewAnimator orbitViewAnimator : this.animators) {
                if (orbitViewAnimator == null) continue;
                orbitViewAnimator.doNextState(d, orbitView, basicOrbitViewStateIterator);
            }
        }

        @Override
        protected final OrbitViewAnimator coalesceWithImpl(OrbitView orbitView, OrbitViewAnimator orbitViewAnimator) {
            if (!(orbitViewAnimator instanceof CompoundAnimator)) {
                return this;
            }
            CompoundAnimator compoundAnimator = (CompoundAnimator)orbitViewAnimator;
            if (this.animators.length != compoundAnimator.animators.length) {
                return this;
            }
            int n = this.animators.length;
            OrbitViewAnimator[] orbitViewAnimatorArray = new OrbitViewAnimator[n];
            for (int i = 0; i < n; ++i) {
                if (this.animators[i] != null && compoundAnimator.animators[i] != null) {
                    orbitViewAnimatorArray[i] = this.animators[i].coalesceWith(orbitView, compoundAnimator.animators[i]);
                    continue;
                }
                if (this.animators[i] == null) continue;
                orbitViewAnimatorArray[i] = this.animators[i];
            }
            CompoundAnimator compoundAnimator2 = this.newInstance(orbitViewAnimatorArray);
            if (compoundAnimator2 == null) {
                return this;
            }
            return compoundAnimator2;
        }

        @Override
        public void setStopOnInvalidState(boolean bl) {
            super.setStopOnInvalidState(bl);
            for (OrbitViewAnimator orbitViewAnimator : this.animators) {
                if (orbitViewAnimator == null) continue;
                orbitViewAnimator.setStopOnInvalidState(bl);
            }
        }
    }

    public static class PositionAnimator
    extends BasicOrbitViewAnimator {
        private final Position begin;
        private final Position end;
        private final OrbitViewPropertyAccessor.PositionAccessor propertyAccessor;

        public PositionAnimator(Position position, Position position2, OrbitViewPropertyAccessor.PositionAccessor positionAccessor) {
            if (position == null || position2 == null) {
                String string = Logging.getMessage("nullValue.PositionIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (positionAccessor == null) {
                String string = Logging.getMessage("nullValue.OrbitViewPropertyAccessorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.begin = position;
            this.end = position2;
            this.propertyAccessor = positionAccessor;
        }

        public final Position getBegin() {
            return this.begin;
        }

        public final Position getEnd() {
            return this.end;
        }

        public final OrbitViewPropertyAccessor.PositionAccessor getPropertyAccessor() {
            return this.propertyAccessor;
        }

        protected final void doNextStateImpl(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            Position position = this.nextPosition(d, orbitView);
            if (position == null) {
                return;
            }
            boolean bl = this.propertyAccessor.setPosition(orbitView, position);
            if (!bl) {
                this.flagLastStateInvalid();
            }
        }

        public Position nextPosition(double d, OrbitView orbitView) {
            return Position.interpolate(d, this.begin, this.end);
        }
    }

    public static class DoubleAnimator
    extends BasicOrbitViewAnimator {
        private final double begin;
        private final double end;
        private final OrbitViewPropertyAccessor.DoubleAccessor propertyAccessor;

        public DoubleAnimator(double d, double d2, OrbitViewPropertyAccessor.DoubleAccessor doubleAccessor) {
            if (doubleAccessor == null) {
                String string = Logging.getMessage("nullValue.OrbitViewPropertyAccessorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.begin = d;
            this.end = d2;
            this.propertyAccessor = doubleAccessor;
        }

        public final Double getBegin() {
            return this.begin;
        }

        public final Double getEnd() {
            return this.end;
        }

        public final OrbitViewPropertyAccessor.DoubleAccessor getPropertyAccessor() {
            return this.propertyAccessor;
        }

        protected final void doNextStateImpl(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            Double d2 = this.nextDouble(d, orbitView);
            if (d2 == null) {
                return;
            }
            boolean bl = this.propertyAccessor.setDouble(orbitView, d2);
            if (!bl) {
                this.flagLastStateInvalid();
            }
        }

        public Double nextDouble(double d, OrbitView orbitView) {
            return DoubleAnimator.mix(d, this.begin, this.end);
        }

        public static double mix(double d, double d2, double d3) {
            if (d < 0.0) {
                return d2;
            }
            if (d > 1.0) {
                return d3;
            }
            return d2 * (1.0 - d) + d3 * d;
        }
    }

    public static class AngleAnimator
    extends BasicOrbitViewAnimator {
        private final Angle begin;
        private final Angle end;
        private final OrbitViewPropertyAccessor.AngleAccessor propertyAccessor;

        public AngleAnimator(Angle angle, Angle angle2, OrbitViewPropertyAccessor.AngleAccessor angleAccessor) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (angleAccessor == null) {
                String string = Logging.getMessage("nullValue.OrbitViewPropertyAccessorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.begin = angle;
            this.end = angle2;
            this.propertyAccessor = angleAccessor;
        }

        public final Angle getBegin() {
            return this.begin;
        }

        public final Angle getEnd() {
            return this.end;
        }

        public final OrbitViewPropertyAccessor.AngleAccessor getPropertyAccessor() {
            return this.propertyAccessor;
        }

        protected final void doNextStateImpl(double d, OrbitView orbitView, BasicOrbitViewStateIterator basicOrbitViewStateIterator) {
            Angle angle = this.nextAngle(d, orbitView);
            if (angle == null) {
                return;
            }
            boolean bl = this.propertyAccessor.setAngle(orbitView, angle);
            if (!bl) {
                this.flagLastStateInvalid();
            }
        }

        public Angle nextAngle(double d, OrbitView orbitView) {
            return Angle.mix(d, this.begin, this.end);
        }
    }
}

