/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.view.AbstractView;
import gov.nasa.worldwind.view.BasicOrbitViewModel;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.OrbitViewCollisionSupport;
import gov.nasa.worldwind.view.OrbitViewModel;
import gov.nasa.worldwind.view.ViewSupport;
import java.awt.Rectangle;

public class BasicOrbitView
extends AbstractView
implements OrbitView {
    private Position center = Position.ZERO;
    private Angle heading = Angle.ZERO;
    private Angle pitch = Angle.ZERO;
    private double zoom;
    private Angle fieldOfView = Angle.fromDegrees(45.0);
    private double nearClipDistance = -1.0;
    private double farClipDistance = -1.0;
    private final OrbitViewModel orbitViewModel;
    private final ViewSupport viewSupport = new ViewSupport();
    private final OrbitViewCollisionSupport collisionSupport = new OrbitViewCollisionSupport();
    private Matrix modelview = Matrix.IDENTITY;
    private Matrix modelviewInv = Matrix.IDENTITY;
    private Matrix projection = Matrix.IDENTITY;
    private Rectangle viewport = new Rectangle();
    private Frustum frustum = new Frustum();
    private DrawContext dc;
    private Globe globe;
    private Position lastEyePosition = null;
    private Vec4 lastEyePoint = null;
    private Vec4 lastUpVector = null;
    private Vec4 lastForwardVector = null;
    private Frustum lastFrustumInModelCoords = null;
    private static final double MINIMUM_NEAR_DISTANCE = 2.0;
    private static final double MINIMUM_FAR_DISTANCE = 100.0;
    private static final double COLLISION_THRESHOLD = 10.0;
    private static final int COLLISION_NUM_ITERATIONS = 4;

    public BasicOrbitView() {
        this(new BasicOrbitViewModel());
    }

    public BasicOrbitView(OrbitViewModel orbitViewModel) {
        if (orbitViewModel == null) {
            String string = Logging.getMessage("nullValue.OrbitViewModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.orbitViewModel = orbitViewModel;
        this.collisionSupport.setCollisionThreshold(10.0);
        this.collisionSupport.setNumIterations(4);
        this.loadConfigurationValues();
    }

    private void loadConfigurationValues() {
        Double d;
        Double d2;
        Double d3;
        Double d4 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLatitude");
        Double d5 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLongitude");
        double d6 = this.center.getElevation();
        if (d4 != null && d5 != null) {
            this.setCenterPosition(Position.fromDegrees(d4, d5, d6));
        } else if (d4 != null) {
            this.setCenterPosition(Position.fromDegrees(d4, this.center.getLongitude().degrees, d6));
        } else if (d5 != null) {
            this.setCenterPosition(Position.fromDegrees(this.center.getLatitude().degrees, d5, d6));
        }
        Double d7 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialHeading");
        if (d7 != null) {
            this.setHeading(Angle.fromDegrees(d7));
        }
        if ((d3 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialPitch")) != null) {
            this.setPitch(Angle.fromDegrees(d3));
        }
        if ((d2 = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialAltitude")) != null) {
            this.setZoom(d2);
        }
        if ((d = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.FieldOfView")) != null) {
            this.setFieldOfView(Angle.fromDegrees(d));
        }
    }

    public Position getCenterPosition() {
        return this.center;
    }

    public void setCenterPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position.getLatitude().degrees < -90.0 || position.getLatitude().degrees > 90.0) {
            String string = Logging.getMessage("generic.LatitudeOutOfRange", position.getLatitude());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = BasicOrbitView.normalizedPosition(position);
        this.resolveCollisionsWithCenterPosition();
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = BasicOrbitView.normalizedHeading(angle);
        this.resolveCollisionsWithPitch();
    }

    public Angle getPitch() {
        return this.pitch;
    }

    public void setPitch(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees > 90.0 || angle.degrees < 0.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", angle);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pitch = angle;
        this.resolveCollisionsWithPitch();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zoom = d;
        this.resolveCollisionsWithCenterPosition();
    }

    public OrbitViewModel getOrbitViewModel() {
        return this.orbitViewModel;
    }

    private static Position normalizedPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Position(Angle.normalizedLatitude(position.getLatitude()), Angle.normalizedLongitude(position.getLongitude()), position.getElevation());
    }

    private static Angle normalizedHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.degrees;
        double d2 = d % 360.0;
        return Angle.fromDegrees(d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : d2));
    }

    private void resolveCollisionsWithCenterPosition() {
        if (this.dc == null) {
            return;
        }
        if (!this.isDetectCollisions()) {
            return;
        }
        double d = this.nearClipDistance > 0.0 ? this.nearClipDistance : this.getAutoNearClipDistance();
        Position position = this.collisionSupport.computeCenterPositionToResolveCollision(this, d, this.dc);
        if (position != null && position.getLatitude().degrees >= -90.0 && position.getLongitude().degrees <= 90.0) {
            this.center = position;
            this.flagHadCollisions();
        }
    }

    private void resolveCollisionsWithPitch() {
        if (this.dc == null) {
            return;
        }
        if (!this.isDetectCollisions()) {
            return;
        }
        double d = this.nearClipDistance > 0.0 ? this.nearClipDistance : this.getAutoNearClipDistance();
        Angle angle = this.collisionSupport.computePitchToResolveCollision(this, d, this.dc);
        if (angle != null && angle.degrees <= 90.0 && angle.degrees >= 0.0) {
            this.pitch = angle;
            this.flagHadCollisions();
        }
    }

    public boolean canFocusOnViewportCenter() {
        return this.dc != null && this.dc.getViewportCenterPosition() != null && this.globe != null;
    }

    public void focusOnViewportCenter() {
        Matrix matrix;
        Matrix matrix2;
        if (this.dc == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Position position = this.dc.getViewportCenterPosition();
        if (position == null) {
            String string = Logging.getMessage("nullValue.DrawingContextViewportCenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Vec4 vec4 = this.globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), this.globe.getElevation(position.getLatitude(), position.getLongitude()) * this.dc.getVerticalExaggeration());
        if (vec4 != null && (matrix2 = this.orbitViewModel.computeTransformMatrix(this.globe, this.center, this.heading, this.pitch, this.zoom)) != null && (matrix = matrix2.getInverse()) != null) {
            Vec4 vec42 = Vec4.UNIT_W.transformBy4(matrix);
            Vec4 vec43 = Vec4.UNIT_NEGATIVE_Z.transformBy4(matrix);
            double d = vec42.distanceTo3(vec4);
            Vec4 vec44 = Vec4.fromLine3(vec42, d, vec43);
            OrbitViewModel.ModelCoordinates modelCoordinates = this.orbitViewModel.computeModelCoordinates(this.globe, matrix2, vec44);
            if (this.validateModelCoordinates(modelCoordinates)) {
                this.setModelCoordinates(modelCoordinates);
            }
        }
    }

    public void stopMovementOnCenter() {
        this.firePropertyChange("gov.nasa.worldwind.view.OrbitView.CenterStopped", null, null);
    }

    public Position getEyePosition() {
        if (this.lastEyePosition == null) {
            this.lastEyePosition = this.computeEyePositionFromModelview();
        }
        return this.lastEyePosition;
    }

    public void setEyePosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = position.getLatLon();
        double d = position.getElevation();
        this.center = new Position(latLon, d >= 0.0 ? 0.0 : d);
        this.heading = Angle.ZERO;
        this.pitch = Angle.ZERO;
        this.zoom = d >= 0.0 ? d : 0.0;
        this.resolveCollisionsWithCenterPosition();
    }

    public Position getCurrentEyePosition() {
        Matrix matrix;
        Matrix matrix2;
        if (this.globe != null && (matrix2 = this.orbitViewModel.computeTransformMatrix(this.globe, this.center, this.heading, this.pitch, this.zoom)) != null && (matrix = matrix2.getInverse()) != null) {
            Vec4 vec4 = Vec4.UNIT_W.transformBy4(matrix);
            return this.globe.computePositionFromPoint(vec4);
        }
        return Position.ZERO;
    }

    public void setOrientation(Position position, Position position2) {
        Object object;
        Object object2;
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Vec4 vec4 = this.globe.computePointFromPosition(position);
        Vec4 vec42 = this.globe.computePointFromPosition(position2);
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec43 = this.globe.computeSurfaceNormalAtPoint(vec42);
        Vec4 vec44 = vec42.subtract3(vec4).normalize3();
        if (vec44.cross3(vec43).getLength3() < 0.001 && (object2 = this.orbitViewModel.computeTransformMatrix(this.globe, position2, this.heading, Angle.ZERO, 1.0)) != null && (object = ((Matrix)object2).getInverse()) != null) {
            vec43 = Vec4.UNIT_Y.transformBy4((Matrix)object);
        }
        if (vec43 == null) {
            object2 = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe((String)object2);
            throw new IllegalArgumentException((String)object2);
        }
        object2 = this.orbitViewModel.computeModelCoordinates(this.globe, vec4, vec42, vec43);
        if (!this.validateModelCoordinates((OrbitViewModel.ModelCoordinates)object2)) {
            object = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe((String)object);
            throw new IllegalArgumentException((String)object);
        }
        this.setModelCoordinates((OrbitViewModel.ModelCoordinates)object2);
    }

    public Vec4 getEyePoint() {
        if (this.lastEyePoint == null) {
            this.lastEyePoint = Vec4.UNIT_W.transformBy4(this.modelviewInv);
        }
        return this.lastEyePoint;
    }

    public Vec4 getCurrentEyePoint() {
        Matrix matrix;
        Matrix matrix2;
        if (this.globe != null && (matrix2 = this.orbitViewModel.computeTransformMatrix(this.globe, this.center, this.heading, this.pitch, this.zoom)) != null && (matrix = matrix2.getInverse()) != null) {
            return Vec4.UNIT_W.transformBy4(matrix);
        }
        return Vec4.ZERO;
    }

    public Vec4 getUpVector() {
        if (this.lastUpVector == null) {
            this.lastUpVector = Vec4.UNIT_Y.transformBy4(this.modelviewInv);
        }
        return this.lastUpVector;
    }

    public Vec4 getForwardVector() {
        if (this.lastForwardVector == null) {
            this.lastForwardVector = Vec4.UNIT_NEGATIVE_Z.transformBy4(this.modelviewInv);
        }
        return this.lastForwardVector;
    }

    public Matrix getModelviewMatrix() {
        return this.modelview;
    }

    public Angle getFieldOfView() {
        return this.fieldOfView;
    }

    public void setFieldOfView(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.fieldOfView = angle;
    }

    public double getNearClipDistance() {
        return this.nearClipDistance;
    }

    public void setNearClipDistance(double d) {
        this.nearClipDistance = d;
    }

    public double getFarClipDistance() {
        return this.farClipDistance;
    }

    public void setFarClipDistance(double d) {
        this.farClipDistance = d;
    }

    public double getAutoNearClipDistance() {
        Position position = this.getCurrentEyePosition();
        return this.computeNearDistance(position);
    }

    public double getAutoFarClipDistance() {
        Position position = this.getCurrentEyePosition();
        return this.computeFarDistance(position);
    }

    private double computeNearDistance(Position position) {
        double d = 0.0;
        if (position != null && this.dc != null) {
            double d2 = this.viewSupport.computeElevationAboveSurface(this.dc, position);
            double d3 = this.fieldOfView.tanHalfAngle();
            d = d2 / (2.0 * Math.sqrt(2.0 * d3 * d3 + 1.0));
        }
        return d < 2.0 ? 2.0 : d;
    }

    private double computeFarDistance(Position position) {
        double d = 0.0;
        if (position != null) {
            d = this.computeHorizonDistance(position);
        }
        return d < 100.0 ? 100.0 : d;
    }

    public Rectangle getViewport() {
        return new Rectangle(this.viewport);
    }

    public Frustum getFrustum() {
        return this.frustum;
    }

    public Frustum getFrustumInModelCoordinates() {
        if (this.lastFrustumInModelCoords == null) {
            Matrix matrix = this.modelview.getTranspose();
            this.lastFrustumInModelCoords = matrix != null ? this.frustum.transformBy(matrix) : this.frustum;
        }
        return this.lastFrustumInModelCoords;
    }

    public Matrix getProjectionMatrix() {
        return this.projection;
    }

    protected void doApply(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dc = drawContext;
        this.globe = this.dc.getGlobe();
        this.modelview = this.orbitViewModel.computeTransformMatrix(this.globe, this.center, this.heading, this.pitch, this.zoom);
        if (this.modelview == null) {
            this.modelview = Matrix.IDENTITY;
        }
        this.modelviewInv = this.modelview.getInverse();
        if (this.modelviewInv == null) {
            this.modelviewInv = Matrix.IDENTITY;
        }
        int[] nArray = new int[4];
        this.dc.getGL().glGetIntegerv(2978, nArray, 0);
        this.viewport = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        double d = this.nearClipDistance > 0.0 ? this.nearClipDistance : this.getAutoNearClipDistance();
        double d2 = this.farClipDistance > 0.0 ? this.farClipDistance : this.getAutoFarClipDistance();
        this.projection = Matrix.fromPerspective(this.fieldOfView, this.viewport.getWidth(), this.viewport.getHeight(), d, d2);
        this.frustum = Frustum.fromPerspective(this.fieldOfView, (int)this.viewport.getWidth(), (int)this.viewport.getHeight(), d, d2);
        this.viewSupport.loadGLViewState(drawContext, this.modelview, this.projection);
        this.afterDoApply();
    }

    protected void afterDoApply() {
        this.lastEyePosition = null;
        this.lastEyePoint = null;
        this.lastUpVector = null;
        this.lastForwardVector = null;
        this.lastFrustumInModelCoords = null;
    }

    public Vec4 project(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.viewSupport.project(vec4, this.modelview, this.projection, this.viewport);
    }

    public Vec4 unProject(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.viewSupport.unProject(vec4, this.modelview, this.projection, this.viewport);
    }

    public Line computeRayFromScreenPoint(double d, double d2) {
        return this.viewSupport.computeRayFromScreenPoint(d, d2, this.modelview, this.projection, this.viewport);
    }

    public Position computePositionFromScreenPoint(double d, double d2) {
        Line line;
        if (this.globe != null && (line = this.computeRayFromScreenPoint(d, d2)) != null) {
            return this.globe.getIntersectionPosition(line);
        }
        return null;
    }

    public double computePixelSizeAtDistance(double d) {
        return this.viewSupport.computePixelSizeAtDistance(d, this.fieldOfView, this.viewport);
    }

    public double computeHorizonDistance() {
        double d = 0.0;
        Position position = this.computeEyePositionFromModelview();
        if (position != null) {
            d = this.computeHorizonDistance(position);
        }
        return d;
    }

    private double computeHorizonDistance(Position position) {
        if (this.globe != null && position != null) {
            double d = position.getElevation();
            double d2 = this.viewSupport.computeElevationAboveSurface(this.dc, position);
            return this.viewSupport.computeHorizonDistance(this.globe, Math.max(d, d2));
        }
        return 0.0;
    }

    private Position computeEyePositionFromModelview() {
        if (this.globe != null) {
            Vec4 vec4 = Vec4.UNIT_W.transformBy4(this.modelviewInv);
            return this.globe.computePositionFromPoint(vec4);
        }
        return Position.ZERO;
    }

    private void setModelCoordinates(OrbitViewModel.ModelCoordinates modelCoordinates) {
        if (modelCoordinates != null) {
            if (modelCoordinates.getCenterPosition() != null) {
                this.center = BasicOrbitView.normalizedPosition(modelCoordinates.getCenterPosition());
            }
            if (modelCoordinates.getHeading() != null) {
                this.heading = BasicOrbitView.normalizedHeading(modelCoordinates.getHeading());
            }
            if (modelCoordinates.getPitch() != null) {
                this.pitch = modelCoordinates.getPitch();
            }
            this.zoom = modelCoordinates.getZoom();
        }
    }

    private boolean validateModelCoordinates(OrbitViewModel.ModelCoordinates modelCoordinates) {
        return modelCoordinates != null && modelCoordinates.getCenterPosition() != null && modelCoordinates.getCenterPosition().getLatitude().degrees >= -90.0 && modelCoordinates.getCenterPosition().getLatitude().degrees <= 90.0 && modelCoordinates.getHeading() != null && modelCoordinates.getPitch() != null && modelCoordinates.getPitch().degrees >= 0.0 && modelCoordinates.getPitch().degrees <= 90.0 && modelCoordinates.getZoom() >= 0.0;
    }

    public String getRestorableState() {
        RestorableSupport.StateObject stateObject;
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        restorableSupport.addStateValueAsBoolean("detectCollisions", this.isDetectCollisions());
        if (this.fieldOfView != null) {
            restorableSupport.addStateValueAsDouble("fieldOfView", this.fieldOfView.degrees);
        }
        if (this.nearClipDistance > 0.0) {
            restorableSupport.addStateValueAsDouble("nearClipDistance", this.nearClipDistance);
        }
        if (this.farClipDistance > 0.0) {
            restorableSupport.addStateValueAsDouble("farClipDistance", this.farClipDistance);
        }
        if (this.center != null && (stateObject = restorableSupport.addStateObject("center")) != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "latitude", this.center.getLatitude().degrees);
            restorableSupport.addStateValueAsDouble(stateObject, "longitude", this.center.getLongitude().degrees);
            restorableSupport.addStateValueAsDouble(stateObject, "elevation", this.center.getElevation());
        }
        if (this.heading != null) {
            restorableSupport.addStateValueAsDouble("heading", this.heading.degrees);
        }
        if (this.pitch != null) {
            restorableSupport.addStateValueAsDouble("pitch", this.pitch.degrees);
        }
        restorableSupport.addStateValueAsDouble("zoom", this.zoom);
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        Double d;
        RestorableSupport.StateObject stateObject;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        Boolean bl = restorableSupport.getStateValueAsBoolean("detectCollisions");
        if (bl != null) {
            this.setDetectCollisions(bl);
        }
        if ((stateObject = restorableSupport.getStateObject("center")) != null) {
            d = restorableSupport.getStateValueAsDouble(stateObject, "latitude");
            Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "longitude");
            Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "elevation");
            if (d != null && d2 != null) {
                this.setCenterPosition(Position.fromDegrees(d, d2, d3 != null ? d3 : 0.0));
            }
        }
        if ((d = restorableSupport.getStateValueAsDouble("heading")) != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
        if ((d = restorableSupport.getStateValueAsDouble("pitch")) != null) {
            this.setPitch(Angle.fromDegrees(d));
        }
        if ((d = restorableSupport.getStateValueAsDouble("zoom")) != null) {
            this.setZoom(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble("fieldOfView")) != null) {
            this.setFieldOfView(Angle.fromDegrees(d));
        }
        if ((d = restorableSupport.getStateValueAsDouble("nearClipDistance")) != null) {
            this.setNearClipDistance(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble("farClipDistance")) != null) {
            this.setFarClipDistance(d);
        }
    }
}

