/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.wizard;

import gov.nasa.worldwind.util.wizard.WizardPanelDescriptor;
import gov.nasa.worldwind.util.wizard.WizardProperties;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class WizardModel
extends WizardProperties {
    private Map<Object, WizardPanelDescriptor> panels = new HashMap<Object, WizardPanelDescriptor>();
    public static final String CURRENT_PANEL_DESCRIPTOR = "wizard.CurrentPanelDescriptor";
    public static final String BACK_BUTTON_TEXT = "wizard.BackButtonText";
    public static final String NEXT_BUTTON_TEXT = "wizard.NextButtonText";
    public static final String CANCEL_BUTTON_TEXT = "wizard.CancelButtonText";
    public static final String BACK_BUTTON_ENABLED = "wizard.BackButtonEnabled";
    public static final String NEXT_BUTTON_ENABLED = "wizard.NextButtonEnabled";
    public static final String CANCEL_BUTTON_ENABLED = "wizard.CancelButtonEnabled";
    public static final String BACK_BUTTON_ICON = "wizard.BackButtonIcon";
    public static final String NEXT_BUTTON_ICON = "wizard.NextButtonIcon";
    public static final String CANCEL_BUTTON_ICON = "wizard.CancelButtonIcon";

    public WizardPanelDescriptor getWizardPanel(Object object) {
        return this.panels.get(object);
    }

    public void registerWizardPanel(Object object, WizardPanelDescriptor wizardPanelDescriptor) {
        if (object != null && wizardPanelDescriptor != null) {
            this.panels.put(object, wizardPanelDescriptor);
        }
    }

    public WizardPanelDescriptor getCurrentPanel() {
        Object object = this.getProperty(CURRENT_PANEL_DESCRIPTOR);
        return object != null && object instanceof WizardPanelDescriptor ? (WizardPanelDescriptor)object : null;
    }

    public boolean setCurrentPanel(Object object) {
        boolean bl = false;
        WizardPanelDescriptor wizardPanelDescriptor = this.panels.get(object);
        if (wizardPanelDescriptor != null) {
            WizardPanelDescriptor wizardPanelDescriptor2 = this.getCurrentPanel();
            if (wizardPanelDescriptor2 != wizardPanelDescriptor) {
                this.setProperty(CURRENT_PANEL_DESCRIPTOR, wizardPanelDescriptor);
                this.firePropertyChange(CURRENT_PANEL_DESCRIPTOR, wizardPanelDescriptor2, wizardPanelDescriptor);
            }
            bl = true;
        }
        return bl;
    }

    public String getBackButtonText() {
        return this.getStringProperty(BACK_BUTTON_TEXT);
    }

    public void setBackButtonText(String string) {
        this.setProperty(BACK_BUTTON_TEXT, string);
    }

    public String getNextButtonText() {
        return this.getStringProperty(NEXT_BUTTON_TEXT);
    }

    public void setNextButtonText(String string) {
        this.setProperty(NEXT_BUTTON_TEXT, string);
    }

    public String getCancelButtonText() {
        return this.getStringProperty(CANCEL_BUTTON_TEXT);
    }

    public void setCancelButtonText(String string) {
        this.setProperty(CANCEL_BUTTON_TEXT, string);
    }

    public Boolean isBackButtonEnabled() {
        return this.getBooleanProperty(BACK_BUTTON_ENABLED);
    }

    public void setBackButtonEnabled(Boolean bl) {
        this.setProperty(BACK_BUTTON_ENABLED, bl);
    }

    public Boolean isNextButtonEnabled() {
        return this.getBooleanProperty(NEXT_BUTTON_ENABLED);
    }

    public void setNextButtonEnabled(Boolean bl) {
        this.setProperty(NEXT_BUTTON_ENABLED, bl);
    }

    public Boolean isCancelButtonEnabled() {
        return this.getBooleanProperty(CANCEL_BUTTON_ENABLED);
    }

    public void setCancelButtonEnabled(Boolean bl) {
        this.setProperty(CANCEL_BUTTON_ENABLED, bl);
    }

    public Icon getBackButtonIcon() {
        return this.getIconProperty(BACK_BUTTON_ICON);
    }

    public void setBackButtonIcon(Icon icon) {
        this.setProperty(BACK_BUTTON_ICON, icon);
    }

    public Icon getNextButtonIcon() {
        return this.getIconProperty(NEXT_BUTTON_ICON);
    }

    public void setNextButtonIcon(Icon icon) {
        this.setProperty(NEXT_BUTTON_ICON, icon);
    }

    public Icon getCancelButtonIcon() {
        return this.getIconProperty(CANCEL_BUTTON_ICON);
    }

    public void setCancelButtonIcon(Icon icon) {
        this.setProperty(CANCEL_BUTTON_ICON, icon);
    }

    public Icon getIconProperty(String string) {
        Object object = this.getProperty(string);
        return object != null && object instanceof Icon ? (Icon)object : null;
    }
}

