/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestorableSupport {
    private static final String DEFAULT_DOCUMENT_ELEMENT_TAG_NAME = "restorableState";
    private static final String DEFAULT_STATE_OBJECT_TAG_NAME = "stateObject";
    private Document doc;
    private XPath xpath;
    private String stateObjectTagName;

    private RestorableSupport(Document document) {
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doc = document;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        this.xpath = xPathFactory.newXPath();
        this.stateObjectTagName = DEFAULT_STATE_OBJECT_TAG_NAME;
    }

    public static RestorableSupport newRestorableSupport() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            RestorableSupport.createDocumentElement(document, DEFAULT_DOCUMENT_ELEMENT_TAG_NAME);
            return new RestorableSupport(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = Logging.getMessage("RestorableSupport.ExceptionCreatingParser");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, parserConfigurationException);
        }
    }

    public static RestorableSupport parse(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            return new RestorableSupport(document);
        }
        catch (IOException iOException) {
            String string3 = Logging.getMessage("RestorableSupport.ExceptionParsingXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, iOException);
        }
        catch (SAXException sAXException) {
            String string4 = Logging.getMessage("RestorableSupport.ExceptionParsingXml", string);
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4, sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string5 = Logging.getMessage("RestorableSupport.ExceptionCreatingParser");
            Logging.logger().severe(string5);
            throw new IllegalStateException(string5, parserConfigurationException);
        }
    }

    private Element getDocumentElement() {
        return this.doc.getDocumentElement();
    }

    private static void createDocumentElement(Document document, String string) {
        if (document == null) {
            String string2 = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (document.getDocumentElement() != null) {
            return;
        }
        Element element = document.createElement(string);
        document.appendChild(element);
    }

    public String getStateAsXml() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(this.doc), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string = Logging.getMessage("RestorableSupport.ExceptionWritingXml");
            Logging.logger().severe(string);
            return null;
        }
        catch (TransformerException transformerException) {
            String string = Logging.getMessage("RestorableSupport.ExceptionWritingXml");
            Logging.logger().severe(string);
            return null;
        }
    }

    public String toString() {
        return this.getStateAsXml();
    }

    public String getStateObjectTagName() {
        return this.stateObjectTagName;
    }

    public void setStateObjectTagName(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.stateObjectTagName = string;
    }

    private StateObject findStateObject(Node node, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = String.format("%s[@name=\"%s\"]", this.getStateObjectTagName(), string);
        try {
            Object object = this.xpath.evaluate(string3, node != null ? node : this.getDocumentElement(), XPathConstants.NODE);
            if (object == null) {
                return null;
            }
            return object instanceof Element ? new StateObject((Element)object) : null;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    private StateObject[] findAllStateObjects(Node node, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = string.length() != 0 ? String.format("%s[@name=\"%s\"]", this.getStateObjectTagName(), string) : String.format("%s//.", this.getStateObjectTagName());
        try {
            Object object = this.xpath.evaluate(string3, node != null ? node : this.getDocumentElement(), XPathConstants.NODESET);
            if (object == null || !(object instanceof NodeList) || ((NodeList)object).getLength() == 0) {
                return null;
            }
            NodeList nodeList = (NodeList)object;
            StateObject[] stateObjectArray = new StateObject[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!(node2 instanceof Element)) continue;
                stateObjectArray[i] = new StateObject((Element)node2);
            }
            return stateObjectArray;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    private StateObject[] extractStateObjects(Element element) {
        NodeList nodeList = (element != null ? element : this.getDocumentElement()).getChildNodes();
        StateObject[] stateObjectArray = new StateObject[]{};
        if (nodeList != null) {
            stateObjectArray = new StateObject[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || node.getNodeName() == null || !node.getNodeName().equals(this.getStateObjectTagName())) continue;
                stateObjectArray[i] = new StateObject((Element)node);
            }
        }
        return stateObjectArray;
    }

    private StateObject createStateObject(Element element, String string, String string2) {
        return this.createStateObject(element, string, string2, false);
    }

    private StateObject createStateObject(Element element, String string, String string2, boolean bl) {
        Element element2 = this.doc.createElement(this.getStateObjectTagName());
        if (string != null) {
            element2.setAttribute("name", string);
        }
        if (string2 != null) {
            if (bl) {
                element2.appendChild(this.doc.createCDATASection(string2));
            } else {
                element2.setTextContent(string2);
            }
        }
        (element != null ? element : this.getDocumentElement()).appendChild(element2);
        return new StateObject(element2);
    }

    private boolean containsElement(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.ElementIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return element.getOwnerDocument().equals(this.doc);
    }

    public StateObject getStateObject(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getStateObject(null, string);
    }

    public StateObject getStateObject(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return this.findStateObject(stateObject != null ? stateObject.elem : null, string);
    }

    public StateObject[] getAllStateObjects(StateObject stateObject) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.extractStateObjects(stateObject != null ? stateObject.elem : null);
    }

    public StateObject[] getAllStateObjects(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getAllStateObjects(null, string);
    }

    public StateObject[] getAllStateObjects(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return this.findAllStateObjects(stateObject != null ? stateObject.elem : null, string);
    }

    public StateObject addStateObject(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.addStateObject(null, string);
    }

    public StateObject addStateObject(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return this.createStateObject(stateObject != null ? stateObject.elem : null, string, null);
    }

    public String getStateValueAsString(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getStateValueAsString(null, string);
    }

    public String getStateValueAsString(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        StateObject stateObject2 = this.findStateObject(stateObject != null ? stateObject.elem : null, string);
        return stateObject2 != null ? stateObject2.getValue() : null;
    }

    public Integer getStateValueAsInteger(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getStateValueAsInteger(null, string);
    }

    public Integer getStateValueAsInteger(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = this.getStateValueAsString(stateObject, string);
        if (string4 == null) {
            return null;
        }
        try {
            return Integer.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("RestorableSupport.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public Double getStateValueAsDouble(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getStateValueAsDouble(null, string);
    }

    public Double getStateValueAsDouble(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = this.getStateValueAsString(stateObject, string);
        if (string4 == null) {
            return null;
        }
        try {
            return Double.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("RestorableSupport.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public Boolean getStateValueAsBoolean(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getStateValueAsBoolean(null, string);
    }

    public Boolean getStateValueAsBoolean(StateObject stateObject, String string) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = this.getStateValueAsString(stateObject, string);
        if (string4 == null) {
            return null;
        }
        try {
            return Boolean.valueOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = Logging.getMessage("RestorableSupport.ConversionError", string4);
            Logging.logger().log(Level.SEVERE, string5, numberFormatException);
            return null;
        }
    }

    public void addStateValueAsString(String string, String string2) {
        if (string == null || string2 == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.addStateValueAsString(null, string, string2, false);
    }

    public void addStateValueAsString(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.addStateValueAsString(null, string, string2, bl);
    }

    public void addStateValueAsString(StateObject stateObject, String string, String string2) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string3 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null || string2 == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.addStateValueAsString(stateObject, string, string2, false);
    }

    public void addStateValueAsString(StateObject stateObject, String string, String string2, boolean bl) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string3 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null || string2 == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.createStateObject(stateObject != null ? stateObject.elem : null, string, string2, bl);
    }

    public void addStateValueAsInteger(String string, int n) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.addStateValueAsInteger(null, string, n);
    }

    public void addStateValueAsInteger(StateObject stateObject, String string, int n) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.addStateValueAsString(stateObject, string, Integer.toString(n));
    }

    public void addStateValueAsDouble(String string, double d) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.addStateValueAsDouble(null, string, d);
    }

    public void addStateValueAsDouble(StateObject stateObject, String string, double d) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.addStateValueAsString(stateObject, string, Double.toString(d));
    }

    public void addStateValueAsBoolean(String string, boolean bl) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.addStateValueAsBoolean(null, string, bl);
    }

    public void addStateValueAsBoolean(StateObject stateObject, String string, boolean bl) {
        if (stateObject != null && !this.containsElement(stateObject.elem)) {
            String string2 = Logging.getMessage("RestorableSupport.InvalidStateObject");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.addStateValueAsString(stateObject, string, Boolean.toString(bl));
    }

    public static String encodeColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = (color.getRed() & 0xFF) << 24 | (color.getGreen() & 0xFF) << 16 | (color.getBlue() & 0xFF) << 8 | color.getAlpha() & 0xFF;
        return String.format("%#08X", n);
    }

    public static Color decodeColor(String string) {
        Long l;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            l = Long.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("RestorableSupport.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
        int n = (int)(l & 0xFFFFFFFFL);
        return new Color(n >> 24 & 0xFF, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static class StateObject {
        final Element elem;

        StateObject(Element element) {
            if (element == null) {
                String string = Logging.getMessage("nullValue.ElementIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.elem = element;
        }

        public String getName() {
            return this.elem.getAttribute("name");
        }

        public void setName(String string) {
            if (string == null) {
                String string2 = Logging.getMessage("nullValue.StringIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            this.elem.setAttribute("name", string);
        }

        public String getValue() {
            return this.elem.getTextContent();
        }

        public void setValue(String string) {
            if (string == null) {
                String string2 = Logging.getMessage("nullValue.StringIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            this.elem.setTextContent(string);
        }
    }
}

