/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class AbsentResourceList {
    private static final int DEFAULT_MAX_ABSENT_RESOURCE_TRIES = 2;
    private static final int DEFAULT_MIN_ABSENT_RESOURCE_CHECK_INTERVAL = 10000;
    private int maxTries = 2;
    private int minCheckInterval = 10000;
    private final ConcurrentHashMap<Long, AbsentResoureEntry> possiblyAbsent = new ConcurrentHashMap();
    private SortedSet<Long> definitelyAbsent = Collections.synchronizedSortedSet(new TreeSet());

    public AbsentResourceList() {
    }

    public AbsentResourceList(int n, int n2) {
        this.maxTries = Math.max(n, 1);
        this.minCheckInterval = Math.max(n2, 500);
    }

    public final void markResourceAbsent(long l) {
        if (this.definitelyAbsent.contains(l)) {
            return;
        }
        AbsentResoureEntry absentResoureEntry = this.possiblyAbsent.get(l);
        if (absentResoureEntry == null) {
            absentResoureEntry = new AbsentResoureEntry();
            this.possiblyAbsent.put(l, absentResoureEntry);
        }
        ++absentResoureEntry.numTries;
        absentResoureEntry.timeOfLastMark = System.currentTimeMillis();
        if (absentResoureEntry.numTries >= this.maxTries) {
            this.definitelyAbsent.add(l);
            this.possiblyAbsent.remove(l);
        }
    }

    public final boolean isResourceAbsent(long l) {
        if (this.definitelyAbsent.contains(l)) {
            return true;
        }
        AbsentResoureEntry absentResoureEntry = this.possiblyAbsent.get(l);
        if (absentResoureEntry == null) {
            return false;
        }
        return System.currentTimeMillis() - absentResoureEntry.timeOfLastMark < (long)this.minCheckInterval;
    }

    public final void unmarkResourceAbsent(long l) {
        this.definitelyAbsent.remove(l);
        this.possiblyAbsent.remove(l);
    }

    private static class AbsentResoureEntry {
        long timeOfLastMark;
        int numTries;

        private AbsentResoureEntry() {
        }
    }
}

