/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.TextureData;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.util.Logging;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SurfaceShape
implements Renderable,
Disposable,
Movable {
    public static Dimension TEXTURE_SIZE_1024 = new Dimension(1024, 1024);
    public static Dimension TEXTURE_SIZE_512 = new Dimension(512, 512);
    public static Dimension TEXTURE_SIZE_256 = new Dimension(256, 256);
    public static Dimension TEXTURE_SIZE_128 = new Dimension(128, 128);
    public static Dimension TEXTURE_SIZE_64 = new Dimension(64, 64);
    public static Dimension TEXTURE_SIZE_32 = new Dimension(32, 32);
    public static Dimension TEXTURE_SIZE_16 = new Dimension(16, 16);
    public static Dimension TEXTURE_SIZE_8 = new Dimension(8, 8);
    private static final Color DEFAULT_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.4f);
    private static final Color DEFAULT_BORDER_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.7f);
    private static final Dimension DEFAULT_TEXTURE_SIZE = TEXTURE_SIZE_64;
    private static final double DEFAULT_NUM_EDGE_INTERVALS_PER_DEGREE = 1.0;
    private static final double TEXTURE_MARGIN_PIXELS = 3.0;
    private ArrayList<TextureTile> tiles = new ArrayList();
    private Dimension textureSize = DEFAULT_TEXTURE_SIZE;
    protected Globe globe;
    private Paint paint;
    private Color borderColor;
    private Stroke stroke = new BasicStroke();
    private boolean drawBorder = true;
    private boolean drawInterior = true;
    private boolean antiAlias = true;
    private double numEdgeIntervalsPerDegree = 1.0;
    protected ArrayList<LatLon> positions = new ArrayList();

    protected abstract BufferedImage drawShape(Globe var1, Sector var2, BufferedImage var3);

    public SurfaceShape(Iterable<LatLon> iterable, Color color, Color color2, Dimension dimension) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dimension != null) {
            this.textureSize = dimension;
        }
        this.paint = color != null ? color : DEFAULT_COLOR;
        this.borderColor = color2 != null ? color2 : DEFAULT_BORDER_COLOR;
        this.replacePositions(iterable);
        this.createTextureTiles();
    }

    private void replacePositions(Iterable<LatLon> iterable) {
        this.positions.clear();
        for (LatLon latLon : iterable) {
            this.positions.add(latLon);
        }
    }

    protected void createTextureTiles() {
        this.tiles.clear();
        if (!LatLon.positionsCrossDateLine(this.getPositions())) {
            this.tiles.add(new TextureTile(Sector.boundingSectorfromLatLons(this.getPositions())));
        } else {
            Sector[] sectorArray = this.computeSplitSectors(this.getPositions());
            this.tiles.add(new TextureTile(sectorArray[0]));
            this.tiles.add(new TextureTile(sectorArray[1]));
        }
    }

    private Sector computeProportionedSector(Sector sector) {
        Angle angle = sector.getDeltaLat();
        Angle angle2 = sector.getDeltaLon();
        Double d = sector.getCentroid().getLatitude().cos();
        Double d2 = this.getTextureSize().getWidth() / this.getTextureSize().getHeight();
        if (angle2.degrees / angle.degrees * d < d2) {
            Angle angle3;
            Angle angle4 = angle.divide(d).multiply(d2).subtract(angle2).divide(2.0);
            if (angle4.degrees * 2.0 > 360.0 - angle2.degrees) {
                angle4 = Angle.fromDegrees((360.0 - angle2.degrees) / 2.0);
            }
            Angle angle5 = angle.divide(this.getTextureSize().getHeight()).multiply(3.0);
            Angle angle6 = sector.getMaxLatitude().add((Angle)angle5).degrees > 90.0 ? Angle.fromDegrees(90.0 - sector.getMaxLatitude().degrees) : angle5;
            Angle angle7 = angle3 = sector.getMinLatitude().subtract((Angle)angle5).degrees < -90.0 ? Angle.fromDegrees(sector.getMinLatitude().degrees + 90.0) : angle5;
            if (sector.getMinLongitude().degrees - angle4.degrees < -180.0) {
                Angle angle8 = Angle.fromDegrees(sector.getMinLongitude().degrees + 180.0);
                Angle angle9 = angle4.add(angle4).subtract(angle8);
                sector = new Sector(sector.getMinLatitude().subtract(angle3), sector.getMaxLatitude().add(angle6), sector.getMinLongitude().subtract(angle8), sector.getMaxLongitude().add(angle9));
            } else if (sector.getMaxLongitude().degrees + angle4.degrees > 180.0) {
                Angle angle10 = Angle.fromDegrees(180.0 - sector.getMaxLongitude().degrees);
                Angle angle11 = angle4.add(angle4).subtract(angle10);
                sector = new Sector(sector.getMinLatitude().subtract(angle3), sector.getMaxLatitude().add(angle6), sector.getMinLongitude().subtract(angle11), sector.getMaxLongitude().add(angle10));
            } else {
                sector = new Sector(sector.getMinLatitude().subtract(angle3), sector.getMaxLatitude().add(angle6), sector.getMinLongitude().subtract(angle4), sector.getMaxLongitude().add(angle4));
            }
        } else if (angle2.degrees / angle.degrees * d > d2) {
            Angle angle12;
            Angle angle13 = angle2.multiply(d).divide(d2).subtract(angle).divide(2.0);
            if (angle13.degrees * 2.0 > 180.0 - angle.degrees) {
                angle13 = Angle.fromDegrees((180.0 - angle.degrees) / 2.0);
            }
            Angle angle14 = angle2.divide(this.getTextureSize().getWidth()).multiply(3.0);
            Angle angle15 = sector.getMaxLongitude().add((Angle)angle14).degrees > 180.0 ? Angle.fromDegrees(180.0 - sector.getMaxLongitude().degrees) : angle14;
            Angle angle16 = angle12 = sector.getMinLongitude().subtract((Angle)angle14).degrees < -180.0 ? Angle.fromDegrees(sector.getMinLongitude().degrees + 180.0) : angle14;
            if (sector.getMinLatitude().degrees - angle13.degrees < -90.0) {
                Angle angle17 = Angle.fromDegrees(sector.getMinLatitude().degrees + 90.0);
                Angle angle18 = angle13.add(angle13).subtract(angle17);
                sector = new Sector(sector.getMinLatitude().subtract(angle17), sector.getMaxLatitude().add(angle18), sector.getMinLongitude().subtract(angle12), sector.getMaxLongitude().add(angle15));
            } else if (sector.getMaxLatitude().degrees + angle13.degrees > 90.0) {
                Angle angle19 = Angle.fromDegrees(90.0 - sector.getMaxLatitude().degrees);
                Angle angle20 = angle13.add(angle13).subtract(angle19);
                sector = new Sector(sector.getMinLatitude().subtract(angle20), sector.getMaxLatitude().add(angle19), sector.getMinLongitude().subtract(angle12), sector.getMaxLongitude().add(angle15));
            } else {
                sector = new Sector(sector.getMinLatitude().subtract(angle13), sector.getMaxLatitude().add(angle13), sector.getMinLongitude().subtract(angle12), sector.getMaxLongitude().add(angle15));
            }
        } else {
            Angle angle21 = angle.divide(this.getTextureSize().getHeight()).multiply(3.0);
            Angle angle22 = sector.getMaxLatitude().add((Angle)angle21).degrees > 90.0 ? Angle.fromDegrees(90.0 - sector.getMaxLatitude().degrees) : angle21;
            Angle angle23 = sector.getMinLatitude().subtract((Angle)angle21).degrees < -90.0 ? Angle.fromDegrees(sector.getMinLatitude().degrees + 90.0) : angle21;
            Angle angle24 = angle2.divide(this.getTextureSize().getWidth()).multiply(3.0);
            Angle angle25 = sector.getMaxLongitude().add((Angle)angle24).degrees > 180.0 ? Angle.fromDegrees(180.0 - sector.getMaxLongitude().degrees) : angle24;
            Angle angle26 = sector.getMinLongitude().subtract((Angle)angle24).degrees < -180.0 ? Angle.fromDegrees(sector.getMinLongitude().degrees + 180.0) : angle24;
            sector = new Sector(sector.getMinLatitude().subtract(angle23), sector.getMaxLatitude().add(angle22), sector.getMinLongitude().subtract(angle26), sector.getMaxLongitude().add(angle25));
        }
        return sector;
    }

    private Sector[] computeSplitSectors(Iterable<LatLon> iterable) {
        Sector[] sectorArray = new Sector[2];
        double d = Angle.NEG180.getDegrees();
        double d2 = Angle.POS180.getDegrees();
        double d3 = Angle.POS90.getDegrees();
        double d4 = Angle.NEG90.getDegrees();
        LatLon latLon = null;
        for (LatLon latLon2 : iterable) {
            double d5;
            double d6 = latLon2.getLatitude().getDegrees();
            if (d6 > d4) {
                d4 = d6;
            }
            if (d6 < d3) {
                d3 = d6;
            }
            if ((d5 = latLon2.getLongitude().getDegrees()) <= 0.0 && d5 > d) {
                d = d5;
            }
            if (d5 >= 0.0 && d5 < d2) {
                d2 = d5;
            }
            if (latLon != null) {
                double d7 = latLon.getLongitude().getDegrees();
                if (Math.signum(d5) != Math.signum(d7) && Math.abs(d5 - d7) < 180.0) {
                    d = 0.0;
                    d2 = 0.0;
                }
            }
            latLon = latLon2;
        }
        d = d2 < -d ? -d2 : d;
        d2 = d2 > -d ? -d : d2;
        sectorArray[0] = Sector.fromDegrees(d3, d4, d2, 180.0);
        sectorArray[1] = Sector.fromDegrees(d3, d4, -180.0, d);
        return sectorArray;
    }

    @Override
    public void dispose() {
        this.tiles.clear();
    }

    public ArrayList<Sector> getSectors() {
        ArrayList<Sector> arrayList = new ArrayList<Sector>();
        for (TextureTile textureTile : this.tiles) {
            arrayList.add(textureTile.getSector());
        }
        return arrayList;
    }

    public Iterable<LatLon> getPositions() {
        return this.positions;
    }

    public void setPositions(Iterable<LatLon> iterable) {
        this.replacePositions(iterable);
        this.createTextureTiles();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        this.clearTextureData();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.clearTextureData();
    }

    public Dimension getTextureSize() {
        return this.textureSize;
    }

    public void setTextureSize(Dimension dimension) {
        this.textureSize = dimension;
        this.createTextureTiles();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.clearTextureData();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        this.clearTextureData();
    }

    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    public void setDrawInterior(boolean bl) {
        this.drawInterior = bl;
        this.clearTextureData();
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
        this.clearTextureData();
    }

    public double getNumEdgeIntervalsPerDegree() {
        return this.numEdgeIntervalsPerDegree;
    }

    public void setNumEdgeIntervalsPerDegree(double d) {
        this.numEdgeIntervalsPerDegree = d;
        this.clearTextureData();
    }

    private boolean intersects(Sector sector) {
        for (TextureTile textureTile : this.tiles) {
            if (!textureTile.getSector().intersects(sector)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DrawContext drawContext) {
        this.globe = drawContext.getGlobe();
        if (this.tiles.size() == 0) {
            this.createTextureTiles();
        }
        if (!this.intersects(drawContext.getVisibleSector())) {
            return;
        }
        if (!this.tiles.get(0).isTextureInMemory(drawContext.getTextureCache())) {
            this.makeTextureData(drawContext, this.textureSize);
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(16392);
        try {
            if (!drawContext.isPickingMode()) {
                gL.glEnable(3042);
                gL.glBlendFunc(770, 771);
            }
            gL.glPolygonMode(1028, 6914);
            gL.glEnable(2884);
            gL.glCullFace(1029);
            drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.tiles);
        }
        finally {
            gL.glPopAttrib();
        }
    }

    private void makeTextureData(DrawContext drawContext, Dimension dimension) {
        for (TextureTile textureTile : this.tiles) {
            BufferedImage bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 6);
            TextureData textureData = new TextureData(6408, 6408, false, this.drawShape(drawContext.getGlobe(), textureTile.getSector(), bufferedImage));
            textureData.setMustFlipVertically(false);
            textureTile.setTextureData(textureData);
        }
    }

    private void clearTextureData() {
        this.tiles.clear();
    }

    @Override
    public Position getReferencePosition() {
        LatLon latLon = this.tiles.get(0).getSector().getCentroid();
        return new Position(latLon, 0.0);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.moveTo(this.getReferencePosition().add(position));
    }

    public void shiftTo(Position position) {
        if (this.globe == null) {
            return;
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = this.globe.computePointFromPosition(this.getReferencePosition().getLatitude(), this.getReferencePosition().getLongitude(), 0.0);
        Vec4 vec42 = this.globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), 0.0);
        Vec4 vec43 = vec42.subtract3(vec4);
        for (int i = 0; i < this.positions.size(); ++i) {
            LatLon latLon = this.positions.get(i);
            Vec4 vec44 = this.globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
            vec44 = vec44.add3(vec43);
            Position position2 = this.globe.computePositionFromPoint(vec44);
            this.positions.set(i, new LatLon(position2.getLatitude(), position2.getLongitude()));
        }
        this.createTextureTiles();
    }

    @Override
    public void moveTo(Position position) {
        if (LatLon.positionsCrossDateLine(this.positions)) {
            this.shiftTo(position);
            return;
        }
        LatLon latLon = this.getReferencePosition().getLatLon();
        LatLon latLon2 = position.getLatLon();
        for (int i = 0; i < this.positions.size(); ++i) {
            LatLon latLon3 = this.positions.get(i);
            double d = LatLon.greatCircleDistance((LatLon)latLon, (LatLon)latLon3).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)latLon, (LatLon)latLon3).radians;
            LatLon latLon4 = LatLon.greatCircleEndPosition(latLon2, d2, d);
            this.positions.set(i, latLon4);
        }
        this.createTextureTiles();
    }

    public static SurfaceShape createEllipse(Globe globe, LatLon latLon, double d, double d2, Angle angle, int n, Color color, Color color2, Dimension dimension) {
        if (angle == null) {
            angle = Angle.ZERO;
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.MajorAxisInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("Geom.MajorAxisInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = 1 + Math.max(n, 4);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        double d3 = globe.getRadiusAt(latLon.getLatitude(), latLon.getLongitude());
        double d4 = Math.PI * 2 / (double)(n2 - 1);
        for (int i = 0; i < n2; ++i) {
            double d5 = i != n2 - 1 ? (double)i * d4 : 0.0;
            double d6 = 1.5707963267948966 - (d5 + angle.radians);
            double d7 = d * Math.cos(d5);
            double d8 = d2 * Math.sin(d5);
            double d9 = Math.sqrt(d7 * d7 + d8 * d8);
            LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, d6, d9 / d3);
            arrayList.add(latLon2);
        }
        return new SurfacePolygon(arrayList, color, color2, dimension);
    }
}

