/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.nio.DoubleBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class FrameFactory {
    public static final String SHAPE_RECTANGLE = "Render.FrameFactory.ShapeRectangle";
    public static final String SHAPE_ELLIPSE = "Render.FrameFactory.ShapeEllipse";
    public static final String SHAPE_NONE = "Render.FrameFactory.ShapeNone";
    public static final String LEADER_TRIANGLE = "Render.FrameFactory.LeaderTriangle";
    public static final String LEADER_NONE = "Render.FrameFactory.LeaderNone";
    private static int cornerSteps = 5;
    private static int leaderGapWidth = 6;
    private static int circleSteps = 36;

    public static void drawShape(DrawContext drawContext, String string, double d, double d2, int n, int n2) {
        if (!string.equals(SHAPE_NONE)) {
            FrameFactory.drawBuffer(drawContext, n, FrameFactory.createShapeBuffer(string, d, d2, n2));
        }
    }

    public static void drawShapeWithLeader(DrawContext drawContext, String string, double d, double d2, Point point, int n, int n2) {
        if (!string.equals(SHAPE_NONE)) {
            FrameFactory.drawBuffer(drawContext, n, FrameFactory.createShapeWithLeaderBuffer(string, d, d2, point, n2));
        }
    }

    public static DoubleBuffer createShapeBuffer(String string, double d, double d2, int n) {
        if (string.equals(SHAPE_RECTANGLE)) {
            return FrameFactory.createRoundedRectangleBuffer(d, d2, n);
        }
        if (string.equals(SHAPE_ELLIPSE)) {
            return FrameFactory.createEllipseBuffer(d, d2, circleSteps);
        }
        if (string.equals(SHAPE_NONE)) {
            return null;
        }
        return FrameFactory.createRoundedRectangleBuffer(d, d2, n);
    }

    public static DoubleBuffer createShapeWithLeaderBuffer(String string, double d, double d2, Point point, int n) {
        if (string.equals(SHAPE_RECTANGLE)) {
            return FrameFactory.createRoundedRectangleWithLeaderBuffer(d, d2, point, n);
        }
        if (string.equals(SHAPE_ELLIPSE)) {
            return FrameFactory.createEllipseWithLeaderBuffer(d, d2, point, circleSteps);
        }
        if (string.equals(SHAPE_NONE)) {
            return null;
        }
        return FrameFactory.createRoundedRectangleWithLeaderBuffer(d, d2, point, n);
    }

    public static void drawBuffer(DrawContext drawContext, int n, DoubleBuffer doubleBuffer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushClientAttrib(2);
        gL.glEnableClientState(32884);
        gL.glVertexPointer(2, 5130, 0, doubleBuffer.rewind());
        gL.glDrawArrays(n, 0, doubleBuffer.limit() / 2);
        gL.glPopClientAttrib();
    }

    public static void drawBuffer(DrawContext drawContext, int n, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer == null || doubleBuffer2 == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushClientAttrib(2);
        gL.glEnableClientState(32884);
        gL.glVertexPointer(2, 5130, 0, doubleBuffer.rewind());
        gL.glEnableClientState(32888);
        gL.glTexCoordPointer(2, 5130, 0, doubleBuffer2.rewind());
        gL.glDrawArrays(n, 0, doubleBuffer.limit() / 2);
        gL.glPopClientAttrib();
    }

    private static DoubleBuffer createRoundedRectangleBuffer(double d, double d2, int n) {
        int n2 = 9 + (n < 1 ? 0 : 4 * (cornerSteps - 2));
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(n2 * 2);
        int n3 = 0;
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d - (double)n);
        doubleBuffer.put(n3++, 0.0);
        n3 = FrameFactory.drawCorner(d - (double)n, n, n, -1.5707963267948966, 0.0, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, d);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, d);
        doubleBuffer.put(n3++, d2 - (double)n);
        n3 = FrameFactory.drawCorner(d - (double)n, d2 - (double)n, n, 0.0, 1.5707963267948966, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, d - (double)n);
        doubleBuffer.put(n3++, d2);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, d2);
        n3 = FrameFactory.drawCorner(n, d2 - (double)n, n, 1.5707963267948966, Math.PI, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d2 - (double)n);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, n);
        n3 = FrameFactory.drawCorner(n, n, n, Math.PI, 4.71238898038469, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, 0.0);
        return doubleBuffer;
    }

    private static DoubleBuffer createRoundedRectangleWithLeaderBuffer(double d, double d2, Point point, int n) {
        int n2 = 12 + (n < 1 ? 0 : 4 * (cornerSteps - 2));
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(n2 * 2);
        int n3 = 0;
        doubleBuffer.put(n3++, d / 2.0 + (double)(leaderGapWidth / 2));
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d - (double)n);
        doubleBuffer.put(n3++, 0.0);
        n3 = FrameFactory.drawCorner(d - (double)n, n, n, -1.5707963267948966, 0.0, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, d);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, d);
        doubleBuffer.put(n3++, d2 - (double)n);
        n3 = FrameFactory.drawCorner(d - (double)n, d2 - (double)n, n, 0.0, 1.5707963267948966, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, d - (double)n);
        doubleBuffer.put(n3++, d2);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, d2);
        n3 = FrameFactory.drawCorner(n, d2 - (double)n, n, 1.5707963267948966, Math.PI, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d2 - (double)n);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, n);
        n3 = FrameFactory.drawCorner(n, n, n, Math.PI, 4.71238898038469, cornerSteps, doubleBuffer, n3);
        doubleBuffer.put(n3++, n);
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, d / 2.0 - (double)(leaderGapWidth / 2));
        doubleBuffer.put(n3++, 0.0);
        doubleBuffer.put(n3++, point.x);
        doubleBuffer.put(n3++, point.y);
        doubleBuffer.put(n3++, d / 2.0 + (double)(leaderGapWidth / 2));
        doubleBuffer.put(n3++, 0.0);
        return doubleBuffer;
    }

    private static int drawCorner(double d, double d2, double d3, double d4, double d5, int n, DoubleBuffer doubleBuffer, int n2) {
        if (d3 < 1.0) {
            return n2;
        }
        GL gL = GLU.getCurrentGL();
        double d6 = (d5 - d4) / (double)(n - 1);
        for (int i = 1; i < n - 1; ++i) {
            double d7 = d4 + d6 * (double)i;
            double d8 = d + Math.cos(d7) * d3;
            double d9 = d2 + Math.sin(d7) * d3;
            doubleBuffer.put(n2++, d8);
            doubleBuffer.put(n2++, d9);
        }
        return n2;
    }

    private static DoubleBuffer createEllipseBuffer(double d, double d2, int n) {
        int n2 = n + 1;
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(n2 * 2);
        int n3 = 0;
        double d3 = d / 2.0;
        double d4 = d2 / 2.0;
        double d5 = 1.5707963267948966;
        double d6 = d3;
        double d7 = d4;
        double d8 = Math.PI * 2 / (double)n;
        for (int i = 0; i <= n; ++i) {
            double d9 = d8 * (double)i - d5;
            double d10 = d6 + Math.cos(d9) * d3;
            double d11 = d7 + Math.sin(d9) * d4;
            doubleBuffer.put(n3++, d10);
            doubleBuffer.put(n3++, d11);
        }
        return doubleBuffer;
    }

    private static DoubleBuffer createEllipseWithLeaderBuffer(double d, double d2, Point point, int n) {
        int n2 = n + 3;
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(n2 * 2);
        int n3 = 0;
        double d3 = d / 2.0;
        double d4 = d2 / 2.0;
        double d5 = 1.5707963267948966;
        double d6 = d3;
        double d7 = d4;
        double d8 = Math.PI * 2 / (double)n;
        double d9 = (double)(leaderGapWidth / 2) / d3;
        for (int i = 0; i <= n; ++i) {
            double d10 = d8 * (double)i - d5;
            if (i == 0) {
                d10 += d9;
            }
            if (i == n) {
                d10 -= d9;
            }
            double d11 = d6 + Math.cos(d10) * d3;
            double d12 = d7 + Math.sin(d10) * d4;
            doubleBuffer.put(n3++, d11);
            doubleBuffer.put(n3++, d12);
        }
        doubleBuffer.put(n3++, point.x);
        doubleBuffer.put(n3++, point.y);
        doubleBuffer.put(n3++, d6 + Math.cos(d9 - d5) * d3);
        doubleBuffer.put(n3++, d7 + Math.sin(d9 - d5) * d4);
        return doubleBuffer;
    }

    public static DoubleBuffer getTextureCoordinates(DoubleBuffer doubleBuffer, double d, double d2, double d3, double d4) {
        if (doubleBuffer == null) {
            return null;
        }
        int n = doubleBuffer.limit() / 2;
        DoubleBuffer doubleBuffer2 = BufferUtil.newDoubleBuffer(n * 2);
        int n2 = 0;
        for (int i = 0; i < doubleBuffer.limit(); i += 2) {
            doubleBuffer2.put(n2++, doubleBuffer.get(i) / d3);
            doubleBuffer2.put(n2++, (d2 - doubleBuffer.get(i + 1)) / d4);
        }
        return doubleBuffer2;
    }
}

