/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.cache.TextureCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.SectorGeometryList;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.AnnotationRenderer;
import gov.nasa.worldwind.render.BasicAnnotationRenderer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicSurfaceTileRenderer;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.SurfaceTileRenderer;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PerformanceStatistic;
import java.awt.Color;
import java.awt.Point;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawContextImpl
extends WWObjectImpl
implements DrawContext {
    private GLContext glContext;
    private GLU glu = new GLU();
    private View view;
    private Model model;
    private Globe globe;
    private double verticalExaggeration = 1.0;
    private Sector visibleSector;
    private SectorGeometryList surfaceGeometry;
    private PickedObjectList pickedObjects = new PickedObjectList();
    private int uniquePickNumber = 0;
    private Color clearColor = new Color(0, 0, 0, 0);
    private boolean isPickingMode = false;
    private Point pickPoint = null;
    private Point viewportCenterScreenPoint = null;
    private Position viewportCenterPosition = null;
    private Vec4 viewportCenterSurfacePoint = null;
    private Vec4 viewportCenterGlobePoint = null;
    private int numTextureUnits = -1;
    private SurfaceTileRenderer geographicSurfaceTileRenderer = new GeographicSurfaceTileRenderer();
    private AnnotationRenderer annotationRenderer = new BasicAnnotationRenderer();
    private TextureCache textureCache;
    private TextRendererCache textRendererCache;
    private Set<String> perFrameStatisticsKeys;
    private Collection<PerformanceStatistic> perFrameStatistics;
    PriorityQueue<OrderedRenderable> orderedRenderables = new PriorityQueue<OrderedRenderable>(100, new Comparator<OrderedRenderable>(){

        @Override
        public int compare(OrderedRenderable orderedRenderable, OrderedRenderable orderedRenderable2) {
            double d;
            double d2 = orderedRenderable.getDistanceFromEye();
            return d2 > (d = orderedRenderable2.getDistanceFromEye()) ? -1 : (d2 == d ? 0 : 1);
        }
    });

    public void reinitialize() {
        if (this.geographicSurfaceTileRenderer != null) {
            this.geographicSurfaceTileRenderer.dispose();
        }
        this.geographicSurfaceTileRenderer = new GeographicSurfaceTileRenderer();
        this.pickedObjects.clear();
        this.perFrameStatistics.clear();
        this.perFrameStatisticsKeys.clear();
        this.annotationRenderer = new BasicAnnotationRenderer();
    }

    @Override
    public void dispose() {
        this.geographicSurfaceTileRenderer.dispose();
    }

    @Override
    public final GL getGL() {
        return this.getGLContext().getGL();
    }

    @Override
    public final GLU getGLU() {
        return this.glu;
    }

    @Override
    public final GLContext getGLContext() {
        return this.glContext;
    }

    @Override
    public final int getDrawableHeight() {
        return this.getGLDrawable().getHeight();
    }

    @Override
    public final int getDrawableWidth() {
        return this.getGLDrawable().getWidth();
    }

    @Override
    public final GLDrawable getGLDrawable() {
        return this.getGLContext().getGLDrawable();
    }

    @Override
    public final void initialize(GLContext gLContext) {
        if (gLContext == null) {
            String string = Logging.getMessage("nullValue.GLContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.glContext = gLContext;
        this.visibleSector = null;
        if (this.surfaceGeometry != null) {
            this.surfaceGeometry.clear();
        }
        this.surfaceGeometry = null;
        this.pickedObjects.clear();
        this.orderedRenderables.clear();
        this.uniquePickNumber = 0;
        if (this.numTextureUnits < 1) {
            this.numTextureUnits = DrawContextImpl.queryMaxTextureUnits(gLContext);
        }
    }

    private static int queryMaxTextureUnits(GLContext gLContext) {
        int[] nArray = new int[1];
        gLContext.getGL().glGetIntegerv(34018, nArray, 0);
        return nArray[0];
    }

    @Override
    public final void setModel(Model model) {
        this.model = model;
        if (this.model == null) {
            return;
        }
        Globe globe = this.model.getGlobe();
        if (globe != null) {
            this.globe = globe;
        }
    }

    @Override
    public final Model getModel() {
        return this.model;
    }

    @Override
    public final LayerList getLayers() {
        return this.model.getLayers();
    }

    @Override
    public final Sector getVisibleSector() {
        return this.visibleSector;
    }

    @Override
    public final void setVisibleSector(Sector sector) {
        this.visibleSector = sector;
    }

    @Override
    public void setSurfaceGeometry(SectorGeometryList sectorGeometryList) {
        this.surfaceGeometry = sectorGeometryList;
    }

    @Override
    public SectorGeometryList getSurfaceGeometry() {
        return this.surfaceGeometry;
    }

    @Override
    public final Globe getGlobe() {
        return this.globe != null ? this.globe : this.model.getGlobe();
    }

    @Override
    public final void setView(View view) {
        this.view = view;
    }

    @Override
    public final View getView() {
        return this.view;
    }

    @Override
    public final void setGLContext(GLContext gLContext) {
        if (gLContext == null) {
            String string = Logging.getMessage("nullValue.GLContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.glContext = gLContext;
    }

    @Override
    public final double getVerticalExaggeration() {
        return this.verticalExaggeration;
    }

    @Override
    public final void setVerticalExaggeration(double d) {
        this.verticalExaggeration = d;
    }

    @Override
    public TextureCache getTextureCache() {
        return this.textureCache;
    }

    @Override
    public void setTextureCache(TextureCache textureCache) {
        if (textureCache == null) {
            String string = Logging.getMessage("nullValue.TextureCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textureCache = textureCache;
    }

    @Override
    public TextRendererCache getTextRendererCache() {
        return this.textRendererCache;
    }

    @Override
    public void setTextRendererCache(TextRendererCache textRendererCache) {
        if (textRendererCache == null) {
            String string = Logging.getMessage("nullValue.TextRendererCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textRendererCache = textRendererCache;
    }

    @Override
    public AnnotationRenderer getAnnotationRenderer() {
        return this.annotationRenderer;
    }

    @Override
    public void setAnnotationRenderer(AnnotationRenderer annotationRenderer) {
        if (annotationRenderer == null) {
            String string = Logging.getMessage("nullValue.AnnotationRendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.annotationRenderer = annotationRenderer;
    }

    @Override
    public Point getPickPoint() {
        return this.pickPoint;
    }

    @Override
    public void setPickPoint(Point point) {
        this.pickPoint = point;
    }

    @Override
    public Point getViewportCenterScreenPoint() {
        return this.viewportCenterScreenPoint;
    }

    @Override
    public void setViewportCenterScreenPoint(Point point) {
        this.viewportCenterScreenPoint = point;
    }

    @Override
    public Position getViewportCenterPosition() {
        return this.viewportCenterPosition;
    }

    @Override
    public void setViewportCenterPosition(Position position) {
        this.viewportCenterPosition = position;
        this.viewportCenterGlobePoint = null;
        this.viewportCenterSurfacePoint = null;
        if (position != null) {
            if (this.getGlobe() != null) {
                this.viewportCenterGlobePoint = this.getGlobe().computePointFromPosition(this.viewportCenterPosition.getLatitude(), this.viewportCenterPosition.getLongitude(), 0.0);
            }
            if (this.getSurfaceGeometry() != null) {
                this.viewportCenterSurfacePoint = this.getSurfaceGeometry().getSurfacePoint(this.viewportCenterPosition);
            }
        }
    }

    @Override
    public Vec4 getViewportCenterSurfacePoint() {
        return this.viewportCenterSurfacePoint;
    }

    @Override
    public Vec4 getViewportCenterGlobePoint() {
        return this.viewportCenterGlobePoint;
    }

    @Override
    public void addPickedObjects(PickedObjectList pickedObjectList) {
        if (pickedObjectList == null) {
            String string = Logging.getMessage("nullValue.PickedObjectList");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.pickedObjects == null) {
            this.pickedObjects = pickedObjectList;
            return;
        }
        for (PickedObject pickedObject : pickedObjectList) {
            this.pickedObjects.add(pickedObject);
        }
    }

    @Override
    public void addPickedObject(PickedObject pickedObject) {
        if (null == pickedObject) {
            String string = Logging.getMessage("nullValue.PickedObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == this.pickedObjects) {
            this.pickedObjects = new PickedObjectList();
        }
        this.pickedObjects.add(pickedObject);
    }

    @Override
    public PickedObjectList getPickedObjects() {
        return this.pickedObjects;
    }

    @Override
    public Color getUniquePickColor() {
        ++this.uniquePickNumber;
        int n = this.getClearColor().getRGB();
        if (n == this.uniquePickNumber) {
            ++this.uniquePickNumber;
        }
        if (this.uniquePickNumber >= 0xFFFFFF) {
            this.uniquePickNumber = 1;
            if (n == this.uniquePickNumber) {
                ++this.uniquePickNumber;
            }
        }
        return new Color(this.uniquePickNumber, true);
    }

    @Override
    public Color getClearColor() {
        return this.clearColor;
    }

    @Override
    public boolean isPickingMode() {
        return this.isPickingMode;
    }

    @Override
    public void enablePickingMode() {
        this.isPickingMode = true;
    }

    @Override
    public void disablePickingMode() {
        this.isPickingMode = false;
    }

    @Override
    public void addOrderedRenderable(OrderedRenderable orderedRenderable) {
        if (null == orderedRenderable) {
            String string = Logging.getMessage("nullValue.OrderedRenderable");
            Logging.logger().warning(string);
            return;
        }
        this.orderedRenderables.add(orderedRenderable);
    }

    @Override
    public Queue<OrderedRenderable> getOrderedRenderables() {
        return this.orderedRenderables;
    }

    @Override
    public void drawUnitQuad() {
        GL gL = this.getGL();
        gL.glBegin(7);
        gL.glVertex2d(0.0, 0.0);
        gL.glVertex2d(1.0, 0.0);
        gL.glVertex2d(1.0, 1.0);
        gL.glVertex2d(0.0, 1.0);
        gL.glEnd();
    }

    @Override
    public void drawUnitQuad(TextureCoords textureCoords) {
        GL gL = this.getGL();
        gL.glBegin(7);
        gL.glTexCoord2d(textureCoords.left(), textureCoords.bottom());
        gL.glVertex2d(0.0, 0.0);
        gL.glTexCoord2d(textureCoords.right(), textureCoords.bottom());
        gL.glVertex2d(1.0, 0.0);
        gL.glTexCoord2d(textureCoords.right(), textureCoords.top());
        gL.glVertex2d(1.0, 1.0);
        gL.glTexCoord2d(textureCoords.left(), textureCoords.top());
        gL.glVertex2d(0.0, 1.0);
        gL.glEnd();
    }

    @Override
    public int getNumTextureUnits() {
        return this.numTextureUnits;
    }

    @Override
    public void setNumTextureUnits(int n) {
        this.numTextureUnits = n;
    }

    @Override
    public Vec4 getPointOnGlobe(Angle angle, Angle angle2) {
        Vec4 vec4;
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.getVisibleSector() == null) {
            return null;
        }
        if (!this.getVisibleSector().contains(angle, angle2)) {
            return null;
        }
        SectorGeometryList sectorGeometryList = this.getSurfaceGeometry();
        if (sectorGeometryList != null && (vec4 = sectorGeometryList.getSurfacePoint(angle, angle2)) != null) {
            return vec4;
        }
        return null;
    }

    @Override
    public SurfaceTileRenderer getGeographicSurfaceTileRenderer() {
        return this.geographicSurfaceTileRenderer;
    }

    @Override
    public Collection<PerformanceStatistic> getPerFrameStatistics() {
        return this.perFrameStatistics;
    }

    @Override
    public void setPerFrameStatisticsKeys(Set<String> set, Collection<PerformanceStatistic> collection) {
        this.perFrameStatisticsKeys = set;
        this.perFrameStatistics = collection;
    }

    @Override
    public Set<String> getPerFrameStatisticsKeys() {
        return this.perFrameStatisticsKeys;
    }

    @Override
    public void setPerFrameStatistic(String string, String string2, Object object) {
        if (this.perFrameStatistics == null || this.perFrameStatisticsKeys == null) {
            return;
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.KeyIsNull=Key is null");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.DisplayNameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (this.perFrameStatisticsKeys.contains(string) || this.perFrameStatisticsKeys.contains("gov.nasa.worldwind.perfstat.All")) {
            this.perFrameStatistics.add(new PerformanceStatistic(string, string2, object));
        }
    }

    @Override
    public void setPerFrameStatistics(Collection<PerformanceStatistic> collection) {
        if (this.perFrameStatistics == null || this.perFrameStatisticsKeys == null) {
            return;
        }
        if (collection == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull=Key is null");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (PerformanceStatistic performanceStatistic : collection) {
            this.perFrameStatistics.add(performanceStatistic);
        }
    }
}

