/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.placename;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameService;
import gov.nasa.worldwind.layers.placename.PlaceNameServiceSet;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.GeographicTextRenderer;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceNameLayer
extends AbstractLayer {
    private final PlaceNameServiceSet placeNameServiceSet;
    private final List<Tile[]> tiles = new ArrayList<Tile[]>();
    private PriorityBlockingQueue<Runnable> requestQ = new PriorityBlockingQueue(64);
    private Vec4 referencePoint;
    private final Object fileLock = new Object();
    private final GeographicTextRenderer placeNameRenderer = new GeographicTextRenderer();

    public PlaceNameLayer(PlaceNameServiceSet placeNameServiceSet) {
        if (placeNameServiceSet == null) {
            String string = Logging.getMessage("nullValue.PlaceNameServiceSetIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.placeNameServiceSet = placeNameServiceSet.deepCopy();
        for (int i = 0; i < this.placeNameServiceSet.getServiceCount(); ++i) {
            this.tiles.add(i, this.buildTiles(this.placeNameServiceSet.getService(i)));
        }
        if (!WorldWind.getMemoryCacheSet().containsCache(Tile.class.getName())) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.PlacenameLayerCacheSize", 2000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName("Placename Tiles");
            WorldWind.getMemoryCacheSet().addCache(Tile.class.getName(), basicMemoryCache);
        }
    }

    public final PlaceNameServiceSet getPlaceNameServiceSet() {
        return this.placeNameServiceSet;
    }

    private PriorityBlockingQueue<Runnable> getRequestQ() {
        return this.requestQ;
    }

    private Tile[] buildTiles(PlaceNameService placeNameService) {
        Sector sector = placeNameService.getSector();
        Angle angle = placeNameService.getTileDelta().getLatitude();
        Angle angle2 = placeNameService.getTileDelta().getLongitude();
        int n = Tile.computeRow(angle, sector.getMinLatitude());
        int n2 = Tile.computeColumn(angle2, sector.getMinLongitude());
        int n3 = Tile.computeRow(angle, sector.getMaxLatitude().subtract(angle));
        int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude().subtract(angle2));
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        Tile[] tileArray = new Tile[n5 * n6];
        Angle angle3 = Tile.computeRowLatitude(n, angle);
        for (int i = 0; i <= n3 - n; ++i) {
            Angle angle4 = angle3.add(angle);
            Angle angle5 = Tile.computeColumnLongitude(n2, angle2);
            for (int j = 0; j <= n4 - n2; ++j) {
                Angle angle6 = angle5.add(angle2);
                tileArray[j + i * n6] = new Tile(placeNameService, new Sector(angle3, angle4, angle5, angle6), i, j);
                angle5 = angle6;
            }
            angle3 = angle4;
        }
        return tileArray;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.placeNameRenderer != null) {
            this.placeNameRenderer.dispose();
        }
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.referencePoint = this.computeReferencePoint(drawContext);
        int n = this.placeNameServiceSet.getServiceCount();
        for (int i = 0; i < n; ++i) {
            Tile[] tileArray;
            PlaceNameService placeNameService = this.placeNameServiceSet.getService(i);
            if (!PlaceNameLayer.isServiceVisible(drawContext, placeNameService)) continue;
            double d = placeNameService.getMinDisplayDistance();
            double d2 = placeNameService.getMaxDisplayDistance();
            double d3 = d * d;
            double d4 = d2 * d2;
            if (!PlaceNameLayer.isSectorVisible(drawContext, placeNameService.getSector(), d3, d4)) continue;
            for (Tile tile : tileArray = this.tiles.get(i)) {
                try {
                    this.drawOrRequestTile(drawContext, tile, d3, d4);
                }
                catch (Exception exception) {
                    Logging.logger().log(Level.FINE, Logging.getMessage("layers.PlaceNameLayer.ExceptionRenderingTile"), exception);
                }
            }
        }
        this.sendRequests();
        this.requestQ.clear();
    }

    private Vec4 computeReferencePoint(DrawContext drawContext) {
        if (drawContext.getViewportCenterPosition() != null) {
            return drawContext.getGlobe().computePointFromPosition(drawContext.getViewportCenterPosition());
        }
        Rectangle rectangle = drawContext.getView().getViewport();
        int n = (int)((RectangularShape)rectangle).getWidth() / 2;
        for (int i = (int)(0.5 * ((RectangularShape)rectangle).getHeight()); i >= 0; --i) {
            Position position = drawContext.getView().computePositionFromScreenPoint(n, i);
            if (position == null) continue;
            return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), 0.0);
        }
        return null;
    }

    protected Vec4 getReferencePoint() {
        return this.referencePoint;
    }

    private void drawOrRequestTile(DrawContext drawContext, Tile tile, double d, double d2) {
        if (!PlaceNameLayer.isTileVisible(drawContext, tile, d, d2)) {
            return;
        }
        if (tile.isTileInMemory()) {
            PlaceNameChunk placeNameChunk = tile.getData();
            Iterable iterable = placeNameChunk.makeIterable(drawContext);
            this.placeNameRenderer.render(drawContext, iterable);
            return;
        }
        if (!tile.getPlaceNameService().isResourceAbsent(tile.getPlaceNameService().getTileNumber(tile.row, tile.column))) {
            this.requestTile(drawContext, tile);
        }
    }

    private static boolean isServiceVisible(DrawContext drawContext, PlaceNameService placeNameService) {
        if (!placeNameService.isEnabled()) {
            return false;
        }
        if (drawContext.getVisibleSector() != null && !placeNameService.getSector().intersects(drawContext.getVisibleSector())) {
            return false;
        }
        return placeNameService.getExtent(drawContext).intersects(drawContext.getView().getFrustumInModelCoordinates());
    }

    private static boolean isSectorVisible(DrawContext drawContext, Sector sector, double d, double d2) {
        View view = drawContext.getView();
        Position position = view.getEyePosition();
        if (position == null) {
            return false;
        }
        Angle angle = PlaceNameLayer.clampAngle(position.getLatitude(), sector.getMinLatitude(), sector.getMaxLatitude());
        Angle angle2 = PlaceNameLayer.clampAngle(position.getLongitude(), sector.getMinLongitude(), sector.getMaxLongitude());
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, 0.0);
        double d3 = drawContext.getView().getEyePoint().distanceToSquared3(vec4);
        return !(d > d3) && !(d2 < d3);
    }

    private static boolean isTileVisible(DrawContext drawContext, Tile tile, double d, double d2) {
        if (!tile.getSector().intersects(drawContext.getVisibleSector())) {
            return false;
        }
        View view = drawContext.getView();
        Position position = view.getEyePosition();
        if (position == null) {
            return false;
        }
        Angle angle = PlaceNameLayer.clampAngle(position.getLatitude(), tile.getSector().getMinLatitude(), tile.getSector().getMaxLatitude());
        Angle angle2 = PlaceNameLayer.clampAngle(position.getLongitude(), tile.getSector().getMinLongitude(), tile.getSector().getMaxLongitude());
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, 0.0);
        double d3 = drawContext.getView().getEyePoint().distanceToSquared3(vec4);
        return !(d > d3) && !(d2 < d3);
    }

    private static boolean isNameVisible(DrawContext drawContext, PlaceNameService placeNameService, Position position) {
        double d = drawContext.getVerticalExaggeration() * position.getElevation();
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
        Vec4 vec42 = drawContext.getView().getEyePoint();
        double d2 = vec42.distanceTo3(vec4);
        return d2 >= placeNameService.getMinDisplayDistance() && d2 <= placeNameService.getMaxDisplayDistance();
    }

    private static Angle clampAngle(Angle angle, Angle angle2, Angle angle3) {
        double d = angle.degrees;
        double d2 = angle2.degrees;
        double d3 = angle3.degrees;
        return Angle.fromDegrees(d < d2 ? d2 : (d > d3 ? d3 : d));
    }

    private void requestTile(DrawContext drawContext, Tile tile) {
        Vec4 vec4 = tile.getCentroidPoint(drawContext.getGlobe());
        if (this.getReferencePoint() != null) {
            tile.setPriority(vec4.distanceTo3(this.getReferencePoint()));
        }
        RequestTask requestTask = new RequestTask(tile, this);
        this.getRequestQ().add(requestTask);
    }

    private void sendRequests() {
        Runnable runnable = this.requestQ.poll();
        while (runnable != null) {
            if (!WorldWind.getTaskService().isFull()) {
                WorldWind.getTaskService().addTask(runnable);
            }
            runnable = this.requestQ.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTile(Tile tile, URL uRL) {
        PlaceNameChunk placeNameChunk;
        if (WWIO.isFileOutOfDate(uRL, this.placeNameServiceSet.getExpiryTime())) {
            WorldWind.getDataFileCache().removeFile(uRL);
            String string = Logging.getMessage("generic.DataFileExpired", uRL);
            Logging.logger().fine(string);
            return false;
        }
        Object object = this.fileLock;
        synchronized (object) {
            placeNameChunk = PlaceNameLayer.readTileData(tile, uRL);
        }
        if (placeNameChunk == null) {
            return false;
        }
        this.addTileToCache(tile, placeNameChunk);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PlaceNameChunk readTileData(Tile tile, URL uRL) {
        InputStream inputStream = null;
        try {
            String string = uRL.getFile();
            string = string.replaceAll("%20", " ");
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            inputStream = new GZIPInputStream(bufferedInputStream);
            GMLPlaceNameSAXHandler gMLPlaceNameSAXHandler = new GMLPlaceNameSAXHandler();
            SAXParserFactory.newInstance().newSAXParser().parse(inputStream, (DefaultHandler)gMLPlaceNameSAXHandler);
            PlaceNameChunk placeNameChunk = gMLPlaceNameSAXHandler.createPlaceNameChunk(tile.getPlaceNameService());
            return placeNameChunk;
        }
        catch (Exception exception) {
            Logging.logger().log(Level.FINE, Logging.getMessage("layers.PlaceNameLayer.ExceptionAttemptingToReadFile", uRL.toString()), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logging.logger().log(Level.FINE, Logging.getMessage("layers.PlaceNameLayer.ExceptionAttemptingToReadFile", uRL.toString()), iOException);
            }
        }
        return null;
    }

    private static CharBuffer newCharBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2 * n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asCharBuffer();
    }

    private void addTileToCache(Tile tile, PlaceNameChunk placeNameChunk) {
        WorldWind.getMemoryCache(Tile.class.getName()).add(tile, placeNameChunk);
    }

    private void downloadTile(Tile tile) {
        Integer n;
        Integer n2;
        URL uRL;
        if (!WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        try {
            uRL = tile.getRequestURL();
            if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionCreatingTextureUrl", tile), malformedURLException);
            return;
        }
        if (!"http".equalsIgnoreCase(uRL.getProtocol())) {
            Logging.logger().severe(Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", uRL.toString()));
            return;
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new DownloadPostProcessor(this, tile));
        Integer n3 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLConnectTimeout");
        if (n3 != null && n3 > 0) {
            hTTPRetriever.setConnectTimeout(n3);
        }
        if ((n2 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLReadTimeout")) != null && n2 > 0) {
            hTTPRetriever.setReadTimeout(n2);
        }
        if ((n = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit")) != null && n > 0) {
            hTTPRetriever.setStaleRequestLimit(n);
        }
        WorldWind.getRetrievalService().runRetriever(hTTPRetriever, tile.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            WWIO.saveBuffer(byteBuffer, file);
        }
    }

    private static class DownloadPostProcessor
    implements RetrievalPostProcessor {
        final PlaceNameLayer layer;
        final Tile tile;

        private DownloadPostProcessor(PlaceNameLayer placeNameLayer, Tile tile) {
            this.layer = placeNameLayer;
            this.tile = tile;
        }

        public ByteBuffer run(Retriever retriever) {
            if (retriever == null) {
                String string = Logging.getMessage("nullValue.RetrieverIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            try {
                Object object;
                if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                    return null;
                }
                URLRetriever uRLRetriever = (URLRetriever)retriever;
                ByteBuffer byteBuffer = uRLRetriever.getBuffer();
                if (retriever instanceof HTTPRetriever) {
                    object = (HTTPRetriever)retriever;
                    if (((HTTPRetriever)object).getResponseCode() == 204) {
                        this.tile.getPlaceNameService().markResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
                        return null;
                    }
                    if (((HTTPRetriever)object).getResponseCode() != 200) {
                        this.tile.getPlaceNameService().markResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
                        return null;
                    }
                }
                if ((object = WorldWind.getDataFileCache().newFile(this.tile.getFileCachePath())) == null) {
                    return null;
                }
                if (((File)object).exists()) {
                    return byteBuffer;
                }
                if (byteBuffer != null) {
                    String string = retriever.getContentType();
                    if (string == null) {
                        return null;
                    }
                    this.layer.saveBuffer(byteBuffer, (File)object);
                    this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    return byteBuffer;
                }
            }
            catch (IOException iOException) {
                this.tile.getPlaceNameService().markResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
                Logging.logger().log(Level.FINE, Logging.getMessage("layers.PlaceNameLayer.ExceptionSavingRetrievedFile", this.tile.getFileCachePath()), iOException);
            }
            return null;
        }
    }

    private static class GMLPlaceNameSAXHandler
    extends DefaultHandler {
        static final String GML_FEATURE_MEMBER = "gml:featureMember";
        static final String TOPP_FULL_NAME_ND = "topp:full_name_nd";
        static final String TOPP_LATITUDE = "topp:latitude";
        static final String TOPP_LONGITUDE = "topp:longitude";
        final LinkedList<String> internedQNameStack = new LinkedList();
        boolean inBeginEndPair = false;
        StringBuilder latBuffer = new StringBuilder();
        StringBuilder lonBuffer = new StringBuilder();
        StringBuilder textArray = new StringBuilder();
        int[] textIndexArray = new int[16];
        double[] latlonArray = new double[16];
        int numEntries = 0;

        GMLPlaceNameSAXHandler() {
        }

        PlaceNameChunk createPlaceNameChunk(PlaceNameService placeNameService) {
            int n = this.textArray.length();
            CharBuffer charBuffer = PlaceNameLayer.newCharBuffer(n);
            charBuffer.put(this.textArray.toString());
            charBuffer.rewind();
            return new PlaceNameChunk(placeNameService, charBuffer, this.textIndexArray, this.latlonArray, this.numEntries);
        }

        void beginEntry() {
            int n = this.textArray.length();
            this.textIndexArray = this.append(this.textIndexArray, this.numEntries, n);
            this.inBeginEndPair = true;
        }

        void endEntry() {
            double d = this.parseDouble(this.latBuffer);
            double d2 = this.parseDouble(this.lonBuffer);
            int n = 2 * this.numEntries;
            this.latlonArray = this.append(this.latlonArray, n, d);
            this.latlonArray = this.append(this.latlonArray, ++n, d2);
            this.latBuffer.delete(0, this.latBuffer.length());
            this.lonBuffer.delete(0, this.lonBuffer.length());
            this.inBeginEndPair = false;
            ++this.numEntries;
        }

        double parseDouble(StringBuilder stringBuilder) {
            double d = 0.0;
            try {
                d = Double.parseDouble(stringBuilder.toString());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.logger().log(Level.FINE, Logging.getMessage("layers.PlaceNameLayer.ExceptionAttemptingToReadFile", ""), numberFormatException);
            }
            return d;
        }

        int[] append(int[] nArray, int n, int n2) {
            if (n >= nArray.length) {
                nArray = this.resizeArray(nArray);
            }
            nArray[n] = n2;
            return nArray;
        }

        int[] resizeArray(int[] nArray) {
            int n = 2 * nArray.length;
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }

        double[] append(double[] dArray, int n, double d) {
            if (n >= dArray.length) {
                dArray = this.resizeArray(dArray);
            }
            dArray[n] = d;
            return dArray;
        }

        double[] resizeArray(double[] dArray) {
            int n = 2 * dArray.length;
            double[] dArray2 = new double[n];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            return dArray2;
        }

        public void characters(char[] cArray, int n, int n2) {
            if (!this.inBeginEndPair) {
                return;
            }
            String string = this.internedQNameStack.getFirst();
            StringBuilder stringBuilder = null;
            if (TOPP_LATITUDE == string) {
                stringBuilder = this.latBuffer;
            } else if (TOPP_LONGITUDE == string) {
                stringBuilder = this.lonBuffer;
            } else if (TOPP_FULL_NAME_ND == string) {
                stringBuilder = this.textArray;
            }
            if (stringBuilder != null) {
                stringBuilder.append(cArray, n, n2);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            String string4 = string3.intern();
            if (GML_FEATURE_MEMBER == string4) {
                this.beginEntry();
            }
            this.internedQNameStack.addFirst(string4);
        }

        public void endElement(String string, String string2, String string3) {
            String string4 = string3.intern();
            if (GML_FEATURE_MEMBER == string4) {
                this.endEntry();
            }
            this.internedQNameStack.removeFirst();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestTask
    implements Runnable,
    Comparable<RequestTask> {
        private final PlaceNameLayer layer;
        private final Tile tile;

        RequestTask(Tile tile, PlaceNameLayer placeNameLayer) {
            this.layer = placeNameLayer;
            this.tile = tile;
        }

        @Override
        public void run() {
            if (this.tile.isTileInMemory()) {
                return;
            }
            URL uRL = WorldWind.getDataFileCache().findFile(this.tile.getFileCachePath(), false);
            if (uRL != null) {
                if (this.layer.loadTile(this.tile, uRL)) {
                    this.tile.getPlaceNameService().unmarkResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
                    this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    return;
                }
                WorldWind.getDataFileCache().removeFile(uRL);
                this.tile.getPlaceNameService().markResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
                String string = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string);
            }
            this.layer.downloadTile(this.tile);
        }

        @Override
        public int compareTo(RequestTask requestTask) {
            if (requestTask == null) {
                String string = Logging.getMessage("nullValue.RequestTaskIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.tile.getPriority() == requestTask.tile.getPriority() ? 0 : (this.tile.getPriority() < requestTask.tile.getPriority() ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tile == null ? requestTask.tile != null : !this.tile.equals(requestTask.tile));
        }

        public int hashCode() {
            return this.tile != null ? this.tile.hashCode() : 0;
        }

        public String toString() {
            return this.tile.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlaceNameChunk
    implements Cacheable {
        final PlaceNameService placeNameService;
        final CharBuffer textArray;
        final int[] textIndexArray;
        final double[] latlonArray;
        final int numEntries;
        final long estimatedMemorySize;

        PlaceNameChunk(PlaceNameService placeNameService, CharBuffer charBuffer, int[] nArray, double[] dArray, int n) {
            this.placeNameService = placeNameService;
            this.textArray = charBuffer;
            this.textIndexArray = nArray;
            this.latlonArray = dArray;
            this.numEntries = n;
            this.estimatedMemorySize = this.computeEstimatedMemorySize();
        }

        long computeEstimatedMemorySize() {
            long l = 0L;
            if (!this.textArray.isDirect()) {
                l += (long)(2 * this.textArray.capacity());
            }
            l += (long)(4 * this.textIndexArray.length);
            return l += (long)(8 * this.latlonArray.length);
        }

        Position getPosition(int n) {
            int n2 = 2 * n;
            return Position.fromDegrees(this.latlonArray[n2], this.latlonArray[n2 + 1], 0.0);
        }

        PlaceNameService getPlaceNameService() {
            return this.placeNameService;
        }

        CharSequence getText(int n) {
            int n2 = this.textIndexArray[n];
            int n3 = n + 1 < this.numEntries ? this.textIndexArray[n + 1] : this.textArray.length();
            return this.textArray.subSequence(n2, n3);
        }

        @Override
        public long getSizeInBytes() {
            return this.estimatedMemorySize;
        }

        private Iterable<GeographicText> makeIterable(DrawContext drawContext) {
            ArrayList<GeographicText> arrayList = new ArrayList<GeographicText>();
            for (int i = 0; i < this.numEntries; ++i) {
                CharSequence charSequence = this.getText(i);
                Position position = this.getPosition(i);
                UserFacingText userFacingText = new UserFacingText(charSequence, position);
                userFacingText.setFont(this.placeNameService.getFont());
                userFacingText.setColor(this.placeNameService.getColor());
                userFacingText.setBackgroundColor(this.placeNameService.getBackgroundColor());
                userFacingText.setVisible(PlaceNameLayer.isNameVisible(drawContext, this.placeNameService, position));
                arrayList.add(userFacingText);
            }
            return arrayList;
        }
    }

    private static class Tile {
        final PlaceNameService placeNameService;
        final Sector sector;
        final int row;
        final int column;
        final int hash;
        String fileCachePath = null;
        Extent extent = null;
        double extentVerticalExaggeration = Double.MIN_VALUE;
        private Vec4 centroid;
        private double priority = Double.MAX_VALUE;

        static int computeRow(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return (int)((angle2.getDegrees() + 90.0) / angle.getDegrees());
        }

        static int computeColumn(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return (int)((angle2.getDegrees() + 180.0) / angle.getDegrees());
        }

        static Angle computeRowLatitude(int n, Angle angle) {
            if (angle == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return Angle.fromDegrees(-90.0 + angle.getDegrees() * (double)n);
        }

        static Angle computeColumnLongitude(int n, Angle angle) {
            if (angle == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return Angle.fromDegrees(-180.0 + angle.getDegrees() * (double)n);
        }

        Tile(PlaceNameService placeNameService, Sector sector, int n, int n2) {
            this.placeNameService = placeNameService;
            this.sector = sector;
            this.row = n;
            this.column = n2;
            this.hash = this.computeHash();
        }

        int computeHash() {
            return this.getFileCachePath() != null ? this.getFileCachePath().hashCode() : 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Tile tile = (Tile)object;
            return !(this.getFileCachePath() == null ? tile.getFileCachePath() != null : !this.getFileCachePath().equals(tile.getFileCachePath()));
        }

        Extent getExtent(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            if (this.extent == null || this.extentVerticalExaggeration != drawContext.getVerticalExaggeration()) {
                this.extentVerticalExaggeration = drawContext.getVerticalExaggeration();
                this.extent = drawContext.getGlobe().computeBoundingCylinder(this.extentVerticalExaggeration, this.sector);
            }
            return this.extent;
        }

        String getFileCachePath() {
            if (this.fileCachePath == null) {
                this.fileCachePath = this.placeNameService.createFileCachePathFromTile(this.row, this.column);
            }
            return this.fileCachePath;
        }

        PlaceNameService getPlaceNameService() {
            return this.placeNameService;
        }

        URL getRequestURL() throws MalformedURLException {
            return this.placeNameService.createServiceURLFromSector(this.sector);
        }

        Sector getSector() {
            return this.sector;
        }

        public int hashCode() {
            return this.hash;
        }

        boolean isTileInMemory() {
            return WorldWind.getMemoryCache(Tile.class.getName()).getObject(this) != null;
        }

        PlaceNameChunk getData() {
            return (PlaceNameChunk)WorldWind.getMemoryCache(Tile.class.getName()).getObject(this);
        }

        public Vec4 getCentroidPoint(Globe globe) {
            if (globe == null) {
                String string = Logging.getMessage("nullValue.GlobeIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (this.centroid == null) {
                LatLon latLon = this.getSector().getCentroid();
                this.centroid = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
            }
            return this.centroid;
        }

        public double getPriority() {
            return this.priority;
        }

        public void setPriority(double d) {
            this.priority = d;
        }
    }
}

