/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class SkyGradientLayer
extends AbstractLayer {
    private static final int STACKS = 12;
    private static final int SLICES = 64;
    protected int glListId = -1;
    protected double thickness = 100000.0;
    protected float[] horizonColor = new float[]{0.66f, 0.7f, 0.81f, 1.0f};
    protected float[] zenithColor = new float[]{0.26f, 0.47f, 0.83f, 1.0f};
    protected double lastRebuildHorizon = 0.0;

    public SkyGradientLayer() {
        this.setName(Logging.getMessage("layers.Earth.SkyGradientLayer.Name"));
    }

    public double getAtmosphereThickness() {
        return this.thickness;
    }

    public void setAtmosphereThickness(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.thickness = d;
    }

    public Color getHorizonColor() {
        return new Color(this.horizonColor[0], this.horizonColor[1], this.horizonColor[2], this.horizonColor[3]);
    }

    public void setHorizonColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        color.getColorComponents(this.horizonColor);
    }

    public Color getZenithColor() {
        return new Color(this.zenithColor[0], this.zenithColor[1], this.zenithColor[2], this.zenithColor[3]);
    }

    public void setZenithColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        color.getColorComponents(this.zenithColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRender(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            double d;
            View view = drawContext.getView();
            Position position = drawContext.getGlobe().computePositionFromPoint(view.getEyePoint());
            double d2 = drawContext.getGlobe().getRadiusAt(position.getLatLon());
            double d3 = view.getEyePoint().getLength3();
            double d4 = position.getElevation();
            double d5 = d = view.computeHorizonDistance();
            double d6 = (-1.5707963267948966 + Math.acos(d / d3)) * 180.0 / Math.PI;
            double d7 = 90.0;
            if (d4 >= this.thickness) {
                double d8 = Math.sqrt(d3 * d3 - (d2 + this.thickness) * (d2 + this.thickness));
                d7 = (-1.5707963267948966 + Math.acos(d8 / d3)) * 180.0 / Math.PI;
            }
            if (d4 < this.thickness && d4 > this.thickness * 0.7) {
                d7 = (this.thickness - d4) / (this.thickness - this.thickness * 0.7) * 90.0;
            }
            if (this.glListId == -1 || Math.abs(this.lastRebuildHorizon - d) > 100.0) {
                if (this.glListId != -1) {
                    gL.glDeleteLists(this.glListId, 1);
                }
                this.makeSkyDome(drawContext, (float)d5, d6, d7, 64, 12);
                this.lastRebuildHorizon = d;
            }
            gL.glPushAttrib(8);
            gL.glPopAttrib();
            gL.glPushAttrib(291081);
            bl = true;
            gL.glDisable(3553);
            gL.glDisable(2929);
            gL.glDepthMask(false);
            Matrix matrix = Matrix.fromPerspective(view.getFieldOfView(), view.getViewport().getWidth(), view.getViewport().getHeight(), 100.0, d5 + 10000.0);
            double[] dArray = new double[16];
            matrix.toArray(dArray, 0, false);
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadMatrixd(dArray, 0);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            Vec4 vec4 = view.getEyePoint();
            Vec4 vec42 = SkyGradientLayer.CartesianToSpherical(vec4.x, vec4.y, vec4.z);
            gL.glRotatef((float)Angle.fromRadians((double)vec42.z).degrees, 0.0f, 1.0f, 0.0f);
            gL.glRotatef((float)(-Angle.fromRadians((double)vec42.y).degrees + 90.0), 1.0f, 0.0f, 0.0f);
            gL.glTranslatef(0.0f, (float)(d3 - 4000.0), 0.0f);
            if (this.glListId != -1) {
                gL.glCallList(this.glListId);
            }
        }
        finally {
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private void makeSkyDome(DrawContext drawContext, float f, double d, double d2, int n, int n2) {
        GL gL = drawContext.getGL();
        this.glListId = gL.glGenLists(1);
        gL.glNewList(this.glListId, 4864);
        this.drawSkyGradient(drawContext, f, d, d2, n, n2);
        gL.glEndList();
    }

    private void drawSkyGradient(DrawContext drawContext, float f, double d, double d2, int n, int n2) {
        double d3;
        int n3;
        double d4 = d2;
        GL gL = drawContext.getGL();
        gL.glBlendFunc(770, 771);
        gL.glEnable(3042);
        gL.glDisable(3553);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d - Math.max((d2 - d) / 4.0, 2.0);
        gL.glBegin(8);
        for (n3 = 0; n3 <= n; ++n3) {
            d3 = 180.0f - (float)n3 / (float)n * 360.0f;
            Vec4 vec4 = SkyGradientLayer.SphericalToCartesian(d8, d3, f);
            gL.glColor4d(this.zenithColor[0], this.zenithColor[1], this.zenithColor[2], 0.0);
            gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
            vec4 = SkyGradientLayer.SphericalToCartesian(d, d3, f);
            gL.glColor4d(this.horizonColor[0], this.horizonColor[1], this.horizonColor[2], 0.9 * (double)this.horizonColor[3]);
            gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
        }
        gL.glEnd();
        for (n3 = 1; n3 < n2 - 1; ++n3) {
            double d9 = (float)(n3 - 1) / ((float)n2 - 1.0f);
            double d10 = 1.0 - Math.cos(d9 * Math.PI / 2.0);
            d8 = d + Math.pow(d10, 3.0) * (d2 - d);
            double d11 = d9;
            double d12 = 1.0 - d11;
            double d13 = 1.0 - Math.pow(d9, 4.0);
            if (d13 > 0.9) {
                d13 = 0.9f;
            }
            double d14 = (float)n3 / ((float)n2 - 1.0f);
            double d15 = 1.0 - Math.cos(d14 * Math.PI / 2.0);
            d4 = d + Math.pow(d15, 3.0) * (d2 - d);
            d5 = d14;
            d6 = 1.0 - d5;
            d7 = 1.0 - Math.pow(d14, 4.0);
            if (d7 > 0.9) {
                d7 = 0.9f;
            }
            gL.glBegin(8);
            for (int i = 0; i <= n; ++i) {
                d3 = 180.0f - (float)i / (float)n * 360.0f;
                Vec4 vec4 = SkyGradientLayer.SphericalToCartesian(d8, d3, f);
                gL.glColor4d((double)this.horizonColor[0] * d12 + (double)this.zenithColor[0] * d11, (double)this.horizonColor[1] * d12 + (double)this.zenithColor[1] * d11, (double)this.horizonColor[2] * d12 + (double)this.zenithColor[2] * d11, ((double)this.horizonColor[3] * d12 + (double)this.zenithColor[3] * d11) * d13);
                gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
                vec4 = SkyGradientLayer.SphericalToCartesian(d4, d3, f);
                gL.glColor4d((double)this.horizonColor[0] * d6 + (double)this.zenithColor[0] * d5, (double)this.horizonColor[1] * d6 + (double)this.zenithColor[1] * d5, (double)this.horizonColor[2] * d6 + (double)this.zenithColor[2] * d5, ((double)this.horizonColor[3] * d6 + (double)this.zenithColor[3] * d5) * d7);
                gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
            }
            gL.glEnd();
        }
        if (d2 < 90.0) {
            gL.glBegin(8);
            for (n3 = 0; n3 <= n; ++n3) {
                d3 = 180.0f - (float)n3 / (float)n * 360.0f;
                Vec4 vec4 = SkyGradientLayer.SphericalToCartesian(d4, d3, f);
                gL.glColor4d((double)this.horizonColor[0] * d6 + (double)this.zenithColor[0] * d5, (double)this.horizonColor[1] * d6 + (double)this.zenithColor[1] * d5, (double)this.horizonColor[2] * d6 + (double)this.zenithColor[2] * d5, ((double)this.horizonColor[3] * d6 + (double)this.zenithColor[3] * d5) * d7);
                gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
                vec4 = SkyGradientLayer.SphericalToCartesian(d2, d3, f);
                gL.glColor4d(this.zenithColor[0], this.zenithColor[1], this.zenithColor[2], 0.0);
                gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
            }
            gL.glEnd();
        }
        gL.glEnable(3553);
        gL.glDisable(3042);
    }

    private static Vec4 SphericalToCartesian(double d, double d2, double d3) {
        double d4 = d3 * Math.cos(d *= Math.PI / 180);
        return new Vec4(d4 * Math.sin(d2 *= Math.PI / 180), d3 * Math.sin(d), d4 * Math.cos(d2));
    }

    private static Vec4 CartesianToSpherical(double d, double d2, double d3) {
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d5 = Math.atan2(d, d3);
        double d6 = Math.asin(d2 / d4);
        return new Vec4(d4, d6, d5);
    }

    public void dispose() {
        if (this.glListId < 0) {
            return;
        }
        GLContext gLContext = GLContext.getCurrent();
        if (gLContext == null) {
            return;
        }
        gLContext.getGL().glDeleteLists(this.glListId, 1);
        this.glListId = -1;
    }

    public String toString() {
        return this.getName();
    }
}

