/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.Earth.GraticuleRenderingParams;
import gov.nasa.worldwind.layers.Earth.GraticuleSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Map;

public class UTMGraticuleLayer
extends AbstractLayer {
    public static final String GRATICULE_UTM = "Graticule.UTM";
    public static final String LINE_STYLE_SOLID = "LineStyleSolid";
    public static final String LINE_STYLE_DASHED = "LineStyleDashed";
    public static final String LINE_STYLE_DOTTED = "LineStyleDotted";
    private static final int[][] specialMeridians = new int[][]{{3, 56, 64}, {6, 64, 72}, {9, 72, 84}, {21, 72, 84}, {33, 72, 84}};
    private static final String latBands = "CDEFGHJKLMNPQRSTUVWX";
    private ArrayList<GridElement> gridElements;
    private GraticuleSupport graticuleSupport = new GraticuleSupport();

    public UTMGraticuleLayer() {
        this.createUTMRenderables();
        this.initRenderingParams();
        this.setPickEnabled(false);
        this.setName(Logging.getMessage("layers.Earth.UTMGraticule.Name"));
    }

    public boolean isDrawGraticule() {
        return this.getUTMRenderingParams().isDrawLines();
    }

    public void setDrawGraticule(boolean bl) {
        this.getUTMRenderingParams().setDrawLines(bl);
    }

    public Color getGraticuleLineColor() {
        return this.getUTMRenderingParams().getLineColor();
    }

    public void setGraticuleLineColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getUTMRenderingParams().setLineColor(color);
    }

    public double getGraticuleLineWidth() {
        return this.getUTMRenderingParams().getLineWidth();
    }

    public void setGraticuleLineWidth(double d) {
        this.getUTMRenderingParams().setLineWidth(d);
    }

    public String getGraticuleLineStyle() {
        return this.getUTMRenderingParams().getLineStyle();
    }

    public void setGraticuleLineStyle(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getUTMRenderingParams().setLineStyle(string);
    }

    public boolean isDrawLabels() {
        return this.getUTMRenderingParams().isDrawLabels();
    }

    public void setDrawLabels(boolean bl) {
        this.getUTMRenderingParams().setDrawLabels(bl);
    }

    public Color getLabelColor() {
        return this.getUTMRenderingParams().getLabelColor();
    }

    public void setLabelColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getUTMRenderingParams().setLabelColor(color);
    }

    public Font getLabelFont() {
        return this.getUTMRenderingParams().getLabelFont();
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getUTMRenderingParams().setLabelFont(font);
    }

    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        RestorableSupport.StateObject stateObject = restorableSupport.addStateObject("renderingParams");
        for (Map.Entry<String, GraticuleRenderingParams> entry : this.graticuleSupport.getAllRenderingParams()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, entry.getKey());
            UTMGraticuleLayer.makeRestorableState(entry.getValue(), restorableSupport, stateObject2);
        }
        return restorableSupport.getStateAsXml();
    }

    private static void makeRestorableState(AVList aVList, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (aVList != null && restorableSupport != null) {
            for (Map.Entry<String, Object> entry : aVList.getEntries()) {
                if (entry.getValue() instanceof Color) {
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Red", ((Color)entry.getValue()).getRed());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Green", ((Color)entry.getValue()).getGreen());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Blue", ((Color)entry.getValue()).getBlue());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Alpha", ((Color)entry.getValue()).getAlpha());
                    continue;
                }
                if (entry.getValue() instanceof Font) {
                    restorableSupport.addStateValueAsString(stateObject, entry.getKey() + ".Name", ((Font)entry.getValue()).getName());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Style", ((Font)entry.getValue()).getStyle());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Size", ((Font)entry.getValue()).getSize());
                    continue;
                }
                restorableSupport.addStateValueAsString(stateObject, entry.getKey(), entry.getValue().toString());
            }
        }
    }

    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("renderingParams");
        if (stateObject != null) {
            RestorableSupport.StateObject[] stateObjectArray;
            for (RestorableSupport.StateObject stateObject2 : stateObjectArray = restorableSupport.getAllStateObjects(stateObject)) {
                if (stateObject2 == null) continue;
                GraticuleRenderingParams graticuleRenderingParams = this.getRenderingParams(stateObject2.getName());
                if (graticuleRenderingParams == null) {
                    graticuleRenderingParams = new GraticuleRenderingParams();
                }
                UTMGraticuleLayer.restorableStateToParams(graticuleRenderingParams, restorableSupport, stateObject2);
                this.setRenderingParams(stateObject2.getName(), graticuleRenderingParams);
            }
        }
    }

    private static void restorableStateToParams(AVList aVList, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (aVList != null && restorableSupport != null) {
            String string;
            Double d;
            Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "DrawGraticule");
            if (bl != null) {
                aVList.setValue("DrawGraticule", bl);
            }
            Integer n = restorableSupport.getStateValueAsInteger(stateObject, "GraticuleLineColor.Red");
            Integer n2 = restorableSupport.getStateValueAsInteger(stateObject, "GraticuleLineColor.Green");
            Integer n3 = restorableSupport.getStateValueAsInteger(stateObject, "GraticuleLineColor.Blue");
            Integer n4 = restorableSupport.getStateValueAsInteger(stateObject, "GraticuleLineColor.Alpha");
            if (n != null && n2 != null && n3 != null && n4 != null) {
                aVList.setValue("GraticuleLineColor", new Color(n, n2, n3, n4));
            }
            if ((d = restorableSupport.getStateValueAsDouble(stateObject, "GraticuleLineWidth")) != null) {
                aVList.setValue("GraticuleLineWidth", d);
            }
            if ((string = restorableSupport.getStateValueAsString(stateObject, "GraticuleLineStyle")) != null) {
                aVList.setValue("GraticuleLineStyle", string);
            }
            if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "DrawLabels")) != null) {
                aVList.setValue("DrawLabels", bl);
            }
            n = restorableSupport.getStateValueAsInteger(stateObject, "LabelColor.Red");
            n2 = restorableSupport.getStateValueAsInteger(stateObject, "LabelColor.Green");
            n3 = restorableSupport.getStateValueAsInteger(stateObject, "LabelColor.Blue");
            n4 = restorableSupport.getStateValueAsInteger(stateObject, "LabelColor.Alpha");
            if (n != null && n2 != null && n3 != null && n4 != null) {
                aVList.setValue("LabelColor", new Color(n, n2, n3, n4));
            }
            String string2 = restorableSupport.getStateValueAsString(stateObject, "LabelFont.Name");
            Integer n5 = restorableSupport.getStateValueAsInteger(stateObject, "LabelFont.Style");
            Integer n6 = restorableSupport.getStateValueAsInteger(stateObject, "LabelFont.Size");
            if (string2 != null && n5 != null && n6 != null) {
                aVList.setValue("LabelFont", new Font(string2, (int)n5, n6));
            }
        }
    }

    private void initRenderingParams() {
        GraticuleRenderingParams graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0.8f, 0.8f, 0.8f, 0.5f));
        graticuleRenderingParams.setValue("LabelColor", new Color(1.0f, 1.0f, 1.0f, 0.8f));
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-14"));
        graticuleRenderingParams.setValue("DrawLabels", Boolean.TRUE);
        this.setRenderingParams(GRATICULE_UTM, graticuleRenderingParams);
    }

    private GraticuleRenderingParams getUTMRenderingParams() {
        return this.graticuleSupport.getRenderingParams(GRATICULE_UTM);
    }

    protected GraticuleRenderingParams getRenderingParams(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.graticuleSupport.getRenderingParams(string);
    }

    protected void setRenderingParams(String string, GraticuleRenderingParams graticuleRenderingParams) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.graticuleSupport.setRenderingParams(string, graticuleRenderingParams);
    }

    protected void addRenderable(Object object, String string) {
        if (object == null) {
            String string2 = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.graticuleSupport.addRenderable(object, string);
    }

    protected void removeAllRenderables() {
        this.graticuleSupport.removeAllRenderables();
    }

    public void doRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.removeAllRenderables();
        this.selectUTMRenderables(drawContext);
        this.renderGraticule(drawContext);
    }

    protected void renderGraticule(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.graticuleSupport.render(drawContext);
    }

    protected void selectUTMRenderables(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = drawContext.getVisibleSector();
        OrbitView orbitView = (OrbitView)drawContext.getView();
        Position position = orbitView.getCenterPosition();
        Double d = Angle.fromRadians((double)(orbitView.computePixelSizeAtDistance((double)orbitView.getZoom()) / drawContext.getGlobe().getEquatorialRadius())).degrees;
        Double d2 = d * orbitView.getViewport().getWidth() / 4.0;
        Position position2 = Position.fromDegrees(position.getLatitude().degrees - d2, position.getLongitude().degrees - d2, 0.0);
        Double d3 = position2.getLatitude().normalizedLatitude().degrees;
        d3 = Math.min(Math.max(d3, -76.0), 78.0);
        position2 = new Position(Angle.fromDegrees(d3), position2.getLongitude().normalizedLongitude(), 0.0);
        int n = 0;
        if (sector != null) {
            for (GridElement gridElement : this.gridElements) {
                if (!gridElement.isInView(drawContext)) continue;
                if (gridElement.renderable instanceof GeographicText) {
                    GeographicText geographicText = (GeographicText)gridElement.renderable;
                    if (position2.getLatitude().degrees < 72.0 || "*32*34*36*".indexOf("*" + geographicText.getText() + "*") == -1) {
                        Position position3 = geographicText.getPosition();
                        if (gridElement.type.equals("GridElement_LatitudeLabel")) {
                            position3 = Position.fromDegrees(position3.getLatitude().degrees, position2.getLongitude().degrees, position3.getElevation());
                        } else if (gridElement.type.equals("GridElement_LongitudeLabel")) {
                            position3 = Position.fromDegrees(position2.getLatitude().degrees, position3.getLongitude().degrees, position3.getElevation());
                        }
                        geographicText.setPosition(position3);
                    }
                }
                this.graticuleSupport.addRenderable(gridElement.renderable, GRATICULE_UTM);
                ++n;
            }
        }
    }

    private void createUTMRenderables() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        this.gridElements = new ArrayList();
        ArrayList<Position> arrayList = new ArrayList<Position>();
        int n2 = -180;
        int n3 = 1;
        int n4 = 84;
        for (n = 0; n < 60; ++n) {
            object4 = Angle.fromDegrees(n2);
            arrayList.clear();
            arrayList.add(new Position(Angle.fromDegrees(-80.0), (Angle)object4, 10000.0));
            arrayList.add(new Position(Angle.fromDegrees(-60.0), (Angle)object4, 10000.0));
            arrayList.add(new Position(Angle.fromDegrees(-30.0), (Angle)object4, 10000.0));
            arrayList.add(new Position(Angle.ZERO, (Angle)object4, 10000.0));
            arrayList.add(new Position(Angle.fromDegrees(30.0), (Angle)object4, 10000.0));
            if (n2 < 6 || n2 > 36) {
                n4 = 84;
                arrayList.add(new Position(Angle.fromDegrees(60.0), (Angle)object4, 10000.0));
                arrayList.add(new Position(Angle.fromDegrees(n4), (Angle)object4, 10000.0));
            } else if (n2 == 6) {
                n4 = 56;
                arrayList.add(new Position(Angle.fromDegrees(n4), (Angle)object4, 10000.0));
            } else {
                n4 = 72;
                arrayList.add(new Position(Angle.fromDegrees(60.0), (Angle)object4, 10000.0));
                arrayList.add(new Position(Angle.fromDegrees(n4), (Angle)object4, 10000.0));
            }
            object3 = new Polyline(arrayList);
            ((Polyline)object3).setPathType(0);
            ((Polyline)object3).setFollowTerrain(true);
            ((Polyline)object3).setTerrainConformance(50.0);
            object2 = Sector.fromDegrees(-80.0, n4, n2, n2);
            this.gridElements.add(new GridElement((Sector)object2, object3, "GridElement_Line"));
            object = new UserFacingText(n3 + "", Position.fromDegrees(0.0, n2 + 3, 0.0));
            object2 = Sector.fromDegrees(-90.0, 90.0, n2 + 3, n2 + 3);
            this.gridElements.add(new GridElement((Sector)object2, object, "GridElement_LongitudeLabel"));
            n2 += 6;
            ++n3;
        }
        for (n = 0; n < 5; ++n) {
            arrayList.clear();
            n2 = specialMeridians[n][0];
            arrayList.add(new Position(Angle.fromDegrees(specialMeridians[n][1]), Angle.fromDegrees(n2), 10000.0));
            arrayList.add(new Position(Angle.fromDegrees(specialMeridians[n][2]), Angle.fromDegrees(n2), 10000.0));
            object4 = new Polyline(arrayList);
            ((Polyline)object4).setPathType(0);
            ((Polyline)object4).setFollowTerrain(true);
            ((Polyline)object4).setTerrainConformance(50.0);
            object3 = Sector.fromDegrees(specialMeridians[n][1], specialMeridians[n][2], n2, n2);
            this.gridElements.add(new GridElement((Sector)object3, object4, "GridElement_Line"));
        }
        n = -80;
        for (int i = 0; i < 21; ++i) {
            object3 = Angle.fromDegrees(n);
            arrayList.clear();
            arrayList.add(new Position((Angle)object3, Angle.NEG180, 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.fromDegrees(-150.0), 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.fromDegrees(-120.0), 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.NEG90, 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.fromDegrees(-60.0), 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.fromDegrees(-30.0), 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.ZERO, 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.fromDegrees(30.0), 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.fromDegrees(60.0), 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.POS90, 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.fromDegrees(120.0), 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.fromDegrees(150.0), 10000.0));
            arrayList.add(new Position((Angle)object3, Angle.POS180, 10000.0));
            object2 = new Polyline(arrayList);
            ((Polyline)object2).setPathType(1);
            ((Polyline)object2).setFollowTerrain(true);
            ((Polyline)object2).setTerrainConformance(20.0);
            object = Sector.fromDegrees(n, n, -180.0, 180.0);
            this.gridElements.add(new GridElement((Sector)object, object2, "GridElement_Line"));
            if (i < 20) {
                UserFacingText userFacingText = new UserFacingText(latBands.charAt(i) + "", Position.fromDegrees(n + 4, 0.0, 0.0));
                object = Sector.fromDegrees(n + 4, n + 4, -180.0, 180.0);
                this.gridElements.add(new GridElement((Sector)object, userFacingText, "GridElement_LatitudeLabel"));
            }
            n += n < 72 ? 8 : 12;
        }
    }

    protected class GridElement {
        public static final String TYPE_LINE = "GridElement_Line";
        public static final String TYPE_LINE_NORTH = "GridElement_LineNorth";
        public static final String TYPE_LINE_SOUTH = "GridElement_LineSouth";
        public static final String TYPE_LINE_WEST = "GridElement_LineWest";
        public static final String TYPE_LINE_EAST = "GridElement_LineEast";
        public static final String TYPE_LINE_NORTHING = "GridElement_LineNorthing";
        public static final String TYPE_LINE_EASTING = "GridElement_LineEasting";
        public static final String TYPE_GRIDZONE_LABEL = "GridElement_GridZoneLabel";
        public static final String TYPE_LONGITUDE_LABEL = "GridElement_LongitudeLabel";
        public static final String TYPE_LATITUDE_LABEL = "GridElement_LatitudeLabel";
        protected final Sector sector;
        protected final Object renderable;
        protected final String type;
        protected double value;

        public GridElement(Sector sector, Object object, String string) {
            if (sector == null) {
                String string2 = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (object == null) {
                String string3 = Logging.getMessage("nullValue.ObjectIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            if (string == null) {
                String string4 = Logging.getMessage("nullValue.StringIsNull");
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
            this.sector = sector;
            this.renderable = object;
            this.type = string;
        }

        public void setValue(double d) {
            this.value = d;
        }

        public boolean isInView(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.isInView(drawContext, drawContext.getVisibleSector());
        }

        public boolean isInView(DrawContext drawContext, Sector sector) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (sector == null) {
                String string = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.sector.intersects(sector);
        }
    }
}

