/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameService;
import gov.nasa.worldwind.layers.placename.PlaceNameServiceSet;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;

public class NASAWFSPlaceNameLayer
extends PlaceNameLayer {
    private static final double LEVEL_A = 3.3554432E7;
    private static final double LEVEL_B = 1.6777216E7;
    private static final double LEVEL_C = 8388608.0;
    private static final double LEVEL_D = 4194304.0;
    private static final double LEVEL_F = 1048576.0;
    private static final double LEVEL_G = 524288.0;
    private static final double LEVEL_I = 131072.0;
    private static final double LEVEL_J = 65536.0;
    private static final double LEVEL_K = 32768.0;
    private static final double LEVEL_L = 16384.0;
    private static final double LEVEL_N = 4096.0;
    private static final double LEVEL_O = 2048.0;
    private static final double LEVEL_P = 1024.0;
    private static final LatLon GRID_1x1 = new LatLon(Angle.fromDegrees(180.0), Angle.fromDegrees(360.0));
    private static final LatLon GRID_5x10 = new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0));
    private static final LatLon GRID_10x20 = new LatLon(Angle.fromDegrees(18.0), Angle.fromDegrees(18.0));
    private static final LatLon GRID_20x40 = new LatLon(Angle.fromDegrees(9.0), Angle.fromDegrees(9.0));
    private static final LatLon GRID_40x80 = new LatLon(Angle.fromDegrees(4.0), Angle.fromDegrees(4.0));
    private static final LatLon GRID_80x160 = new LatLon(Angle.fromDegrees(2.0), Angle.fromDegrees(2.0));
    public static final String OCEANS = "topp:wpl_oceans";
    public static final String CONTINENTS = "topp:wpl_continents";
    public static final String WATERBODIES = "topp:wpl_waterbodies";
    public static final String TRENCHESRIDGES = "topp:wpl_trenchesridges";
    public static final String DESERTSPLAINS = "topp:wpl_desertsplains";
    public static final String LAKESRIVERS = "topp:wpl_lakesrivers";
    public static final String MOUNTAINSVALLEYS = "topp:wpl_mountainsvalleys";
    public static final String COUNTRIES = "topp:wpl_countries";
    public static final String GEONET_P_PPC = "topp:wpl_geonet_p_pplc";
    public static final String USCITIESOVER500K = "topp:wpl_uscitiesover500k";
    public static final String USCITIESOVER100K = "topp:wpl_uscitiesover100k";
    public static final String USCITIESOVER50K = "topp:wpl_uscitiesover50k";
    public static final String USCITIESOVER10K = "topp:wpl_uscitiesover10k";
    public static final String USCITIESOVER1K = "topp:wpl_uscitiesover1k";
    public static final String USCITIESOVER0 = "topp:wpl_uscitiesover0";
    public static final String USCITIES0 = "topp:wpl_uscities0";
    public static final String US_ANTHROPOGENIC = "topp:wpl_us_anthropogenic";
    public static final String US_WATER = "topp:wpl_us_water";
    public static final String US_TERRAIN = "topp:wpl_us_terrain";
    public static final String GEONET_A_ADM1 = "topp:wpl_geonet_a_adm1";
    public static final String GEONET_A_ADM2 = "topp:wpl_geonet_a_adm2";
    public static final String GEONET_P_PPLA = "topp:wpl_geonet_p_ppla";
    public static final String GEONET_P_PPL = "topp:wpl_geonet_p_ppl";
    public static final String GEONET_P_PPLC = "topp:wpl_geonet_p_pplC";
    private static final String[] allNameSets = new String[]{"topp:wpl_oceans", "topp:wpl_continents", "topp:wpl_waterbodies", "topp:wpl_trenchesridges", "topp:wpl_desertsplains", "topp:wpl_lakesrivers", "topp:wpl_mountainsvalleys", "topp:wpl_countries", "topp:wpl_geonet_p_pplc", "topp:wpl_uscitiesover500k", "topp:wpl_uscitiesover100k", "topp:wpl_uscitiesover50k", "topp:wpl_uscitiesover10k", "topp:wpl_uscitiesover1k", "topp:wpl_uscitiesover0", "topp:wpl_uscities0", "topp:wpl_us_anthropogenic", "topp:wpl_us_water", "topp:wpl_us_terrain", "topp:wpl_geonet_a_adm1", "topp:wpl_geonet_a_adm2", "topp:wpl_geonet_p_ppla", "topp:wpl_geonet_p_ppl"};
    private static List activeNamesList = Arrays.asList(allNameSets);

    public NASAWFSPlaceNameLayer() {
        super(NASAWFSPlaceNameLayer.makePlaceNameServiceSet());
    }

    public void setPlaceNameSetsVisible(List list) {
        activeNamesList = list;
        NASAWFSPlaceNameLayer.makePlaceNameServiceSet();
    }

    private static PlaceNameServiceSet makePlaceNameServiceSet() {
        PlaceNameService placeNameService;
        PlaceNameServiceSet placeNameServiceSet = new PlaceNameServiceSet();
        placeNameServiceSet.setExpiryTime(new GregorianCalendar(2008, 1, 11).getTimeInMillis());
        Sector sector = Sector.fromDegrees(0.0, 90.0, -180.0, 0.0);
        if (activeNamesList.contains(OCEANS)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", OCEANS, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_1x1, Font.decode("Arial-BOLDITALIC-12"));
            placeNameService.setColor(new Color(200, 200, 200));
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(3.3554432E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(CONTINENTS)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", CONTINENTS, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_1x1, Font.decode("Arial-BOLD-12"));
            placeNameService.setColor(new Color(255, 255, 240));
            placeNameService.setMinDisplayDistance(524288.0);
            placeNameService.setMaxDisplayDistance(3.3554432E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(WATERBODIES)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", WATERBODIES, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_5x10, Font.decode("Arial-ITALIC-10"));
            placeNameService.setColor(Color.cyan);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(1.6777216E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(TRENCHESRIDGES)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", TRENCHESRIDGES, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_5x10, Font.decode("Arial-BOLDITALIC-10"));
            placeNameService.setColor(Color.cyan);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(1.6777216E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(DESERTSPLAINS)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", DESERTSPLAINS, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_5x10, Font.decode("Arial-BOLDITALIC-10"));
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(1.6777216E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(LAKESRIVERS)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", LAKESRIVERS, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_10x20, Font.decode("Arial-ITALIC-10"));
            placeNameService.setColor(Color.cyan);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(8388608.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(MOUNTAINSVALLEYS)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", MOUNTAINSVALLEYS, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_10x20, Font.decode("Arial-BOLDITALIC-10"));
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(8388608.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(COUNTRIES)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", "topp:countries", "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_5x10, Font.decode("Arial-BOLD-10"));
            placeNameService.setColor(Color.white);
            placeNameService.setMinDisplayDistance(524288.0);
            placeNameService.setMaxDisplayDistance(4194304.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_P_PPLC)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", GEONET_P_PPC, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_10x20, Font.decode("Arial-BOLD-10"));
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4194304.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(USCITIESOVER500K)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", USCITIESOVER500K, "Earth/NASA WFS Place Names", sector, GRID_10x20, Font.decode("Arial-BOLD-10"));
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(4096.0);
            placeNameService.setMaxDisplayDistance(4194304.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(USCITIESOVER100K)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", USCITIESOVER100K, "Earth/NASA WFS Place Names", sector, GRID_10x20, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(4096.0);
            placeNameService.setMaxDisplayDistance(1048576.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(USCITIESOVER50K)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", USCITIESOVER50K, "Earth/NASA WFS Place Names", sector, GRID_10x20, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(4096.0);
            placeNameService.setMaxDisplayDistance(131072.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(USCITIESOVER10K)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", USCITIESOVER10K, "Earth/NASA WFS Place Names", sector, GRID_10x20, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(65536.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(USCITIESOVER1K)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", USCITIESOVER1K, "Earth/NASA WFS Place Names", sector, GRID_20x40, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(32768.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(USCITIESOVER0)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", USCITIESOVER0, "Earth/NASA WFS Place Names", sector, GRID_20x40, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(16384.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(USCITIES0)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", USCITIES0, "Earth/NASA WFS Place Names", sector, GRID_40x80, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(US_ANTHROPOGENIC)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", US_ANTHROPOGENIC, "Earth/NASA WFS Place Names", sector, GRID_80x160, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(1024.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(US_WATER)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", US_WATER, "Earth/NASA WFS Place Names", sector, GRID_20x40, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.cyan);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(US_TERRAIN)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", US_TERRAIN, "Earth/NASA WFS Place Names", sector, GRID_20x40, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(2048.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_A_ADM1)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", GEONET_A_ADM1, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_20x40, Font.decode("Arial-BOLD-10"));
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_A_ADM2)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", GEONET_A_ADM2, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_20x40, Font.decode("Arial-BOLD-10"));
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_P_PPLA)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", GEONET_P_PPLA, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_20x40, Font.decode("Arial-BOLD-10"));
            placeNameService.setColor(Color.pink);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_P_PPL)) {
            placeNameService = new PlaceNameService("http://builds.worldwind.arc.nasa.gov/geoserver/wfs", GEONET_P_PPL, "Earth/NASA WFS Place Names", Sector.FULL_SPHERE, GRID_20x40, Font.decode("Arial-PLAIN-10"));
            placeNameService.setColor(Color.pink);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(2048.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        return placeNameServiceSet;
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.PlaceName.Name");
    }
}

