/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class NASAEarthObservatory
extends BasicTiledImageLayer {
    private final String title;

    public NASAEarthObservatory(String string, String string2, String string3) {
        super(NASAEarthObservatory.makeLevels(string, string2, new URLBuilder(string, string2)));
        this.setUseTransparentTextures(false);
        this.title = string3;
    }

    private static LevelSet makeLevels(String string, String string2, URLBuilder uRLBuilder) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/NASAEarthObservatory/" + string + "/" + string2);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://neowms.sci.gsfc.nasa.gov/wms/wms");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 5);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", uRLBuilder);
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return "NEO " + this.title;
    }

    private static class URLBuilder
    implements TileUrlBuilder {
        private final String layerName;
        private final String styleName;

        private URLBuilder(String string, String string2) {
            this.layerName = string;
            this.styleName = string2;
        }

        public URL getURL(Tile tile, String string) throws MalformedURLException {
            StringBuffer stringBuffer = new StringBuffer(tile.getLevel().getService());
            if (stringBuffer.lastIndexOf("?") != stringBuffer.length() - 1) {
                stringBuffer.append("?");
            }
            stringBuffer.append("request=GetMap");
            stringBuffer.append("&version=1.3.0");
            stringBuffer.append("&layers=");
            stringBuffer.append(this.layerName);
            stringBuffer.append("&crs=CRS:84");
            stringBuffer.append("&width=");
            stringBuffer.append(tile.getLevel().getTileWidth());
            stringBuffer.append("&height=");
            stringBuffer.append(tile.getLevel().getTileHeight());
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            stringBuffer.append(sector.getMinLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMinLatitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLatitude().getDegrees());
            stringBuffer.append("&format=image/png");
            stringBuffer.append("&styles=");
            stringBuffer.append(this.styleName);
            return new URL(stringBuffer.toString());
        }
    }
}

