/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.layers.Earth.GraticuleRenderingParams;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.GeographicTextRenderer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraticuleSupport {
    private Collection<Pair> renderables = new ArrayList<Pair>();
    private Map<String, GraticuleRenderingParams> namedParams = new HashMap<String, GraticuleRenderingParams>();
    private AVList defaultParams;
    private GeographicTextRenderer textRenderer = new GeographicTextRenderer();

    public void addRenderable(Object object, String string) {
        if (object == null) {
            String string2 = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.renderables.add(new Pair(object, string));
    }

    public void removeAllRenderables() {
        this.renderables.clear();
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<GeographicText> arrayList = new ArrayList<GeographicText>();
        for (Pair pair : this.renderables) {
            GraticuleRenderingParams graticuleRenderingParams;
            Object object = pair.a;
            String string = pair.b != null && pair.b instanceof String ? (String)pair.b : null;
            GraticuleRenderingParams graticuleRenderingParams2 = graticuleRenderingParams = string != null ? this.namedParams.get(string) : null;
            if (object != null && object instanceof Polyline) {
                if (graticuleRenderingParams != null && !graticuleRenderingParams.isDrawLines()) continue;
                this.applyRenderingParams((AVList)graticuleRenderingParams, (Polyline)object);
                ((Polyline)object).render(drawContext);
                continue;
            }
            if (object == null || !(object instanceof GeographicText) || graticuleRenderingParams != null && !graticuleRenderingParams.isDrawLabels()) continue;
            this.applyRenderingParams((AVList)graticuleRenderingParams, (GeographicText)object);
            arrayList.add((GeographicText)object);
        }
        this.textRenderer.render(drawContext, arrayList);
    }

    public GraticuleRenderingParams getRenderingParams(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        GraticuleRenderingParams graticuleRenderingParams = this.namedParams.get(string);
        if (graticuleRenderingParams == null) {
            graticuleRenderingParams = new GraticuleRenderingParams();
            this.initRenderingParams(graticuleRenderingParams);
            if (this.defaultParams != null) {
                graticuleRenderingParams.setValues(this.defaultParams);
            }
            this.namedParams.put(string, graticuleRenderingParams);
        }
        return graticuleRenderingParams;
    }

    public Collection<Map.Entry<String, GraticuleRenderingParams>> getAllRenderingParams() {
        return this.namedParams.entrySet();
    }

    public void setRenderingParams(String string, GraticuleRenderingParams graticuleRenderingParams) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.initRenderingParams(graticuleRenderingParams);
        this.namedParams.put(string, graticuleRenderingParams);
    }

    public AVList getDefaultParams() {
        return this.defaultParams;
    }

    public void setDefaultParams(AVList aVList) {
        this.defaultParams = aVList;
    }

    private AVList initRenderingParams(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList.getValue("DrawGraticule") == null) {
            aVList.setValue("DrawGraticule", Boolean.TRUE);
        }
        if (aVList.getValue("GraticuleLineColor") == null) {
            aVList.setValue("GraticuleLineColor", Color.WHITE);
        }
        if (aVList.getValue("GraticuleLineWidth") == null) {
            aVList.setValue("GraticuleLineWidth", new Double(1.0));
        }
        if (aVList.getValue("GraticuleLineStyle") == null) {
            aVList.setValue("GraticuleLineStyle", "LineStyleSolid");
        }
        if (aVList.getValue("DrawLabels") == null) {
            aVList.setValue("DrawLabels", Boolean.TRUE);
        }
        if (aVList.getValue("LabelColor") == null) {
            aVList.setValue("LabelColor", Color.WHITE);
        }
        if (aVList.getValue("LabelFont") == null) {
            aVList.setValue("LabelFont", Font.decode("Arial-Bold-12"));
        }
        return aVList;
    }

    private void applyRenderingParams(AVList aVList, Polyline polyline) {
        if (aVList != null && polyline != null) {
            int n;
            String string;
            Double d;
            Object object = aVList.getValue("GraticuleLineColor");
            if (object != null && object instanceof Color) {
                polyline.setColor((Color)object);
            }
            if ((d = AVListImpl.getDoubleValue(aVList, "GraticuleLineWidth")) != null) {
                polyline.setLineWidth(d);
            }
            if ("LineStyleSolid".equalsIgnoreCase(string = aVList.getStringValue("GraticuleLineStyle"))) {
                polyline.setStipplePattern((short)-21846);
                polyline.setStippleFactor(0);
            } else if ("LineStyleDashed".equalsIgnoreCase(string)) {
                n = (int)(d != null ? (double)Math.round(d) : 1.0);
                polyline.setStipplePattern((short)-21846);
                polyline.setStippleFactor(3 * n);
            } else if ("LineStyleDotted".equalsIgnoreCase(string)) {
                n = (int)(d != null ? (double)Math.round(d) : 1.0);
                polyline.setStipplePattern((short)-21846);
                polyline.setStippleFactor(n);
            }
            Double d2 = AVListImpl.getDoubleValue(aVList, "GraticuleLineConformance");
            if (d2 != null) {
                polyline.setTerrainConformance(d2);
            }
        }
    }

    private void applyRenderingParams(AVList aVList, GeographicText geographicText) {
        if (aVList != null && geographicText != null) {
            Object object = aVList.getValue("LabelColor");
            if (object != null && object instanceof Color) {
                Color color = (Color)object;
                float[] fArray = new float[4];
                Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
                int n = fArray[2] < 0.5f ? 255 : 0;
                geographicText.setColor(color);
                geographicText.setBackgroundColor(new Color(n, n, n, color.getAlpha()));
            }
            if ((object = aVList.getValue("LabelFont")) != null && object instanceof Font) {
                geographicText.setFont((Font)object);
            }
        }
    }

    private static class Pair {
        final Object a;
        final Object b;

        Pair(Object object, Object object2) {
            this.a = object;
            this.b = object2;
        }
    }
}

