/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameService;
import gov.nasa.worldwind.layers.placename.PlaceNameServiceSet;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.util.GregorianCalendar;

public class EarthNASAPlaceNameLayer
extends PlaceNameLayer {
    private static final double LEVEL_A = 3.3554432E7;
    private static final double LEVEL_B = 1.6777216E7;
    private static final double LEVEL_C = 8388608.0;
    private static final double LEVEL_D = 4194304.0;
    private static final double LEVEL_F = 1048576.0;
    private static final double LEVEL_G = 524288.0;
    private static final double LEVEL_I = 131072.0;
    private static final double LEVEL_J = 65536.0;
    private static final double LEVEL_K = 32768.0;
    private static final double LEVEL_L = 16384.0;
    private static final double LEVEL_M = 8192.0;
    private static final LatLon GRID_1x1 = new LatLon(Angle.fromDegrees(180.0), Angle.fromDegrees(360.0));
    private static final LatLon GRID_5x10 = new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0));
    private static final LatLon GRID_10x20 = new LatLon(Angle.fromDegrees(18.0), Angle.fromDegrees(18.0));
    private static final LatLon GRID_20x40 = new LatLon(Angle.fromDegrees(9.0), Angle.fromDegrees(9.0));

    public EarthNASAPlaceNameLayer() {
        super(EarthNASAPlaceNameLayer.makePlaceNameServiceSet());
    }

    private static PlaceNameServiceSet makePlaceNameServiceSet() {
        PlaceNameServiceSet placeNameServiceSet = new PlaceNameServiceSet();
        placeNameServiceSet.setExpiryTime(new GregorianCalendar(2008, 1, 11).getTimeInMillis());
        Sector sector = Sector.fromDegrees(0.0, 90.0, -180.0, 0.0);
        PlaceNameService placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_oceans", "Earth/NASA Geoserver Place Names", Sector.FULL_SPHERE, GRID_1x1, Font.decode("Arial-BOLDITALIC-12"));
        placeNameService.setColor(new Color(200, 200, 200));
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(3.3554432E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_continents", "Earth/NASA Geoserver Place Names", Sector.FULL_SPHERE, GRID_1x1, Font.decode("Arial-BOLD-12"));
        placeNameService.setColor(new Color(255, 255, 240));
        placeNameService.setMinDisplayDistance(524288.0);
        placeNameService.setMaxDisplayDistance(3.3554432E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_waterbodies", "Earth/NASA Geoserver Place Names", Sector.FULL_SPHERE, GRID_5x10, Font.decode("Arial-ITALIC-10"));
        placeNameService.setColor(Color.cyan);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(1.6777216E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_trenchesridges", "Earth/NASA Geoserver Place Names", Sector.FULL_SPHERE, GRID_5x10, Font.decode("Arial-BOLDITALIC-10"));
        placeNameService.setColor(Color.cyan);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(1.6777216E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_desertsplains", "Earth/NASA Geoserver Place Names", Sector.FULL_SPHERE, GRID_5x10, Font.decode("Arial-BOLDITALIC-10"));
        placeNameService.setColor(Color.orange);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(1.6777216E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_lakesrivers", "Earth/NASA Geoserver Place Names", Sector.FULL_SPHERE, GRID_10x20, Font.decode("Arial-ITALIC-10"));
        placeNameService.setColor(Color.cyan);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(8388608.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_mountainsvalleys", "Earth/NASA Geoserver Place Names", Sector.FULL_SPHERE, GRID_10x20, Font.decode("Arial-BOLDITALIC-10"));
        placeNameService.setColor(Color.orange);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(8388608.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:countries", "Earth/NASA Geoserver Place Names", Sector.FULL_SPHERE, GRID_5x10, Font.decode("Arial-BOLD-10"));
        placeNameService.setColor(Color.white);
        placeNameService.setMinDisplayDistance(524288.0);
        placeNameService.setMaxDisplayDistance(4194304.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_geonet_p_pplc", "Earth/NASA Geoserver Place Names", Sector.FULL_SPHERE, GRID_10x20, Font.decode("Arial-BOLD-10"));
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(4194304.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover500k", "Earth/NASA Geoserver Place Names", sector, GRID_10x20, Font.decode("Arial-BOLD-10"));
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(4194304.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover100k", "Earth/NASA Geoserver Place Names", sector, GRID_10x20, Font.decode("Arial-PLAIN-10"));
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(1048576.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover50k", "Earth/NASA Geoserver Place Names", sector, GRID_10x20, Font.decode("Arial-PLAIN-10"));
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(131072.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover10k", "Earth/NASA Geoserver Place Names", sector, GRID_10x20, Font.decode("Arial-PLAIN-10"));
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(65536.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover1k", "Earth/NASA Geoserver Place Names", sector, GRID_20x40, Font.decode("Arial-PLAIN-10"));
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(32768.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover0", "Earth/NASA Geoserver Place Names", sector, GRID_20x40, Font.decode("Arial-PLAIN-10"));
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(16384.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscities0", "Earth/NASA Geoserver Place Names", sector, GRID_20x40, Font.decode("Arial-PLAIN-10"));
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(8192.0);
        placeNameServiceSet.addService(placeNameService, false);
        return placeNameServiceSet;
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.PlaceName.Name");
    }
}

