/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.SectorGeometry;
import gov.nasa.worldwind.globes.SectorGeometryList;
import gov.nasa.worldwind.globes.Tessellator;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectangularTessellator
extends WWObjectImpl
implements Tessellator {
    private static final double DEFAULT_LOG10_RESOLUTION_TARGET = 1.3;
    private static final int DEFAULT_MAX_LEVEL = 12;
    private static final int DEFAULT_NUM_LAT_SUBDIVISIONS = 5;
    private static final int DEFAULT_NUM_LON_SUBDIVISIONS = 10;
    private static final int DEFAULT_DENSITY = 20;
    private static final String CACHE_NAME = "Terrain";
    private static final String CACHE_ID = RectangularTessellator.class.getName();
    private static final HashMap<Integer, DoubleBuffer> parameterizations = new HashMap();
    private static final HashMap<Integer, IntBuffer> indexLists = new HashMap();
    private ArrayList<RectTile> topLevels;
    private PickSupport pickSupport = new PickSupport();
    private SectorGeometryList currentTiles = new SectorGeometryList();
    private Frustum currentFrustum;
    private Sector currentCoverage;
    private boolean makeTileSkirts = true;
    private int currentLevel;
    private int maxLevel = 12;
    private Globe globe;
    private int density = 20;

    @Override
    public SectorGeometryList tessellate(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!WorldWind.getMemoryCacheSet().containsCache(CACHE_ID)) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.SectorGeometryCacheSize", 20000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName(CACHE_NAME);
            WorldWind.getMemoryCacheSet().addCache(CACHE_ID, basicMemoryCache);
        }
        if (this.topLevels == null) {
            this.topLevels = this.createTopLevelTiles(drawContext);
        }
        this.currentTiles.clear();
        this.currentLevel = 0;
        this.currentCoverage = null;
        this.currentFrustum = drawContext.getView().getFrustumInModelCoordinates();
        for (SectorGeometry sectorGeometry : this.topLevels) {
            this.selectVisibleTiles(drawContext, (RectTile)sectorGeometry);
        }
        this.currentTiles.setSector(this.currentCoverage);
        for (SectorGeometry sectorGeometry : this.currentTiles) {
            this.makeVerts(drawContext, (RectTile)sectorGeometry);
        }
        return this.currentTiles;
    }

    private ArrayList<RectTile> createTopLevelTiles(DrawContext drawContext) {
        ArrayList<RectTile> arrayList = new ArrayList<RectTile>(50);
        this.globe = drawContext.getGlobe();
        double d = 36.0;
        double d2 = 36.0;
        Angle angle = Angle.NEG90;
        for (int i = 0; i < 5; ++i) {
            Angle angle2 = angle.addDegrees(d);
            if (angle2.getDegrees() + 1.0 > 90.0) {
                angle2 = Angle.POS90;
            }
            Angle angle3 = Angle.NEG180;
            for (int j = 0; j < 10; ++j) {
                Angle angle4 = angle3.addDegrees(d2);
                if (angle4.getDegrees() + 1.0 > 180.0) {
                    angle4 = Angle.POS180;
                }
                Sector sector = new Sector(angle, angle2, angle3, angle4);
                arrayList.add(this.createTile(drawContext, sector, 0));
                angle3 = angle4;
            }
            angle = angle2;
        }
        return arrayList;
    }

    private RectTile createTile(DrawContext drawContext, Sector sector, int n) {
        Cylinder cylinder = drawContext.getGlobe().computeBoundingCylinder(drawContext.getVerticalExaggeration(), sector);
        double d = sector.getDeltaLatRadians() * drawContext.getGlobe().getRadius() / (double)this.density;
        return new RectTile(this, cylinder, n, this.density, sector, d);
    }

    @Override
    public boolean isMakeTileSkirts() {
        return this.makeTileSkirts;
    }

    @Override
    public void setMakeTileSkirts(boolean bl) {
        this.makeTileSkirts = bl;
    }

    public int getTargetResolution(DrawContext drawContext, RectTile rectTile) {
        return drawContext.getGlobe().getElevationModel().getTargetResolution(drawContext, rectTile.sector, rectTile.density);
    }

    private void selectVisibleTiles(DrawContext drawContext, RectTile rectTile) {
        Extent extent = rectTile.getExtent();
        if (extent != null && !extent.intersects(this.currentFrustum)) {
            return;
        }
        if (this.currentLevel < this.maxLevel - 1 && this.needToSplit(drawContext, rectTile)) {
            RectTile[] rectTileArray;
            ++this.currentLevel;
            for (RectTile rectTile2 : rectTileArray = this.split(drawContext, rectTile)) {
                this.selectVisibleTiles(drawContext, rectTile2);
            }
            --this.currentLevel;
            return;
        }
        this.currentCoverage = rectTile.getSector().union(this.currentCoverage);
        this.currentTiles.add(rectTile);
    }

    private boolean needToSplit(DrawContext drawContext, RectTile rectTile) {
        Vec4[] vec4Array = rectTile.sector.computeCornerPoints(drawContext.getGlobe());
        Vec4 vec4 = rectTile.sector.computeCenterPoint(drawContext.getGlobe());
        View view = drawContext.getView();
        double d = view.getEyePoint().distanceTo3(vec4Array[0]);
        double d2 = view.getEyePoint().distanceTo3(vec4Array[1]);
        double d3 = view.getEyePoint().distanceTo3(vec4Array[2]);
        double d4 = view.getEyePoint().distanceTo3(vec4Array[3]);
        double d5 = view.getEyePoint().distanceTo3(vec4);
        double d6 = d;
        if (d2 < d6) {
            d6 = d2;
        }
        if (d3 < d6) {
            d6 = d3;
        }
        if (d4 < d6) {
            d6 = d4;
        }
        if (d5 < d6) {
            d6 = d5;
        }
        double d7 = Math.log10(d6);
        boolean bl = rectTile.log10CellSize <= d7 - 1.3;
        return !bl;
    }

    private RectTile[] split(DrawContext drawContext, RectTile rectTile) {
        Sector[] sectorArray = rectTile.sector.subdivide();
        RectTile[] rectTileArray = new RectTile[]{this.createTile(drawContext, sectorArray[0], rectTile.level + 1), this.createTile(drawContext, sectorArray[1], rectTile.level + 1), this.createTile(drawContext, sectorArray[2], rectTile.level + 1), this.createTile(drawContext, sectorArray[3], rectTile.level + 1)};
        return rectTileArray;
    }

    private CacheKey createCacheKey(DrawContext drawContext, RectTile rectTile, int n) {
        return new CacheKey(drawContext.getGlobe(), rectTile.sector, drawContext.getVerticalExaggeration(), n, rectTile.density);
    }

    private void makeVerts(DrawContext drawContext, RectTile rectTile) {
        int n = this.getTargetResolution(drawContext, rectTile);
        MemoryCache memoryCache = WorldWind.getMemoryCache(CACHE_ID);
        CacheKey cacheKey = this.createCacheKey(drawContext, rectTile, n);
        rectTile.ri = (RenderInfo)memoryCache.getObject(cacheKey);
        if (rectTile.ri != null) {
            return;
        }
        rectTile.ri = this.buildVerts(drawContext, rectTile, n, this.makeTileSkirts);
        if (rectTile.ri != null && rectTile.ri.resolution >= 0) {
            cacheKey = this.createCacheKey(drawContext, rectTile, rectTile.ri.resolution);
            memoryCache.add(cacheKey, rectTile.ri, rectTile.ri.getSizeInBytes());
        }
    }

    public RenderInfo buildVerts(DrawContext drawContext, RectTile rectTile, int n, boolean bl) {
        int n2 = rectTile.density;
        int n3 = (n2 + 3) * (n2 + 3);
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(n3 * 3);
        Globe globe = drawContext.getGlobe();
        ElevationModel.Elevations elevations = globe.getElevationModel().getElevations(rectTile.sector, n);
        Angle angle = rectTile.sector.getMaxLatitude();
        Angle angle2 = rectTile.sector.getDeltaLat().divide(n2);
        Angle angle3 = rectTile.sector.getMinLongitude();
        Angle angle4 = rectTile.sector.getMaxLongitude();
        Angle angle5 = rectTile.sector.getDeltaLon().divide(n2);
        int n4 = 0;
        Angle angle6 = rectTile.sector.getMinLatitude();
        double d = drawContext.getVerticalExaggeration();
        double d2 = bl ? globe.getMinElevation() * d : 0.0;
        LatLon latLon = rectTile.sector.getCentroid();
        Vec4 vec4 = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
        for (int i = 0; i <= n2 + 2; ++i) {
            Angle angle7 = angle3;
            for (int j = 0; j <= n2 + 2; ++j) {
                double d3 = d * elevations.getElevation(angle6.radians, angle7.radians);
                if (i == 0 || i >= rectTile.density + 2 || j == 0 || j >= rectTile.density + 2) {
                    d3 -= d2 >= 0.0 ? d2 : -d2;
                }
                Vec4 vec42 = globe.computePointFromPosition(angle6, angle7, d3);
                doubleBuffer.put(n4++, vec42.x - vec4.x).put(n4++, vec42.y - vec4.y).put(n4++, vec42.z - vec4.z);
                if (j > n2) {
                    angle7 = angle4;
                    continue;
                }
                if (j == 0) continue;
                angle7 = angle7.add(angle5);
            }
            if (i > n2) {
                angle6 = angle;
                continue;
            }
            if (i == 0) continue;
            angle6 = angle6.add(angle2);
        }
        return new RenderInfo(n2, doubleBuffer, RectangularTessellator.getTextureCoordinates(n2), vec4, elevations.getResolution());
    }

    private void renderMultiTexture(DrawContext drawContext, RectTile rectTile, int n) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            String string = Logging.getMessage("generic.NumTextureUnitsLessThanOne");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.render(drawContext, rectTile, n);
    }

    private void render(DrawContext drawContext, RectTile rectTile) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.render(drawContext, rectTile, 1);
    }

    private long render(DrawContext drawContext, RectTile rectTile, int n) {
        if (rectTile.ri == null) {
            String string = Logging.getMessage("nullValue.RenderInfoIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        drawContext.getView().pushReferenceCenter(drawContext, rectTile.ri.referenceCenter);
        GL gL = drawContext.getGL();
        gL.glPushClientAttrib(2);
        gL.glEnableClientState(32884);
        gL.glVertexPointer(3, 5130, 0, rectTile.ri.vertices.rewind());
        for (int i = 0; i < n; ++i) {
            gL.glClientActiveTexture(33984 + i);
            gL.glEnableClientState(32888);
            gL.glTexCoordPointer(2, 5130, 0, rectTile.ri.texCoords.rewind());
        }
        gL.glDrawElements(5, rectTile.ri.indices.limit(), 5125, rectTile.ri.indices.rewind());
        gL.glPopClientAttrib();
        drawContext.getView().popReferenceCenter(drawContext);
        return rectTile.ri.indices.limit() - 2;
    }

    private void renderWireframe(DrawContext drawContext, RectTile rectTile, boolean bl, boolean bl2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectTile.ri == null) {
            String string = Logging.getMessage("nullValue.RenderInfoIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        IntBuffer intBuffer = RectangularTessellator.getIndices(rectTile.ri.density);
        intBuffer.rewind();
        drawContext.getView().pushReferenceCenter(drawContext, rectTile.ri.referenceCenter);
        GL gL = drawContext.getGL();
        gL.glPushAttrib(270601);
        gL.glEnable(3042);
        gL.glBlendFunc(770, 1);
        gL.glDisable(2929);
        gL.glEnable(2884);
        gL.glCullFace(1029);
        gL.glDisable(3553);
        gL.glColor4d(1.0, 1.0, 1.0, 0.2);
        gL.glPolygonMode(1028, 6913);
        if (bl) {
            gL.glPushClientAttrib(2);
            gL.glEnableClientState(32884);
            gL.glVertexPointer(3, 5130, 0, rectTile.ri.vertices);
            gL.glDrawElements(5, intBuffer.limit(), 5125, intBuffer);
            gL.glPopClientAttrib();
        }
        drawContext.getView().popReferenceCenter(drawContext);
        if (bl2) {
            this.renderPatchBoundary(drawContext, rectTile, gL);
        }
        gL.glPopAttrib();
    }

    private void renderPatchBoundary(DrawContext drawContext, RectTile rectTile, GL gL) {
        gL.glColor4d(1.0, 0.0, 0.0, 1.0);
        Vec4[] vec4Array = rectTile.sector.computeCornerPoints(drawContext.getGlobe());
        gL.glBegin(7);
        gL.glVertex3d(vec4Array[0].x, vec4Array[0].y, vec4Array[0].z);
        gL.glVertex3d(vec4Array[1].x, vec4Array[1].y, vec4Array[1].z);
        gL.glVertex3d(vec4Array[2].x, vec4Array[2].y, vec4Array[2].z);
        gL.glVertex3d(vec4Array[3].x, vec4Array[3].y, vec4Array[3].z);
        gL.glEnd();
    }

    private void renderBoundingVolume(DrawContext drawContext, RectTile rectTile) {
        Extent extent = rectTile.getExtent();
        if (extent == null) {
            return;
        }
        if (extent instanceof Cylinder) {
            ((Cylinder)extent).render(drawContext);
        }
    }

    private PickedObject[] pick(DrawContext drawContext, RectTile rectTile, List<Point> list) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list.size() == 0) {
            return null;
        }
        if (rectTile.ri == null) {
            return null;
        }
        PickedObject[] pickedObjectArray = new PickedObject[list.size()];
        this.renderTrianglesWithUniqueColors(drawContext, rectTile);
        for (int i = 0; i < list.size(); ++i) {
            pickedObjectArray[i] = this.resolvePick(drawContext, rectTile, list.get(i));
        }
        return pickedObjectArray;
    }

    private void pick(DrawContext drawContext, RectTile rectTile, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectTile.ri == null) {
            return;
        }
        this.renderTrianglesWithUniqueColors(drawContext, rectTile);
        PickedObject pickedObject = this.resolvePick(drawContext, rectTile, point);
        if (pickedObject != null) {
            drawContext.addPickedObject(pickedObject);
        }
    }

    private void renderTrianglesWithUniqueColors(DrawContext drawContext, RectTile rectTile) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (rectTile.ri.vertices == null) {
            return;
        }
        rectTile.ri.vertices.rewind();
        rectTile.ri.indices.rewind();
        GL gL = drawContext.getGL();
        if (null != rectTile.ri.referenceCenter) {
            drawContext.getView().pushReferenceCenter(drawContext, rectTile.ri.referenceCenter);
        }
        rectTile.minColorCode = drawContext.getUniquePickColor().getRGB();
        int n = rectTile.ri.indices.capacity() - 2;
        gL.glBegin(4);
        for (int i = 0; i < n; ++i) {
            Color color = drawContext.getUniquePickColor();
            gL.glColor3ub((byte)(color.getRed() & 0xFF), (byte)(color.getGreen() & 0xFF), (byte)(color.getBlue() & 0xFF));
            int n2 = 3 * rectTile.ri.indices.get(i);
            gL.glVertex3d(rectTile.ri.vertices.get(n2), rectTile.ri.vertices.get(n2 + 1), rectTile.ri.vertices.get(n2 + 2));
            n2 = 3 * rectTile.ri.indices.get(i + 1);
            gL.glVertex3d(rectTile.ri.vertices.get(n2), rectTile.ri.vertices.get(n2 + 1), rectTile.ri.vertices.get(n2 + 2));
            n2 = 3 * rectTile.ri.indices.get(i + 2);
            gL.glVertex3d(rectTile.ri.vertices.get(n2), rectTile.ri.vertices.get(n2 + 1), rectTile.ri.vertices.get(n2 + 2));
        }
        gL.glEnd();
        rectTile.maxColorCode = drawContext.getUniquePickColor().getRGB();
        if (null != rectTile.ri.referenceCenter) {
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    private PickedObject resolvePick(DrawContext drawContext, RectTile rectTile, Point point) {
        int n = this.pickSupport.getTopColor(drawContext, point);
        if (n < rectTile.minColorCode || n > rectTile.maxColorCode) {
            return null;
        }
        double d = 1.0E-5f;
        int n2 = n - rectTile.minColorCode - 1;
        if (rectTile.ri.indices == null || n2 >= rectTile.ri.indices.capacity() - 2) {
            return null;
        }
        double d2 = ((RenderInfo)((RectTile)rectTile).ri).referenceCenter.x;
        double d3 = ((RenderInfo)((RectTile)rectTile).ri).referenceCenter.y;
        double d4 = ((RenderInfo)((RectTile)rectTile).ri).referenceCenter.z;
        int n3 = 3 * rectTile.ri.indices.get(n2);
        Vec4 vec4 = new Vec4(rectTile.ri.vertices.get(n3++) + d2, rectTile.ri.vertices.get(n3++) + d3, rectTile.ri.vertices.get(n3) + d4);
        n3 = 3 * rectTile.ri.indices.get(n2 + 1);
        Vec4 vec42 = new Vec4(rectTile.ri.vertices.get(n3++) + d2, rectTile.ri.vertices.get(n3++) + d3, rectTile.ri.vertices.get(n3) + d4);
        n3 = 3 * rectTile.ri.indices.get(n2 + 2);
        Vec4 vec43 = new Vec4(rectTile.ri.vertices.get(n3++) + d2, rectTile.ri.vertices.get(n3++) + d3, rectTile.ri.vertices.get(n3) + d4);
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec43.subtract3(vec4);
        Vec4 vec46 = vec44.cross3(vec45);
        Line line = drawContext.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec47 = line.getOrigin().subtract3(vec4);
        double d5 = -vec46.dot3(vec47);
        double d6 = vec46.dot3(line.getDirection());
        if (Math.abs(d6) < d) {
            return null;
        }
        double d7 = d5 / d6;
        Vec4 vec48 = line.getOrigin().add3(line.getDirection().multiply3(d7));
        Position position = drawContext.getGlobe().computePositionFromPoint(vec48);
        double d8 = drawContext.getGlobe().getElevation(position.getLatitude(), position.getLongitude());
        Position position2 = new Position(position.getLatitude(), position.getLongitude(), d8);
        return new PickedObject(point, n, position2, position.getLatitude(), position.getLongitude(), d8, true);
    }

    private Vec4 getSurfacePoint(RectTile rectTile, Angle angle, Angle angle2, double d) {
        Vec4 vec4 = this.getSurfacePoint(rectTile, angle, angle2);
        if (d != 0.0 && vec4 != null) {
            vec4 = RectangularTessellator.applyOffset(this.globe, vec4, d);
        }
        return vec4;
    }

    private static Vec4 applyOffset(Globe globe, Vec4 vec4, double d) {
        Vec4 vec42 = globe.computeSurfaceNormalAtPoint(vec4);
        vec4 = Vec4.fromLine3(vec4, d, vec42);
        return vec4;
    }

    private Vec4 getSurfacePoint(RectTile rectTile, Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!rectTile.sector.contains(angle, angle2)) {
            return null;
        }
        if (rectTile.ri == null) {
            return null;
        }
        double d = angle.getDegrees();
        double d2 = angle2.getDegrees();
        double d3 = rectTile.sector.getMinLatitude().getDegrees();
        double d4 = rectTile.sector.getMaxLatitude().getDegrees();
        double d5 = rectTile.sector.getMinLongitude().getDegrees();
        double d6 = rectTile.sector.getMaxLongitude().getDegrees();
        double d7 = (d2 - d5) / (d6 - d5);
        double d8 = (d - d3) / (d4 - d3);
        int n = (int)(d8 * (double)rectTile.density);
        int n2 = (int)(d7 * (double)rectTile.density);
        double d9 = RectangularTessellator.createPosition(n2, d7, rectTile.ri.density);
        double d10 = RectangularTessellator.createPosition(n, d8, rectTile.ri.density);
        Vec4 vec4 = RectangularTessellator.interpolate(n, n2, d9, d10, rectTile.ri);
        vec4 = vec4.add3(rectTile.ri.referenceCenter);
        return vec4;
    }

    private static double createPosition(int n, double d, int n2) {
        double d2 = (double)n / (double)n2;
        double d3 = (double)(n + 1) / (double)n2;
        return (d - d2) / (d3 - d2);
    }

    private static Vec4 interpolate(int n, int n2, double d, double d2, RenderInfo renderInfo) {
        int n3 = renderInfo.density + 3;
        int n4 = ++n * n3 + ++n2;
        int n5 = n3 * 3;
        Vec4 vec4 = new Vec4(renderInfo.vertices.get(n4 *= 3), renderInfo.vertices.get(n4 + 1), renderInfo.vertices.get(n4 + 2));
        Vec4 vec42 = new Vec4(renderInfo.vertices.get(n4 + 3), renderInfo.vertices.get(n4 + 4), renderInfo.vertices.get(n4 + 5));
        Vec4 vec43 = new Vec4(renderInfo.vertices.get(n4 += n5), renderInfo.vertices.get(n4 + 1), renderInfo.vertices.get(n4 + 2));
        Vec4 vec44 = new Vec4(renderInfo.vertices.get(n4 + 3), renderInfo.vertices.get(n4 + 4), renderInfo.vertices.get(n4 + 5));
        return RectangularTessellator.interpolate(vec4, vec42, vec44, vec43, d, d2);
    }

    private static Vec4 interpolate(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, double d, double d2) {
        double d3 = d + d2;
        if (d3 == 1.0) {
            return new Vec4(vec44.x * d2 + vec42.x * d, vec44.y * d2 + vec42.y * d, vec44.z * d2 + vec42.z * d);
        }
        if (d3 > 1.0) {
            Vec4 vec45 = vec44.subtract3(vec43).multiply3(1.0 - d);
            Vec4 vec46 = vec42.subtract3(vec43).multiply3(1.0 - d2);
            return vec43.add3(vec45).add3(vec46);
        }
        Vec4 vec47 = vec42.subtract3(vec4).multiply3(d);
        Vec4 vec48 = vec44.subtract3(vec4).multiply3(d2);
        return vec4.add3(vec47).add3(vec48);
    }

    private static DoubleBuffer getTextureCoordinates(int n) {
        int n2;
        int n3;
        DoubleBuffer doubleBuffer;
        if (n < 1) {
            n = 1;
        }
        if ((doubleBuffer = parameterizations.get(n)) != null) {
            return doubleBuffer;
        }
        int n4 = (n + 3) * (n + 3);
        doubleBuffer = BufferUtil.newDoubleBuffer(2 * n4);
        double d = 1.0 / (double)n;
        int n5 = 2 * (n + 3);
        for (int i = 0; i < n; ++i) {
            double d2 = (double)i * d;
            doubleBuffer.put(n5++, 0.0);
            doubleBuffer.put(n5++, d2);
            for (n3 = 0; n3 < n; ++n3) {
                doubleBuffer.put(n5++, (double)n3 * d);
                doubleBuffer.put(n5++, d2);
            }
            doubleBuffer.put(n5++, 0.999999);
            doubleBuffer.put(n5++, d2);
            doubleBuffer.put(n5++, 0.999999);
            doubleBuffer.put(n5++, d2);
        }
        double d3 = 0.999999;
        doubleBuffer.put(n5++, 0.0);
        doubleBuffer.put(n5++, d3);
        for (n2 = 0; n2 < n; ++n2) {
            doubleBuffer.put(n5++, (double)n2 * d);
            doubleBuffer.put(n5++, d3);
        }
        doubleBuffer.put(n5++, 0.999999);
        doubleBuffer.put(n5++, d3);
        doubleBuffer.put(n5++, 0.999999);
        doubleBuffer.put(n5++, d3);
        n2 = n5 - 2 * (n + 3);
        for (n3 = 0; n3 < n + 3; ++n3) {
            doubleBuffer.put(n5++, doubleBuffer.get(n2++));
            doubleBuffer.put(n5++, doubleBuffer.get(n2++));
        }
        n5 = 0;
        n2 = 2 * (n + 3);
        for (n3 = 0; n3 < n + 3; ++n3) {
            doubleBuffer.put(n5++, doubleBuffer.get(n2++));
            doubleBuffer.put(n5++, doubleBuffer.get(n2++));
        }
        parameterizations.put(n, doubleBuffer);
        return doubleBuffer;
    }

    protected static IntBuffer getIndices(int n) {
        IntBuffer intBuffer;
        if (n < 1) {
            n = 1;
        }
        if ((intBuffer = indexLists.get(n)) != null) {
            return intBuffer;
        }
        int n2 = n + 2;
        int n3 = 2 * n2 * n2 + 4 * n2 - 2;
        intBuffer = BufferUtil.newIntBuffer(n3);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            intBuffer.put(n4);
            if (i > 0) {
                intBuffer.put(++n4);
                intBuffer.put(n4);
            }
            if (i % 2 == 0) {
                intBuffer.put(++n4);
                for (n5 = 0; n5 < n2; ++n5) {
                    intBuffer.put(n4 += n2);
                    intBuffer.put(++n4);
                }
                continue;
            }
            intBuffer.put(--n4);
            for (n5 = 0; n5 < n2; ++n5) {
                intBuffer.put(n4 -= n2);
                intBuffer.put(--n4);
            }
        }
        indexLists.put(n, intBuffer);
        return intBuffer;
    }

    private static class CacheKey {
        private final Sector sector;
        private final int resolution;
        private final int density;
        private final Globe globe;
        private final Object globeStateKey;
        private final double verticalExaggeration;

        public CacheKey(Globe globe, Sector sector, double d, int n, int n2) {
            this.sector = sector;
            this.resolution = n;
            this.density = n2;
            this.globe = globe;
            this.globeStateKey = globe.getStateKey();
            this.verticalExaggeration = d;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.density != cacheKey.density) {
                return false;
            }
            if (this.resolution != cacheKey.resolution) {
                return false;
            }
            if (Double.compare(cacheKey.verticalExaggeration, this.verticalExaggeration) != 0) {
                return false;
            }
            if (this.globe != null ? !this.globe.equals(cacheKey.globe) : cacheKey.globe != null) {
                return false;
            }
            if (this.globeStateKey != null ? !this.globeStateKey.equals(cacheKey.globeStateKey) : cacheKey.globeStateKey != null) {
                return false;
            }
            return !(this.sector != null ? !this.sector.equals(cacheKey.sector) : cacheKey.sector != null);
        }

        public int hashCode() {
            int n = this.sector != null ? this.sector.hashCode() : 0;
            n = 31 * n + this.resolution;
            n = 31 * n + this.density;
            n = 31 * n + (this.globe != null ? this.globe.hashCode() : 0);
            n = 31 * n + (this.globeStateKey != null ? this.globeStateKey.hashCode() : 0);
            long l = this.verticalExaggeration != 0.0 ? Double.doubleToLongBits(this.verticalExaggeration) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RectTile
    implements SectorGeometry {
        private final RectangularTessellator tessellator;
        private final int level;
        private final Sector sector;
        private final int density;
        private final double log10CellSize;
        private Extent extent;
        private RenderInfo ri;
        private int minColorCode = 0;
        private int maxColorCode = 0;

        public RectTile(RectangularTessellator rectangularTessellator, Extent extent, int n, int n2, Sector sector, double d) {
            this.tessellator = rectangularTessellator;
            this.level = n;
            this.density = n2;
            this.sector = sector;
            this.extent = extent;
            this.log10CellSize = Math.log10(d);
        }

        @Override
        public Sector getSector() {
            return this.sector;
        }

        @Override
        public Extent getExtent() {
            return this.extent;
        }

        @Override
        public void renderMultiTexture(DrawContext drawContext, int n) {
            this.tessellator.renderMultiTexture(drawContext, this, n);
        }

        @Override
        public void render(DrawContext drawContext) {
            this.tessellator.render(drawContext, this);
        }

        @Override
        public void renderWireframe(DrawContext drawContext, boolean bl, boolean bl2) {
            this.tessellator.renderWireframe(drawContext, this, bl, bl2);
        }

        @Override
        public void renderBoundingVolume(DrawContext drawContext) {
            this.tessellator.renderBoundingVolume(drawContext, this);
        }

        @Override
        public PickedObject[] pick(DrawContext drawContext, List<Point> list) {
            return this.tessellator.pick(drawContext, this, list);
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
            this.tessellator.pick(drawContext, this, point);
        }

        @Override
        public Vec4 getSurfacePoint(Angle angle, Angle angle2, double d) {
            return this.tessellator.getSurfacePoint(this, angle, angle2, d);
        }
    }

    protected static class RenderInfo {
        private final int density;
        private final int resolution;
        private final Vec4 referenceCenter;
        private final DoubleBuffer vertices;
        private final DoubleBuffer texCoords;
        private final IntBuffer indices;

        private RenderInfo(int n, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, Vec4 vec4, int n2) {
            this.density = n;
            this.vertices = doubleBuffer;
            this.texCoords = doubleBuffer2;
            this.referenceCenter = vec4;
            this.indices = RectangularTessellator.getIndices(this.density);
            this.resolution = n2;
        }

        private long getSizeInBytes() {
            return 32 + this.vertices.limit() * 64;
        }
    }
}

