/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.BasicElevationModel;
import gov.nasa.worldwind.util.LevelSet;

public class MarsElevationModel
extends BasicElevationModel {
    private static double HEIGHT_OF_OLYMPUS_MONS = 22000.0;
    private static double DEPTH_OF_HELLAS_BASIN = -8000.0;

    public MarsElevationModel() {
        super(MarsElevationModel.makeLevels(), DEPTH_OF_HELLAS_BASIN, HEIGHT_OF_OLYMPUS_MONS);
        this.setNumExpectedValuesPerTile(22500L);
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.ExtremeElevations.MarsTopo.FileName");
        if (string != null) {
            this.loadExtremeElevations(string);
        }
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 150);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 150);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Mars/molazip");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://worldwind25.arc.nasa.gov/mars/mars.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "molazip");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".bil");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 8);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(20.0), Angle.fromDegrees(20.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        return new LevelSet(aVListImpl);
    }
}

