/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.SectorGeometryList;
import gov.nasa.worldwind.globes.Tessellator;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;

public class FlatGlobe
extends WWObjectImpl
implements Globe {
    public static final String PROJECTION_LAT_LON = "gov.nasa.worldwind.globes.projectionLatLon";
    public static final String PROJECTION_MERCATOR = "gov.nasa.worldwind.globes.projectionMercator";
    public static final String PROJECTION_SINUSOIDAL = "gov.nasa.worldwind.globes.projectionSinusoidal";
    public static final String PROJECTION_MODIFIED_SINUSOIDAL = "gov.nasa.worldwind.globes.projectionModifiedSinusoidal";
    private final double equatorialRadius;
    private final double polarRadius;
    private final double es;
    private final Vec4 center;
    private Tessellator tessellator;
    private final ElevationModel elevationModel;
    private String projection = "gov.nasa.worldwind.globes.projectionMercator";

    public FlatGlobe(double d, double d2, double d3, ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.equatorialRadius = d;
        this.polarRadius = d2;
        this.es = d3;
        this.center = Vec4.ZERO;
        this.elevationModel = elevationModel;
        this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
    }

    public Object getStateKey() {
        return new StateKey(this);
    }

    public Tessellator getTessellator() {
        return this.tessellator;
    }

    public void setTessellator(Tessellator tessellator) {
        this.tessellator = tessellator;
    }

    public final double getRadius() {
        return this.equatorialRadius;
    }

    public final double getEquatorialRadius() {
        return this.equatorialRadius;
    }

    public final double getPolarRadius() {
        return this.polarRadius;
    }

    public double getMaximumRadius() {
        return this.equatorialRadius;
    }

    public double getRadiusAt(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.getMaximumRadius();
    }

    public double getRadiusAt(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.getMaximumRadius();
    }

    public double getEccentricitySquared() {
        return this.es;
    }

    public final double getDiameter() {
        return this.equatorialRadius * 2.0;
    }

    public final Vec4 getCenter() {
        return this.center;
    }

    public double getMaxElevation() {
        return this.elevationModel.getMaxElevation();
    }

    public double getMinElevation() {
        return this.elevationModel.getMinElevation();
    }

    public double[] getMinAndMaxElevations(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.elevationModel.getMinAndMaxElevations(sector);
    }

    public final Extent getExtent() {
        return this;
    }

    public void setProjection(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.projection.equals(string)) {
            return;
        }
        this.projection = string;
        this.tessellator = null;
    }

    public String getProjection() {
        return this.projection;
    }

    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return frustum.intersects(this);
    }

    public Intersection[] intersect(Line line) {
        return this.internalIntersect(line, this.equatorialRadius);
    }

    public Intersection[] intersect(Line line, double d) {
        return this.internalIntersect(line, this.equatorialRadius + d);
    }

    private Intersection[] internalIntersect(Line line, double d) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Plane plane = new Plane(0.0, 0.0, 1.0, -(d - this.equatorialRadius));
        Vec4 vec4 = plane.intersect(line);
        if (vec4 == null) {
            return null;
        }
        Position position = this.computePositionFromPoint(vec4);
        if (position == null) {
            return null;
        }
        if (position.getLatitude().degrees < -90.0 || position.getLatitude().degrees > 90.0 || position.getLongitude().degrees < -180.0 || position.getLongitude().degrees > 180.0) {
            return null;
        }
        return new Intersection[]{new Intersection(vec4, false)};
    }

    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.intersect(line) != null;
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return !plane.getNormal().equals(Vec4.UNIT_Z);
    }

    public Vec4 computeSurfaceNormalAtPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.UNIT_Z;
    }

    public final ElevationModel getElevationModel() {
        return this.elevationModel;
    }

    public Double getBestElevation(Angle angle, Angle angle2) {
        return this.elevationModel.getBestElevation(angle, angle2);
    }

    public final Double getElevationAtResolution(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees < -90.0 || angle.degrees > 90.0 || angle2.degrees < -180.0 || angle2.degrees > 180.0) {
            return 0.0;
        }
        int n = this.elevationModel.getTargetResolution(this, d);
        return this.elevationModel.getElevationAtResolution(angle, angle2, n);
    }

    public final double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees < -90.0 || angle.degrees > 90.0 || angle2.degrees < -180.0 || angle2.degrees > 180.0) {
            return 0.0;
        }
        return this.elevationModel != null ? this.elevationModel.getElevation(angle, angle2) : 0.0;
    }

    public final Vec4 computePointFromPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    public final Vec4 computePointFromPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(angle, angle2, d);
    }

    public final Position computePositionFromPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.cartesianToGeodetic(vec4);
    }

    public final Position getIntersectionPosition(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Intersection[] intersectionArray = this.intersect(line);
        if (intersectionArray == null) {
            return null;
        }
        return this.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
    }

    private Vec4 geodeticToCartesian(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = null;
        if (this.projection.equals(PROJECTION_LAT_LON)) {
            vec4 = new Vec4(this.equatorialRadius * angle2.radians, this.equatorialRadius * angle.radians, d);
        } else if (this.projection.equals(PROJECTION_MERCATOR)) {
            if (angle.degrees > 75.0) {
                angle = Angle.fromDegrees(75.0);
            }
            if (angle.degrees < -75.0) {
                angle = Angle.fromDegrees(-75.0);
            }
            vec4 = new Vec4(this.equatorialRadius * angle2.radians, this.equatorialRadius * Math.log(Math.tan(0.7853981633974483 + angle.radians / 2.0)), d);
        } else if (this.projection.equals(PROJECTION_SINUSOIDAL)) {
            vec4 = new Vec4(this.equatorialRadius * angle2.radians * angle.cos(), this.equatorialRadius * angle.radians, d);
        } else if (this.projection.equals(PROJECTION_MODIFIED_SINUSOIDAL)) {
            vec4 = new Vec4(this.equatorialRadius * angle2.radians * Math.pow(angle.cos(), 0.3), this.equatorialRadius * angle.radians, d);
        }
        return vec4;
    }

    private Position cartesianToGeodetic(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = null;
        if (this.projection.equals(PROJECTION_LAT_LON)) {
            position = Position.fromRadians(vec4.y / this.equatorialRadius, vec4.x / this.equatorialRadius, vec4.z);
        } else if (this.projection.equals(PROJECTION_MERCATOR)) {
            position = Position.fromRadians(Math.atan(Math.sinh(vec4.y / this.equatorialRadius)), vec4.x / this.equatorialRadius, vec4.z);
        } else if (this.projection.equals(PROJECTION_SINUSOIDAL)) {
            position = Position.fromRadians(vec4.y / this.equatorialRadius, vec4.x / this.equatorialRadius / Angle.fromRadians(vec4.y / this.equatorialRadius).cos(), vec4.z);
        } else if (this.projection.equals(PROJECTION_MODIFIED_SINUSOIDAL)) {
            position = Position.fromRadians(vec4.y / this.equatorialRadius, vec4.x / this.equatorialRadius / Math.pow(Angle.fromRadians(vec4.y / this.equatorialRadius).cos(), 0.3), vec4.z);
        }
        return position;
    }

    public Cylinder computeBoundingCylinder(double d, Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = sector.getCentroid();
        double[] dArray = this.getMinAndMaxElevations(sector);
        double d2 = dArray[0] * d;
        double d3 = dArray[1] * d;
        Vec4 vec4 = this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d3);
        Vec4 vec42 = this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d2);
        Vec4 vec43 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d3);
        Vec4 vec44 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d3);
        Vec4 vec45 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d3);
        Vec4 vec46 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d3);
        double d4 = vec45.distanceTo3(vec42);
        double d5 = vec44.distanceTo3(vec42);
        double d6 = vec46.distanceTo3(vec42);
        double d7 = vec43.distanceTo3(vec42);
        double d8 = Math.max(Math.max(d4, d5), Math.max(d6, d7));
        return new Cylinder(vec42, vec4, d8);
    }

    public SectorGeometryList tessellate(DrawContext drawContext) {
        if (this.tessellator == null) {
            this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
        }
        return this.tessellator.tessellate(drawContext);
    }

    private static class StateKey {
        private final Tessellator tessellator;
        private final String projection;

        public StateKey(FlatGlobe flatGlobe) {
            this.tessellator = flatGlobe.tessellator;
            this.projection = flatGlobe.projection;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StateKey stateKey = (StateKey)object;
            if (this.projection != null ? !this.projection.equals(stateKey.projection) : stateKey.projection != null) {
                return false;
            }
            return !(this.tessellator != null ? !this.tessellator.equals(stateKey.tessellator) : stateKey.tessellator != null);
        }

        public int hashCode() {
            int n = this.tessellator != null ? this.tessellator.hashCode() : 0;
            n = 31 * n + (this.projection != null ? this.projection.hashCode() : 0);
            return n;
        }
    }
}

