/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.SectorGeometryList;
import gov.nasa.worldwind.globes.Tessellator;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;

public class EllipsoidalGlobe
extends WWObjectImpl
implements Globe {
    private final double equatorialRadius;
    private final double polarRadius;
    private final double es;
    private final Vec4 center;
    private final ElevationModel elevationModel;
    private Tessellator tessellator;

    public EllipsoidalGlobe(double d, double d2, double d3, ElevationModel elevationModel) {
        if (elevationModel == null) {
            String string = Logging.getMessage("nullValue.ElevationModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.equatorialRadius = d;
        this.polarRadius = d2;
        this.es = d3;
        this.center = Vec4.ZERO;
        this.elevationModel = elevationModel;
        this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
    }

    public Object getStateKey() {
        return new StateKey(this);
    }

    public Tessellator getTessellator() {
        return this.tessellator;
    }

    public void setTessellator(Tessellator tessellator) {
        this.tessellator = tessellator;
    }

    public final double getRadius() {
        return this.equatorialRadius;
    }

    public final double getEquatorialRadius() {
        return this.equatorialRadius;
    }

    public final double getPolarRadius() {
        return this.polarRadius;
    }

    public double getMaximumRadius() {
        return this.equatorialRadius;
    }

    public double getRadiusAt(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computePointFromPosition(angle, angle2, 0.0).getLength3();
    }

    public double getRadiusAt(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0).getLength3();
    }

    public double getEccentricitySquared() {
        return this.es;
    }

    public final double getDiameter() {
        return this.equatorialRadius * 2.0;
    }

    public final Vec4 getCenter() {
        return this.center;
    }

    public double getMaxElevation() {
        return this.elevationModel.getMaxElevation();
    }

    public double getMinElevation() {
        return this.elevationModel.getMinElevation();
    }

    public double[] getMinAndMaxElevations(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.elevationModel.getMinAndMaxElevations(sector);
    }

    public final Extent getExtent() {
        return this;
    }

    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return frustum.intersects(this);
    }

    public Intersection[] intersect(Line line) {
        return this.intersect(line, this.equatorialRadius, this.polarRadius);
    }

    public Intersection[] intersect(Line line, double d) {
        return this.intersect(line, this.equatorialRadius + d, this.polarRadius + d);
    }

    private Intersection[] intersect(Line line, double d, double d2) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d3 = line.getDirection().x;
        double d4 = d / d2;
        double d5 = d4 * d4;
        double d6 = line.getDirection().y;
        double d7 = 1.0;
        double d8 = d7 * d7;
        double d9 = line.getDirection().z;
        double d10 = d3 * d3 + d5 * d6 * d6 + d8 * d9 * d9;
        double d11 = line.getOrigin().x;
        double d12 = line.getOrigin().y;
        double d13 = line.getOrigin().z;
        double d14 = 2.0 * (d11 * d3 + d5 * d12 * d6 + d8 * d13 * d9);
        double d15 = d * d;
        double d16 = d11 * d11 + d5 * d12 * d12 + d8 * d13 * d13 - d15;
        double d17 = EllipsoidalGlobe.discriminant(d10, d14, d16);
        if (d17 < 0.0) {
            return null;
        }
        double d18 = Math.sqrt(d17);
        if (d17 == 0.0) {
            Vec4 vec4 = line.getPointAt((-d14 - d18) / (2.0 * d10));
            return new Intersection[]{new Intersection(vec4, true)};
        }
        Vec4 vec4 = line.getPointAt((-d14 - d18) / (2.0 * d10));
        Vec4 vec42 = line.getPointAt((-d14 + d18) / (2.0 * d10));
        if (d16 >= 0.0) {
            return new Intersection[]{new Intersection(vec4, false), new Intersection(vec42, false)};
        }
        return new Intersection[]{new Intersection(vec42, false)};
    }

    private static double discriminant(double d, double d2, double d3) {
        return d2 * d2 - 4.0 * d * d3;
    }

    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return line.distanceTo(this.center) <= this.equatorialRadius;
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = plane.dot(this.center);
        return d <= this.equatorialRadius;
    }

    public Vec4 computeSurfaceNormalAtPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        vec4 = vec4.subtract3(this.center);
        return new Vec4(vec4.x / (this.equatorialRadius * this.equatorialRadius), vec4.y / (this.polarRadius * this.polarRadius), vec4.z / (this.equatorialRadius * this.equatorialRadius)).normalize3();
    }

    public final ElevationModel getElevationModel() {
        return this.elevationModel;
    }

    public final double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.elevationModel != null ? this.elevationModel.getElevation(angle, angle2) : 0.0;
    }

    public final Double getElevationAtResolution(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.elevationModel == null) {
            return null;
        }
        int n = this.elevationModel.getTargetResolution(this, d);
        return this.elevationModel.getElevationAtResolution(angle, angle2, n);
    }

    public final Double getBestElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.elevationModel != null ? this.elevationModel.getBestElevation(angle, angle2) : null;
    }

    public final Vec4 computePointFromPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    public final Vec4 computePointFromPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(angle, angle2, d);
    }

    public final Position computePositionFromPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.cartesianToGeodetic(vec4);
    }

    public final Position getIntersectionPosition(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Intersection[] intersectionArray = this.intersect(line);
        if (intersectionArray == null) {
            return null;
        }
        return this.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
    }

    private Vec4 geodeticToCartesian(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = angle.cos();
        double d3 = angle.sin();
        double d4 = this.equatorialRadius / Math.sqrt(1.0 - this.es * d3 * d3);
        double d5 = (d4 + d) * d2 * angle2.sin();
        double d6 = (d4 * (1.0 - this.es) + d) * d3;
        double d7 = (d4 + d) * d2 * angle2.cos();
        return new Vec4(d5, d6, d7);
    }

    private Position cartesianToGeodetic(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = 1.0 / (this.equatorialRadius * this.equatorialRadius);
        double d2 = vec4.z;
        double d3 = vec4.x;
        double d4 = vec4.y;
        double d5 = this.es;
        double d6 = d5 * d5;
        double d7 = d2 * d2 + d3 * d3;
        double d8 = Math.sqrt(d7);
        double d9 = d7 * d;
        double d10 = d4 * d4 * (1.0 - d5) * d;
        double d11 = 0.16666666666666666 * (d9 + d10 - d6);
        double d12 = d6 * d9 * d10 / (4.0 * d11 * d11 * d11);
        double d13 = Math.pow(1.0 + d12 + Math.sqrt(d12 * (2.0 + d12)), 0.3333333333333333);
        double d14 = d11 * (1.0 + d13 + 1.0 / d13);
        double d15 = Math.sqrt(d14 * d14 + d6 * d10);
        double d16 = d5 * (d14 + d15 - d10) / (2.0 * d15);
        double d17 = Math.sqrt(d14 + d15 + d16 * d16) - d16;
        double d18 = d17 * d8 / (d17 + d5);
        double d19 = 2.0 * Math.atan2(d3, d2 + d8);
        double d20 = Math.sqrt(d18 * d18 + d4 * d4);
        double d21 = 2.0 * Math.atan2(d4, d18 + d20);
        double d22 = (d17 + d5 - 1.0) * d20 / d17;
        return Position.fromRadians(d21, d19, d22);
    }

    public Cylinder computeBoundingCylinder(double d, Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = sector.getCentroid();
        double[] dArray = this.getMinAndMaxElevations(sector);
        double d2 = dArray[0] * d;
        double d3 = dArray[1] * d;
        Vec4 vec4 = this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d3);
        Vec4 vec42 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2);
        Vec4 vec43 = vec4.normalize3();
        double d4 = vec43.dot3(vec42);
        Vec4 vec44 = vec43.multiply3(d4);
        Vec4 vec45 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d3);
        Vec4 vec46 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d3);
        Vec4 vec47 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d3);
        Vec4 vec48 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d3);
        double d5 = vec47.distanceTo3(vec46);
        double d6 = vec46.distanceTo3(vec48);
        double d7 = vec48.distanceTo3(vec45);
        double d8 = vec45.distanceTo3(vec47);
        double d9 = 0.5 * (d5 + d6 + d7 + d8);
        double d10 = Math.sqrt((d9 - d5) * (d9 - d6) * (d9 - d7) * (d9 - d8));
        double d11 = Math.sqrt((d5 * d6 + d7 * d8) * (d5 * d8 + d6 * d7) * (d5 * d7 + d6 * d8)) / (4.0 * d10);
        return new Cylinder(vec44, vec4, d11);
    }

    public SectorGeometryList tessellate(DrawContext drawContext) {
        if (this.tessellator == null) {
            this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
        }
        return this.tessellator.tessellate(drawContext);
    }

    private static class StateKey {
        private final Tessellator tessellator;

        public StateKey(EllipsoidalGlobe ellipsoidalGlobe) {
            this.tessellator = ellipsoidalGlobe.tessellator;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StateKey stateKey = (StateKey)object;
            return !(this.tessellator != null ? !this.tessellator.equals(stateKey.tessellator) : stateKey.tessellator != null);
        }

        public int hashCode() {
            return this.tessellator != null ? this.tessellator.hashCode() : 0;
        }
    }
}

