/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.coords.MGRSCoordConverter;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;

public class MGRSCoord {
    private final String MGRSString;
    private final Angle latitude;
    private final Angle longitude;

    public static MGRSCoord fromLatLon(Angle angle, Angle angle2) {
        return MGRSCoord.fromLatLon(angle, angle2, null, 5);
    }

    public static MGRSCoord fromLatLon(Angle angle, Angle angle2, int n) {
        return MGRSCoord.fromLatLon(angle, angle2, null, n);
    }

    public static MGRSCoord fromLatLon(Angle angle, Angle angle2, Globe globe) {
        return MGRSCoord.fromLatLon(angle, angle2, globe, 5);
    }

    public static MGRSCoord fromLatLon(Angle angle, Angle angle2, Globe globe, int n) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        MGRSCoordConverter mGRSCoordConverter = new MGRSCoordConverter(globe);
        long l = mGRSCoordConverter.convertGeodeticToMGRS(angle.radians, angle2.radians, n);
        if (l != 0L) {
            String string = Logging.getMessage("Coord.MGRSConversionError");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new MGRSCoord(angle, angle2, mGRSCoordConverter.getMGRSString());
    }

    public static MGRSCoord fromString(String string, Globe globe) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        MGRSCoordConverter mGRSCoordConverter = new MGRSCoordConverter(globe);
        long l = mGRSCoordConverter.convertMGRSToGeodetic(string = string.toUpperCase().replaceAll(" ", ""));
        if (l != 0L) {
            String string3 = Logging.getMessage("Coord.MGRSConversionError");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return new MGRSCoord(Angle.fromRadians(mGRSCoordConverter.getLatitude()), Angle.fromRadians(mGRSCoordConverter.getLongitude()), string);
    }

    public MGRSCoord(Angle angle, Angle angle2, String string) {
        if (angle == null || angle2 == null) {
            String string2 = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null || string.length() == 0) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.latitude = angle;
        this.longitude = angle2;
        this.MGRSString = string;
    }

    public Angle getLatitude() {
        return this.latitude;
    }

    public Angle getLongitude() {
        return this.longitude;
    }

    public String toString() {
        return this.MGRSString;
    }
}

