/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Quaternion;
import gov.nasa.worldwind.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Position {
    private final Angle latitude;
    private final Angle longitude;
    private final double elevation;
    public static final Position ZERO = new Position(Angle.ZERO, Angle.ZERO, 0.0);

    public static Position fromRadians(double d, double d2, double d3) {
        return new Position(Angle.fromRadians(d), Angle.fromRadians(d2), d3);
    }

    public static Position fromDegrees(double d, double d2, double d3) {
        return new Position(Angle.fromDegrees(d), Angle.fromDegrees(d2), d3);
    }

    public Position(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = angle;
        this.longitude = angle2;
        this.elevation = d;
    }

    public Position(LatLon latLon, double d) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = latLon.getLatitude();
        this.longitude = latLon.getLongitude();
        this.elevation = d;
    }

    public final Angle getLatitude() {
        return this.latitude;
    }

    public final Angle getLongitude() {
        return this.longitude;
    }

    public LatLon getLatLon() {
        return new LatLon(this.getLatitude(), this.getLongitude());
    }

    public Position add(Position position) {
        Angle angle = Angle.normalizedLatitude(this.latitude.add(position.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.add(position.longitude));
        return new Position(angle, angle2, this.elevation + position.elevation);
    }

    public Position subtract(Position position) {
        Angle angle = Angle.normalizedLatitude(this.latitude.subtract(position.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.subtract(position.longitude));
        return new Position(angle, angle2, this.elevation - position.elevation);
    }

    public static Position interpolate(double d, Position position, Position position2) {
        Quaternion quaternion;
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            return position;
        }
        if (d > 1.0) {
            return position2;
        }
        Quaternion quaternion2 = Quaternion.fromLatLon(position.getLatitude(), position.getLongitude());
        Quaternion quaternion3 = Quaternion.slerp(d, quaternion2, quaternion = Quaternion.fromLatLon(position2.getLatitude(), position2.getLongitude()));
        LatLon latLon = quaternion3.getLatLon();
        if (latLon == null) {
            return null;
        }
        return new Position(latLon, d * position2.getElevation() + (1.0 - d) * position.getElevation());
    }

    public final double getElevation() {
        return this.elevation;
    }

    public String toString() {
        return "(" + this.latitude.toString() + ", " + this.longitude.toString() + ", " + this.elevation + ")";
    }

    public static boolean positionsCrossDateLine(Iterable<Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = null;
        for (Position position2 : iterable) {
            double d;
            if (position != null && Math.signum(position.getLongitude().degrees) != Math.signum(position2.getLongitude().degrees) && (d = Math.abs(position.getLongitude().degrees - position2.getLongitude().degrees)) > 180.0 && d < 360.0) {
                return true;
            }
            position = position2;
        }
        return false;
    }
}

