/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Quaternion;
import gov.nasa.worldwind.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatLon {
    public static final LatLon ZERO = new LatLon(Angle.ZERO, Angle.ZERO);
    private final Angle latitude;
    private final Angle longitude;

    public static LatLon fromRadians(double d, double d2) {
        return new LatLon(Math.toDegrees(d), Math.toDegrees(d2));
    }

    public static LatLon fromDegrees(double d, double d2) {
        return new LatLon(d, d2);
    }

    private LatLon(double d, double d2) {
        this.latitude = Angle.fromDegrees(d);
        this.longitude = Angle.fromDegrees(d2);
    }

    public LatLon(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = angle;
        this.longitude = angle2;
    }

    public final Angle getLatitude() {
        return this.latitude;
    }

    public final Angle getLongitude() {
        return this.longitude;
    }

    public static LatLon interpolate(double d, LatLon latLon, LatLon latLon2) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            return latLon;
        }
        if (d > 1.0) {
            return latLon2;
        }
        Quaternion quaternion = Quaternion.fromLatLon(latLon.getLatitude(), latLon.getLongitude());
        Quaternion quaternion2 = Quaternion.fromLatLon(latLon2.getLatitude(), latLon2.getLongitude());
        Quaternion quaternion3 = Quaternion.slerp(d, quaternion, quaternion2);
        return quaternion3.getLatLon();
    }

    public static Angle greatCircleDistance(LatLon latLon, LatLon latLon2) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().radians;
        double d2 = latLon.getLongitude().radians;
        double d3 = latLon2.getLatitude().radians;
        double d4 = latLon2.getLongitude().radians;
        if (d == d3 && d2 == d4) {
            return Angle.ZERO;
        }
        double d5 = Math.sin((d3 - d) / 2.0) * Math.sin((d3 - d) / 2.0) + Math.cos(d) * Math.cos(d3) * Math.sin((d4 - d2) / 2.0) * Math.sin((d4 - d2) / 2.0);
        double d6 = 2.0 * Math.atan2(Math.sqrt(d5), Math.sqrt(1.0 - d5));
        return Double.isNaN(d6) ? Angle.ZERO : Angle.fromRadians(d6);
    }

    public static Angle greatCircleAzimuth(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = latLon.getLatitude().radians;
        double d3 = latLon.getLongitude().radians;
        double d4 = latLon2.getLatitude().radians;
        double d5 = latLon2.getLongitude().radians;
        if (d2 == d4 && d3 == d5) {
            return Angle.ZERO;
        }
        if (d3 == d5) {
            return d2 > d4 ? Angle.POS180 : Angle.ZERO;
        }
        double d6 = Math.cos(d4) * Math.sin(d5 - d3);
        double d7 = Math.atan2(d6, d = Math.cos(d2) * Math.sin(d4) - Math.sin(d2) * Math.cos(d4) * Math.cos(d5 - d3));
        return Double.isNaN(d7) ? Angle.ZERO : Angle.fromRadians(d7);
    }

    public static LatLon greatCircleEndPosition(LatLon latLon, Angle angle, Angle angle2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().radians;
        double d2 = latLon.getLongitude().radians;
        double d3 = angle.radians;
        double d4 = angle2.radians;
        if (d4 == 0.0) {
            return latLon;
        }
        double d5 = Math.asin(Math.sin(d) * Math.cos(d4) + Math.cos(d) * Math.sin(d4) * Math.cos(d3));
        double d6 = d2 + Math.atan2(Math.sin(d4) * Math.sin(d3), Math.cos(d) * Math.cos(d4) - Math.sin(d) * Math.sin(d4) * Math.cos(d3));
        if (Double.isNaN(d5) || Double.isNaN(d6)) {
            return latLon;
        }
        return new LatLon(Angle.fromRadians(d5).normalizedLatitude(), Angle.fromRadians(d6).normalizedLongitude());
    }

    public static LatLon greatCircleEndPosition(LatLon latLon, double d, double d2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return LatLon.greatCircleEndPosition(latLon, Angle.fromRadians(d), Angle.fromRadians(d2));
    }

    public static Angle rhumbDistance(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = latLon.getLatitude().radians;
        double d3 = latLon.getLongitude().radians;
        double d4 = latLon2.getLatitude().radians;
        double d5 = latLon2.getLongitude().radians;
        if (d2 == d4 && d3 == d5) {
            return Angle.ZERO;
        }
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        double d8 = Math.log(Math.tan(d4 / 2.0 + 0.7853981633974483) / Math.tan(d2 / 2.0 + 0.7853981633974483));
        double d9 = d6 / d8;
        if (Double.isNaN(d8) || Double.isNaN(d9)) {
            d9 = Math.cos(d2);
        }
        if (Math.abs(d7) > Math.PI) {
            d7 = d7 > 0.0 ? -(Math.PI * 2 - d7) : Math.PI * 2 + d7;
        }
        return Double.isNaN(d = Math.sqrt(d6 * d6 + d9 * d9 * d7 * d7)) ? Angle.ZERO : Angle.fromRadians(d);
    }

    public static Angle rhumbAzimuth(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = latLon.getLatitude().radians;
        double d3 = latLon.getLongitude().radians;
        double d4 = latLon2.getLatitude().radians;
        double d5 = latLon2.getLongitude().radians;
        if (d2 == d4 && d3 == d5) {
            return Angle.ZERO;
        }
        double d6 = d5 - d3;
        double d7 = Math.log(Math.tan(d4 / 2.0 + 0.7853981633974483) / Math.tan(d2 / 2.0 + 0.7853981633974483));
        if (Math.abs(d6) > Math.PI) {
            d6 = d6 > 0.0 ? -(Math.PI * 2 - d6) : Math.PI * 2 + d6;
        }
        return Double.isNaN(d = Math.atan2(d6, d7)) ? Angle.ZERO : Angle.fromRadians(d);
    }

    public static LatLon rhumbEndPosition(LatLon latLon, Angle angle, Angle angle2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().radians;
        double d2 = latLon.getLongitude().radians;
        double d3 = angle.radians;
        double d4 = angle2.radians;
        if (d4 == 0.0) {
            return latLon;
        }
        double d5 = d + d4 * Math.cos(d3);
        double d6 = Math.log(Math.tan(d5 / 2.0 + 0.7853981633974483) / Math.tan(d / 2.0 + 0.7853981633974483));
        double d7 = (d5 - d) / d6;
        if (Double.isNaN(d6) || Double.isNaN(d7)) {
            d7 = Math.cos(d);
        }
        double d8 = d4 * Math.sin(d3) / d7;
        if (Math.abs(d5) > 1.5707963267948966) {
            d5 = d5 > 0.0 ? Math.PI - d5 : -Math.PI - d5;
        }
        double d9 = (d2 + d8 + Math.PI) % (Math.PI * 2) - Math.PI;
        if (Double.isNaN(d5) || Double.isNaN(d9)) {
            return latLon;
        }
        return LatLon.fromRadians(d5, d9);
    }

    public static LatLon rhumbEndPosition(LatLon latLon, double d, double d2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return LatLon.rhumbEndPosition(latLon, Angle.fromRadians(d), Angle.fromRadians(d2));
    }

    public LatLon add(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.normalizedLatitude(this.latitude.add(latLon.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.add(latLon.longitude));
        return new LatLon(angle, angle2);
    }

    public LatLon subtract(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.normalizedLatitude(this.latitude.subtract(latLon.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.subtract(latLon.longitude));
        return new LatLon(angle, angle2);
    }

    public LatLon add(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.normalizedLatitude(this.latitude.add(position.getLatitude()));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.add(position.getLongitude()));
        return new LatLon(angle, angle2);
    }

    public LatLon subtract(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.normalizedLatitude(this.latitude.subtract(position.getLatitude()));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.subtract(position.getLongitude()));
        return new LatLon(angle, angle2);
    }

    public static boolean positionsCrossDateLine(Iterable<LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = null;
        for (LatLon latLon2 : iterable) {
            double d;
            if (latLon != null && Math.signum(latLon.getLongitude().degrees) != Math.signum(latLon2.getLongitude().degrees) && (d = Math.abs(latLon.getLongitude().degrees - latLon2.getLongitude().degrees)) > 180.0 && d < 360.0) {
                return true;
            }
            latLon = latLon2;
        }
        return false;
    }

    public static boolean positionsCrossLongitudeBoundary(LatLon latLon, LatLon latLon2) {
        double d;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Math.signum(latLon.getLongitude().degrees) != Math.signum(latLon2.getLongitude().degrees) && (d = Math.abs(latLon.getLongitude().degrees - latLon2.getLongitude().degrees)) > 180.0 && d < 360.0;
    }

    public String toString() {
        String string = String.format("Lat %7.4f\u00b0", this.getLatitude().getDegrees());
        String string2 = String.format("Lon %7.4f\u00b0", this.getLongitude().getDegrees());
        return "(" + string + ", " + string2 + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LatLon latLon = (LatLon)object;
        if (!this.latitude.equals(latLon.latitude)) {
            return false;
        }
        return this.longitude.equals(latLon.longitude);
    }

    public int hashCode() {
        int n = this.latitude.hashCode();
        n = 29 * n + this.longitude.hashCode();
        return n;
    }

    public Angle ellipsoidalForwardAzimuth(LatLon latLon, LatLon latLon2, double d, double d2) {
        double d3 = (d - d2) / d;
        double d4 = 1.0 - d3;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d5 = latLon.getLatitude().radians;
        double d6 = latLon2.getLatitude().radians;
        double d7 = d4 * Math.sin(d5) / Math.cos(d5);
        double d8 = d4 * Math.sin(d6) / Math.cos(d6);
        double d9 = 1.0 / Math.sqrt(d7 * d7 + 1.0);
        double d10 = 1.0 / Math.sqrt(d8 * d8 + 1.0);
        double d11 = d9 * d10;
        double d12 = d11 * d8;
        double d13 = d12 * d7;
        return Angle.fromRadians(d13);
    }

    public static double ellipsoidalDistance(LatLon latLon, LatLon latLon2, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11 = (d - d2) / d;
        double d12 = 1.0 - d11;
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d13 = latLon.getLatitude().radians;
        double d14 = latLon2.getLatitude().radians;
        double d15 = d12 * Math.sin(d13) / Math.cos(d13);
        double d16 = d12 * Math.sin(d14) / Math.cos(d14);
        double d17 = 1.0 / Math.sqrt(d15 * d15 + 1.0);
        double d18 = d17 * d15;
        double d19 = 1.0 / Math.sqrt(d16 * d16 + 1.0);
        double d20 = d17 * d19;
        double d21 = d20 * d16;
        double d22 = d21 * d15;
        double d23 = latLon.getLongitude().radians;
        double d24 = latLon2.getLongitude().radians;
        double d25 = d24 - d23;
        do {
            double d26 = Math.sin(d25);
            double d27 = Math.cos(d25);
            d15 = d19 * d26;
            d16 = d21 - d18 * d19 * d27;
            d8 = Math.sqrt(d15 * d15 + d16 * d16);
            d7 = d20 * d27 + d22;
            d6 = Math.atan2(d8, d7);
            double d28 = d20 * d26 / d8;
            d5 = -d28 * d28 + 1.0;
            d4 = d22 + d22;
            if (d5 > 0.0) {
                d4 = -d4 / d5 + d7;
            }
            d3 = d4 * d4 * 2.0 - 1.0;
            d9 = ((-3.0 * d5 + 4.0) * d11 + 4.0) * d5 * d11 / 16.0;
            d10 = d25;
            d25 = ((d3 * d7 * d9 + d4) * d8 * d9 + d6) * d28;
        } while (Math.abs(d10 - (d25 = (1.0 - d9) * d25 * d11 + d24 - d23)) > 5.0E-14);
        d25 = Math.sqrt((1.0 / d12 / d12 - 1.0) * d5 + 1.0) + 1.0;
        d25 = (d25 - 2.0) / d25;
        d9 = 1.0 - d25;
        d9 = (d25 * d25 / 4.0 + 1.0) / d9;
        d10 = (0.375 * d25 * d25 - 1.0) * d25;
        d25 = d3 * d7;
        d20 = 1.0 - d3 - d3;
        d20 = ((((d8 * d8 * 4.0 - 3.0) * d20 * d4 * d10 / 6.0 - d25) * d10 / 4.0 + d4) * d8 * d10 + d6) * d9 * d * d12;
        return d20;
    }
}

