/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;

public final class Intersection {
    private final Vec4 intersectionPoint;
    private final boolean isTangent;

    public Intersection(Vec4 vec4, boolean bl) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.IntersectionPointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intersectionPoint = vec4;
        this.isTangent = bl;
    }

    public final Vec4 getIntersectionPoint() {
        return this.intersectionPoint;
    }

    public final boolean isTangent() {
        return this.isTangent;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Intersection intersection = (Intersection)object;
        if (this.isTangent != intersection.isTangent) {
            return false;
        }
        return this.intersectionPoint.equals(intersection.intersectionPoint);
    }

    public int hashCode() {
        int n = this.intersectionPoint.hashCode();
        n = 29 * n + (this.isTangent ? 1 : 0);
        return n;
    }

    public String toString() {
        String string = "Intersection Point: " + this.intersectionPoint;
        String string2 = this.isTangent ? " is a tangent." : " not a tangent";
        return string + string2;
    }
}

