/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.PolarPoint;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUquadric;

public class Cylinder
implements Extent,
Renderable {
    private final Vec4 bottomCenter;
    private final Vec4 topCenter;
    private final Vec4 axisUnitDirection;
    private final double cylinderRadius;
    private final double cylinderHeight;

    public Cylinder(Vec4 vec4, Vec4 vec42, double d) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.EndPointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.Cylinder.RadiusIsZeroOrNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.bottomCenter = vec4;
        this.topCenter = vec42;
        this.cylinderHeight = this.bottomCenter.distanceTo3(this.topCenter);
        this.cylinderRadius = d;
        this.axisUnitDirection = this.topCenter.subtract3(this.bottomCenter).normalize3();
    }

    public Vec4 getAxisUnitDirection() {
        return this.axisUnitDirection;
    }

    public Vec4 getBottomCenter() {
        return this.bottomCenter;
    }

    public Vec4 getTopCenter() {
        return this.topCenter;
    }

    public double getCylinderRadius() {
        return this.cylinderRadius;
    }

    public double getCylinderHeight() {
        return this.cylinderHeight;
    }

    public String toString() {
        return this.cylinderRadius + ", " + this.bottomCenter.toString() + ", " + this.topCenter.toString() + ", " + this.axisUnitDirection.toString();
    }

    public Intersection[] intersect(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = line.getDirection();
        Vec4 vec42 = line.getOrigin();
        double d = vec4.x * vec4.x + vec4.y * vec4.y;
        double d2 = 2.0 * (vec42.x * vec4.x + vec42.y * vec4.y);
        double d3 = vec42.x * vec42.x + vec42.y * vec42.y - this.cylinderRadius * this.cylinderRadius;
        double d4 = Cylinder.discriminant(d, d2, d3);
        if (d4 < 0.0) {
            return null;
        }
        double d5 = Math.sqrt(d4);
        if (d4 == 0.0) {
            Vec4 vec43 = line.getPointAt((-d2 - d5) / (2.0 * d));
            return new Intersection[]{new Intersection(vec43, true)};
        }
        Vec4 vec44 = line.getPointAt((-d2 - d5) / (2.0 * d));
        Vec4 vec45 = line.getPointAt((-d2 + d5) / (2.0 * d));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (vec44.z >= 0.0 && vec44.z <= this.getHeight()) {
            bl = true;
            boolean bl5 = bl3 = vec44.z == 0.0;
        }
        if (vec45.z >= 0.0 && vec45.z <= this.getHeight()) {
            bl2 = true;
            bl4 = vec45.z == 0.0;
        }
        Intersection[] intersectionArray = null;
        if (bl && bl2) {
            intersectionArray = new Intersection[]{new Intersection(vec44, bl3), new Intersection(vec45, bl4)};
        } else if (bl) {
            intersectionArray = new Intersection[]{new Intersection(vec44, bl3)};
        } else if (bl2) {
            intersectionArray = new Intersection[]{new Intersection(vec45, bl4)};
        }
        return intersectionArray;
    }

    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = line.getDirection();
        Vec4 vec42 = line.getOrigin();
        double d = vec4.x * vec4.x + vec4.y * vec4.y;
        double d2 = 2.0 * (vec42.x * vec4.x + vec42.y * vec4.y);
        double d3 = vec42.x * vec42.x + vec42.y * vec42.y - this.cylinderRadius * this.cylinderRadius;
        double d4 = Cylinder.discriminant(d, d2, d3);
        return d4 >= 0.0;
    }

    private static double discriminant(double d, double d2, double d3) {
        return d2 * d2 - 4.0 * d * d3;
    }

    private double intersectsAt(Plane plane, double d, double d2) {
        boolean bl;
        double d3 = plane.dot(this.bottomCenter);
        boolean bl2 = d3 <= -d;
        Vec4 vec4 = d2 < 1.0 ? this.bottomCenter.add3(this.topCenter.subtract3(this.bottomCenter).multiply3(d2)) : this.topCenter;
        double d4 = plane.dot(vec4);
        boolean bl3 = bl = d4 <= -d;
        if (bl2 && bl) {
            return -1.0;
        }
        if (bl2 == bl) {
            return d2;
        }
        return d + plane.dot(this.bottomCenter) / plane.getNormal().dot3(this.bottomCenter.subtract3(vec4));
    }

    private double getEffectiveRadius(Plane plane) {
        double d = plane.getNormal().dot3(this.axisUnitDirection);
        double d2 = 1.0 - d * d;
        if (d2 <= 0.0) {
            return 0.0;
        }
        return this.cylinderRadius * Math.sqrt(d2);
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getEffectiveRadius(plane);
        double d2 = this.intersectsAt(plane, d, 1.0);
        return d2 >= 0.0;
    }

    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getEffectiveRadius(frustum.getNear());
        double d2 = this.intersectsAt(frustum.getNear(), d, 1.0);
        if (d2 < 0.0) {
            return false;
        }
        d2 = this.intersectsAt(frustum.getFar(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getLeft());
        d2 = this.intersectsAt(frustum.getLeft(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getRight());
        d2 = this.intersectsAt(frustum.getRight(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getTop());
        d2 = this.intersectsAt(frustum.getTop(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getBottom());
        d2 = this.intersectsAt(frustum.getBottom(), d, d2);
        return d2 >= 0.0;
    }

    public Vec4 getCenter() {
        Vec4 vec4 = this.bottomCenter;
        Vec4 vec42 = this.topCenter;
        return new Vec4((vec4.x + vec42.x) / 2.0, (vec4.y + vec42.y) / 2.0, (vec4.z + vec42.z) / 2.0);
    }

    public double getDiameter() {
        return 2.0 * this.getRadius();
    }

    public double getRadius() {
        double d = this.bottomCenter.distanceTo3(this.topCenter) / 2.0;
        return Math.sqrt(d * d + this.cylinderRadius * this.cylinderRadius);
    }

    public final double getHeight() {
        return this.cylinderHeight;
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = this.getCenter();
        PolarPoint polarPoint = PolarPoint.fromCartesian(vec4);
        GL gL = drawContext.getGL();
        gL.glPushAttrib(12288);
        gL.glBegin(1);
        gL.glVertex3d(this.bottomCenter.x, this.bottomCenter.y, this.bottomCenter.z);
        gL.glVertex3d(this.topCenter.x, this.topCenter.y, this.topCenter.z);
        gL.glEnd();
        gL.glEnable(2929);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glTranslated(this.bottomCenter.x, this.bottomCenter.y, this.bottomCenter.z);
        drawContext.getGL().glRotated(polarPoint.getLongitude().getDegrees(), 0.0, 1.0, 0.0);
        drawContext.getGL().glRotated(Math.abs(polarPoint.getLatitude().getDegrees()), Math.signum(polarPoint.getLatitude().getDegrees()) * -1.0, 0.0, 0.0);
        GLUquadric gLUquadric = drawContext.getGLU().gluNewQuadric();
        drawContext.getGLU().gluQuadricDrawStyle(gLUquadric, 100011);
        drawContext.getGLU().gluCylinder(gLUquadric, this.cylinderRadius, this.cylinderRadius, this.cylinderHeight, 30, 30);
        drawContext.getGLU().gluDeleteQuadric(gLUquadric);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }
}

