/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

public class TiffIFDEntry {
    int tag;
    int type;
    long count;
    byte[] values = new byte[4];

    public TiffIFDEntry(int n, int n2, long l, byte[] byArray) throws IllegalArgumentException {
        this.tag = n;
        this.type = n2;
        this.count = l;
        if (byArray == null || byArray.length != 4) {
            throw new IllegalArgumentException("bogus value/offset bytes passed to " + this.getClass().getName());
        }
        this.values = new byte[4];
        this.values[0] = byArray[0];
        this.values[1] = byArray[1];
        this.values[2] = byArray[2];
        this.values[3] = byArray[3];
    }

    public long asLong() throws IllegalStateException {
        if (this.type != 3 && this.type != 4) {
            throw new IllegalStateException("Attempt to access Tiff IFD-entry as int: tag/type=" + Long.toHexString(this.tag) + "/" + this.type);
        }
        return ((0xFF & this.values[3]) << 24) + ((0xFF & this.values[2]) << 16) + ((0xFF & this.values[1]) << 8) + (0xFF & this.values[0]);
    }
}

